-- Modified by Maxfunkey (aka Carambha of EU-Loardaeron) for patch 3.0.2 November 2nd 2008

if GetLocale() == "frFR" then
--------------------------------------------------------------------------------------------------------
--                                                Misc                                                --
--------------------------------------------------------------------------------------------------------

BINDING_HEADER_EXAMINER = "Examiner";
BINDING_NAME_EXAMINER_OPEN = "Ouvrir Examiner";
BINDING_NAME_EXAMINER_TARGET = "Inspecter la cible";
BINDING_NAME_EXAMINER_MOUSEOVER = "Inspecter Mouseover";

Examiner.Classification = {
	["worldboss"] = "Boss",
	["rareelite"] = "lite rare",
	["elite"] = "lite",
	["rare"] = "Rare",
};

ExScanner.SetBonusTokenActive = "^Complet : ";
ExScanner.ItemUseToken = "^Utiliser : ";

--------------------------------------------------------------------------------------------------------
--                                           Stat Patterns                                            --
--------------------------------------------------------------------------------------------------------

ExScanner.Patterns = {
	--  Base Stats  --
	{ p = "%+(%d+) Force", s = "STR" },
	{ p = "%+(%d+) Agilit", s = "AGI" },
	{ p = "%+(%d+) Endurance", s = "STA" },
	{ p = "Endurance %+(%d+)", s = "STA" }, -- WORKAROUND: Infused Amethyst (31116)
	{ p = "%+(%d+) Intelligence", s = "INT" },
	{ p = "%+(%d+) Esprit", s = "SPI" },
	{ p = "Armure : (%d+)", s = "ARMOR" },
	{ p = "%+(%d+) Armure", s = "ARMOR" },

	--  Resistances (Exclude the Resist-"ance" then it picks up armor patches as well)  --
	{ p = "%+(%d+)  la rsistance Arcane", s = "ARCANERESIST" },
	{ p = "%+(%d+)  la rsistance Feu", s = "FIRERESIST" },
	{ p = "%+(%d+)  la rsistance Nature", s = "NATURERESIST" },
	{ p = "%+(%d+)  la rsistance Givre", s = "FROSTRESIST" },
	{ p = "%+(%d+)  la rsistance Ombre", s = "SHADOWRESIST" },
	{ p = "%+(%d+)  toutes les rsistances", s = { "ARCANERESIST", "FIRERESIST", "NATURERESIST", "FROSTRESIST", "SHADOWRESIST" } },

	--  Equip: Other  --
	{ p = "Augmente de (%d+) le score de rsilience%.", s = "RESILIENCE" },

	{ p = "Augmente le score de dfense de (%d+)%.", s = "DEFENSE" },
	{ p = "%+(%d+) score de dfense", s = "DEFENSE" },
	{ p = "Score de dfense augment de (%d+)%.", s = "DEFENSE" },

	{ p = "Augmente de (%d+) le score d'esquive%.", s = "DODGE" },
	{ p = "%+(%d+) score d'esquive", s = "DODGE" },
	{ p = "Augmente votre score d'esquive de (%d+)%.", s = "DODGE" },

	{ p = "Augmente de (%d+) le score de parade%.", s = "PARRY" },
	{ p = "Augmente votre score de parade de (%d+)%.", s = "PARRY" },

	{ p = "Augmente de (%d+) le score de blocage%.", s = "BLOCK" },
	{ p = "%+(%d+) score de blocage", s = "BLOCK" },
	{ p = "Augmente votre score de blocage de (%d+)%.", s = "BLOCK" },

	{ p = "Augmente la valeur de blocage de votre bouclier de (%d+)%.", s = "BLOCKVALUE" },
	{ p = "Bloquer : (%d+)", s = "BLOCKVALUE" },

	--  Equip: Melee & Ranged & Magic  --
	{ p = "Augmente de (%d+) le score de coup critique%.", s = "CRIT", "SPELLCRIT" },
	{ p = "Augmente votre score de coup critique de (%d+)%.", s = "CRIT", "SPELLCRIT" },
	{ p = "+(%d+) score de coup critique%.", s = "CRIT", "SPELLCRIT" },
	{ p = "Augmente de (%d+) le score de toucher%.", s = "HIT", "SPELLHIT" },
	{ p = "Augmente votre score de toucher de (%d+)%.", s = "HIT", "SPELLHIT" },
	{ p = "+(%d+) score de toucher de toucher%.", s = "HIT", "SPELLHIT" },
	{ p = "Augmente de (%d+) le score de hte%.", s = "HASTE", "SPELLHASTE" },
	{ p = "Augmente votre score de hte de (%d+)%.", s = "HASTE", "SPELLHASTE" },
	{ p = "+(%d+) score de hte%.", s = "HASTE", "SPELLHASTE" },

                   -- Equip: melee & Raged
	{ p = "Augmente de (%d+) la puissance d'attaque%.", s = "AP" },
	{ p = "+(%d+) puissance d'attaque%.", s = "AP" },
	{ p = "Augmente la puissance des attaques  distance de (%d+)%.", s = "RAP" },
	{ p = "+(%d+) puissance d'attaque  distance%.", s = "RAP" },
	{ p = "Augmente de (%d+) la puissance d'attaque pour les formes de flin, d'ours, d'ours redoutable et de slnien uniquement%.", s = "APFERAL" },


	{ p = "Augmente votre score d'expertise de (%d+)%.", s = "EXPERTISE" },
	{ p = "%+(%d+) score d'expertise", s = "EXPERTISE" },
	{ p = "Vos attaques ignorent (%d+) points de l'armure de votre adversaire%.", s = "ARMORPENETRATION" },

	--  Equip: Magic --



	{ p = "Augmente la pntration de vos sorts de (%d+)%.", s = "SPELLPENETRATION" },

	{ p = "Augmente la puissance des sorts de (%d+)%.", s = { "HEAL", "SPELLDMG" } }, -- New 3.0 spellpower
	{ p = "Augmente les dgts et les soins produits par les sorts et effets magiques de (%d+) au maximum%.", s = { "SPELLDMG", "HEAL" } }, -- No longer used in 3.0+ but due to some inconsistencies the formulation may have remained in some cases
	{ p = "Augmente lgrement la puissance des sorts.%.", s = { "SPELLDMG", "HEAL" }, v = 6 },

	{ p = "dgts infligs par les sorts et effets des Arcanes de (%d+) au maximum%.", s = "ARCANEDMG" },
	{ p = "dgts infligs par les sorts et effets de Feu de (%d+) au maximum%.", s = "FIREDMG" },
	{ p = "dgts infligs par les sorts et effets de Nature de (%d+) au maximum%.", s = "NATUREDMG" },
	{ p = "dgts infligs par les sorts et effets de Givre de (%d+) au maximum%.", s = "FROSTDMG" },
	{ p = "dgts infligs par les sorts et effets d'Ombre de (%d+) au maximum%.", s = "SHADOWDMG" },
	{ p = "dgts infligs par les sorts et effets du Sacr (%d+) au maximum%.", s = "HOLYDMG" },

	--  Health & Mana Per 5 Sec  --
	{ p = "(%d+) points de mana toutes les 5 sec", s = "MP5" },
	{ p = "%+(%d+)  la rgn. de mana", s = "MP5" },
	{ p = "%+(%d+) Rgn. de mana", s = "MP5" },

	{ p = "Rend (%d+) points de vie toutes les 5 sec%.", s = "HP5" },

	--  Enchants / Gems / Socket Bonuses / Mixed / Misc  --
	{ p = "^%+(%d+) PV$", s = "HP" },
	{ p = "^%+(%d+) points de vie$", s = "HP" },
	{ p = "^%+(%d+) points de mana$", s = "MP" },

	{ p = "^Vitalit$", s = { "MP5", "HP5" }, v = 4 },
	{ p = "^Sauvagerie$", s = "AP", v = 70 },
	{ p = "^Pied sr$", s = "HIT", v = 10 },
	{ p = "^me de givre$", s = { "FROSTDMG", "SHADOWDMG" }, v = 54 },
	{ p = "^Feu solaire$", s = { "ARCANEDMG", "FIREDMG" }, v = 50 },

	{ p = "%+(%d+)  toutes les caractristiques", s = { "STR", "AGI", "STA", "INT", "SPI" } },

	{ p = "%+(%d+) au score de rsilience", s = "RESILIENCE" },
	{ p = "%+(%d+) au score d'esquive", s = "DODGE" },
	{ p = "%+(%d+) au score de parade", s = "PARRY" },
	{ p = "%+(%d+) au score de dfense", s = "DEFENSE" },

	{ p = "%+(%d+)  la puissance d'attaque", s = "AP" },

	{ p = "%+(%d+) au score de coup critique|r$", s = "CRIT", "SPELLCRIT" },
	{ p = "%+(%d+) au score de coup critique et", s = "CRIT", "SPELLCRIT" },
	{ p = "%+(%d+) au score de coup critique$", s = "CRIT", "SPELLCRIT" },
	{ p = "%+(%d+) au score de critique$", s = "CRIT", "SPELLCRIT" },
	{ p = "%+(%d+) au score de toucher|r$", s = "HIT", "SPELLHIT" },
	{ p = "%+(%d+) au score de toucher$", s = "HIT", "SPELLHIT" },

	{ p = "%+(%d+) aux sorts de soins", s = "HEAL"},
	{ p = "%+(%d+) aux soins", s = "HEAL"},
	{ p = "%+(%d+)  la puissance des sorts", s = "SPELLDMG", "HEAL" },


	{ p = "%+(%d+)  la pntration des sorts", s = "SPELLPENETRATION" },


	{ p = "%+(%d+) aux  dgts des sorts des Arcanes", s = "ARCANEDMG" },
	{ p = "%+(%d+) aux dgts des sorts de Feu", s = "FIREDMG" },
	{ p = "%+(%d+) aux dgts des sorts de Nature", s = "NATUREDMG" },
	{ p = "%+(%d+) aux dgts des sorts de Givre", s = "FROSTDMG" },
	{ p = "%+(%d+) aux dgts des sorts d'Ombre", s = "SHADOWDMG" },
	{ p = "%+(%d+) aux dgts des sorts du Sacr", s = "HOLYDMG" },

--[[	{ p = "%+(%d+) S?h?i?e?l?d? ?Block Rating", s = "BLOCK" }, -- Combined Pattern: Covers [Shield Enchant] [Socket Bonus]

	{ p = "%+(%d+) Block Value", s = "BLOCKVALUE" },

	{ p = "%+(%d+) Ranged Attack Power", s = "RAP" },
	{ p = "%+(%d+) Haste Rating", s = "HASTE" },
	{ p = "%+(%d+) Expertise Rating", s = "EXPERTISE" },

	{ p = "%+(%d+) Weapon Damage", s = "WPNDMG" },-]]
	{ p = "^Lunette %(%+(%d+) .* de dgts%)$", s = "RANGEDDMG" },

	-- Demon's Blood
	{ p = "Augmente le score de dfense de 5, la rsistance  l'Ombre de 10 et votre rgnration des points de vie normale de 3%.", s = { "DEFENSE", "SHADOWRESIST", "HP5" }, v = { 5, 10, 3 } },

	-- Void Star Talisman (Warlock T5 Class Trinket)
	{ p = "Augmente les rsistances de votre familier de 130 et votre puissance des sorts de 48 au maximum%.", s = "SPELLDMG", v = 48 },

};

--------------------------------------------------------------------------------------------------------
--                                        Stat Order & Naming                                         --
--------------------------------------------------------------------------------------------------------

Examiner.StatEntryOrder = {
	{ name = "Stats de base", stats = {"STR", "AGI", "STA", "INT", "SPI", "ARMOR"} },
	{ name = "Vie & Mana", stats = {"HP", "MP", "HP5", "MP5"} },
	{ name = "Stats en mle &  distance", stats = {"AP", "RAP", "APFERAL", "CRIT", "HIT", "HASTE", "WPNDMG", "RANGEDDMG", "ARMORPENETRATION", "EXPERTISE"} },
	{ name = "Stats des sorts", stats = {"HEAL", "SPELLDMG", "ARCANEDMG", "FIREDMG", "NATUREDMG", "FROSTDMG", "SHADOWDMG", "HOLYDMG", "SPELLCRIT", "SPELLHIT", "SPELLHASTE", "SPELLPENETRATION"} },
	{ name = "Stats dfensives", stats = {"DEFENSE", "DODGE", "PARRY", "BLOCK", "BLOCKVALUE", "RESILIENCE"} },
};

ExScanner.StatNames = {
	["STR"] = "Force",
	["AGI"] = "Agilit",
	["STA"] = "Endurance",
	["INT"] = "Intelligence",
	["SPI"] = "Esprit",

	["ARMOR"] = "Armure",

	["ARCANERESIST"] = "Rsistance aux Arcanes",
	["FIRERESIST"] = "Rsistance au Feu",
	["NATURERESIST"] = "Rsistance  la Nature",
	["FROSTRESIST"] = "Rsistance au Givre",
	["SHADOWRESIST"] = "Rsistance  l'Ombre",

	["DODGE"] = "Score d'esquive",
	["PARRY"] = "Score de parade",
	["DEFENSE"] = "Score de dfense",
	["BLOCK"] = "Score de blocage",
	["BLOCKVALUE"] = "Valeur de blocage",
	["RESILIENCE"] = "Score de rsilience",

	["AP"] = "Puissance d'attaque",
	["RAP"] = "Puissance d'attaque  distance",
	["APFERAL"] = "Puissance d'attaque (Farouche)",
	["CRIT"] = "Score de critique",
	["HIT"] = "Score de toucher",
	["HASTE"] = "Score de hte",
	["WPNDMG"] = "Dgts de l'arme",
	["RANGEDDMG"] = "Dgts  distance",
	["ARMORPENETRATION"] = "Pntration de l'armure",
	["EXPERTISE"] = "Score d'expertise",

	["SPELLCRIT"] = "Score de critique des sorts",
	["SPELLHIT"] = "Score de toucher des sorts",
	["SPELLHASTE"] = "Score de hte des sorts",
	["SPELLPENETRATION"] = "Pntration des sorts",

	["HEAL"] = "Soins",
	["SPELLDMG"] = "Dgts des sorts",
	["ARCANEDMG"] = "Dgts des sorts (Arcanes)",
	["FIREDMG"] = "Dgts des sorts (Feu)",
	["NATUREDMG"] = "Dgts des sorts (Nature)",
	["FROSTDMG"] = "Dgts des sorts (Givre)",
	["SHADOWDMG"] = "Dgts des sorts (Ombre)",
	["HOLYDMG"] = "Dgts des sorts (Sacr)",

	["HP"] = "Points de vie",
	["MP"] = "Points de mana",

	["HP5"] = "Rgn. vie par 5 sec",
	["MP5"] = "Rgn. mana par 5 sec",
};
end
