--------------------------------------------------------------------------------------------------------
--                                                Misc                                                --
--------------------------------------------------------------------------------------------------------

if (GetLocale() == "ruRU") then

BINDING_HEADER_EXAMINER = "Examiner";
BINDING_NAME_EXAMINER_OPEN = "Открыть Examiner";
BINDING_NAME_EXAMINER_TARGET = "Осмотреть цель";
BINDING_NAME_EXAMINER_MOUSEOVER = "Осмотреть цель под курсором";

Examiner.Classification = {
	["worldboss"] = BOSS,
	["rareelite"] = "Редкий элитный",
	["elite"] = ELITE,
	["rare"] = "Редкий",
};

ExScanner.SetBonusTokenActive = "^Комплект: ";
ExScanner.ItemUseToken = "^Использование: ";

--------------------------------------------------------------------------------------------------------
--                                           Stat Patterns                                            --
--------------------------------------------------------------------------------------------------------

ExScanner.Patterns = {
	--  Base Stats  --
	{ p = "%+(%d+) к силе$", s = "STR" },
    { p = "%+(%d+) к ловкости", s = "AGI" },
    { p = "%+(%d+) к выносливости", s = "STA" },
    { p = "%+(%d+) к интеллекту", s = "INT" },
    { p = "%+(%d+) к духу", s = "SPI" },
    { p = "Броня: (%d+)", s = "ARMOR" }, -- Should catch all armor: Base armor, Armor enchants, Armor kits
	
	{ p = "Сила (%d+)", s = "STR" },
	{ p = "Ловкость (%d+)", s = "AGI" },
	{ p = "Выносливость (%d+)", s = "STA" },
	{ p = "Интеллект (%d+)", s = "INT" },
	{ p = "Дух (%d+)", s = "SPI" },
	{ p = "Броня (%d+)", s = "ARMOR" }, -- Should catch all armor: Base armor, Armor enchants, Armor kits

	--  Resistances (Exclude the Resist-"ance" then it picks up armor patches as well)  --
	{ p = "%+(%d+) к сопротивлению тайной магии", s = "ARCANERESIST" },
	{ p = "%+(%d+) к сопротивлению огню", s = "FIRERESIST" },
	{ p = "%+(%d+) к сопротивлению силам природы", s = "NATURERESIST" },
	{ p = "%+(%d+) к сопротивлению магии льдя", s = "FROSTRESIST" },
	{ p = "%+(%d+) к сопротивлению темной магии", s = "SHADOWRESIST" },
	{ p = "%+(%d+) ко всем видам сопротивления", s = { "ARCANERESIST", "FIRERESIST", "NATURERESIST", "FROSTRESIST", "SHADOWRESIST" } },
	{ p = "%+(%d+) к сопротивлению всему", s = { "ARCANERESIST", "FIRERESIST", "NATURERESIST", "FROSTRESIST", "SHADOWRESIST" } }, -- Void Sphere

	--  Equip: Other  --
	{ p = "Рейтинг устойчивости %+(%d+)%.", s = "RESILIENCE" },

	{ p = "Рейтинг защиты %+(%d+)%.", s = "DEFENSE" },
	{ p = "Рейтинг уклонения %+(%d+)%.", s = "DODGE" },
	{ p = "Рейтинг парирования %+(%d+)%.", s = "PARRY" },
	{ p = "Рейтинг блокирования щитом %+(%d+).", s = "BLOCK" }, -- Should catch both new and old style

	{ p = "Увеличивает показатель блокирования вашего щита на (%d+)% ед.", s = "BLOCKVALUE" },
	{ p = "Блокирование: (%d+)", s = "BLOCKVALUE" }, -- Should catch only base block value from a shield 

	--  Equip: Melee & Ranged  --
	{ p = "Увеличивает силу атаки на (%d+)%.", s = "AP" },
	{ p = "Увеличивает силу атаки дальнего боя на (%d+)%.", s = "RAP" },
	{ p = "Увеличивает силу атака на (%d+) в облике кошки, медведя, лютого медведя или лунного совуха%.", s = "APFERAL" },

	{ p = "Рейтинг мастерства %+(%d+)%.", s = "EXPERTISE" }, -- New 2.3 Stat
	{ p = "Увеличивает рейтинг пробивания брони на (%d+)%.", s = "ARMORPENETRATION" }, -- Armor Penetration in 3.0

	--  Equip: Spell Power  --
	{ p = "Увеличивает проникающую способность заклинаний на (%d+)%.", s = "SPELLPENETRATION" },

	{ p = "Увеличивает силу заклинаний на (%d+)%.", s = { "HEAL", "SPELLDMG" } },
	{ p = "Увеличивает силу заклинаний на (%d+) ед%.", s = { "HEAL", "SPELLDMG" } },
	{ p = "Слегка увеличивает силу заклинаний%.", s = { "HEAL", "SPELLDMG" }, v = 6 }, -- Bronze Band of Force

	{ p = "Увеличивает силу заклинаний тайной магии на (%d+)%.", s = "ARCANEDMG" },
	{ p = "Увеличивает силу заклинаний магии огня на (%d+)%.", s = "FIREDMG" },
	{ p = "Увеличивает силу заклинаний магии природы на (%d+)%.", s = "NATUREDMG" },
	{ p = "Увеличивает силу заклинаний магии льда на (%d+)%.", s = "FROSTDMG" },
	{ p = "Увеличивает силу заклинаний темной магии на (%d+)%.", s = "SHADOWDMG" },
	{ p = "Увеличивает силу заклинаний светлой магии на (%d+)%.", s = "HOLYDMG" },

	--  Equip: Stats Which Improves Both Spells & Melee  --
	{ p = "Повышает рейтинг критического удара на (%d+)%.", s = { "CRIT", "SPELLCRIT" } },
	{ p = "Увеличение рейтинга критического эффекта на (%d+)%.", s = { "CRIT", "SPELLCRIT" } },
	{ p = "Увеличение вероятности нанесения критического урона на (%d+)%.", s = { "CRIT", "SPELLCRIT" } },
	{ p = "Рейтинг критического удара %+(%d+)%.", s = { "CRIT", "SPELLCRIT" } },
	--{ p = "Increases your hit rating by (%d+)%.", s = { "HIT", "SPELLHIT" } },
	{ p = "Повышает рейтинг меткости на (%d+)%.", s = { "HIT", "SPELLHIT" } },
	{ p = "Повышение рейтинга меткости заклинаний на (%d+)%.", s = { "SPELLHIT" } },
	{ p = "Рейтинг меткости %+(%d+)%.", s = { "HIT", "SPELLHIT" } },

	{ p = "Рейтинг скорости боя %+(%d+)%.", s = { "HASTE", "SPELLHASTE" } },
	{ p = "Рейтинг скорости %+(%d+)%.", s = { "HASTE", "SPELLHASTE" } },

	--  Health & Mana Per 5 Sec  --
	{ p = "(%d+) ед. здоровья раз в 5 sec%.", s = "HP5" },
	{ p = "%+(%d+) ед. здоровья каждые 5 секунд", s = "HP5" },
	{ p = "(%d+) [Hh]ealth per 5 sec%.", s = "HP5" },

	{ p = "%+(%d+) Mana Regen", s = "MP5" }, -- Scryer Shoulder Enchant, Priest ZG Enchant
	{ p = "%+(%d+) ед. маны каждые 5 секунд", s = "MP5" }, -- Magister's Armor Kit
	{ p = "(%d+) ед. маны раз в 5 секунд", s = "MP5" },

	{ p = "Mana Regen (%d+) per 5 sec%.", s = "MP5" }, -- Bracer Enchant
	{ p = "%+(%d+) Mana/5 seconds", s = "MP5" }, -- Some WotLK Shoulder Enchant, unsure which
	{ p = "%+(%d+) маны каждые 5 секунд", s = "MP5" },
	{ p = "Восполнение (%d+) ед. маны в 5 секунд", s = "MP5" },

	{ p = "(%d+) [Mm]ana [Pp]er 5 [Ss]ec%.|-r-$", s = "MP5" }, -- Combined Pattern: Covers [Equip Bonuses] [Socket Bonuses] --- Added "|-r-$" to avoid confusing on item 33502
	{ p = "%+(%d+) к мане каждые 5 секунд", s = "MP5" }, -- Combined Pattern: Covers [Chest Enchant] [Gem: Dazzling Deep Peridot] [Various Gems]

	--  Enchants / Gems / Socket Bonuses / Mixed / Misc  --
	{ p = "^%+(%d+) HP$", s = "HP" },
	{ p = "^%+(%d+) Health$", s = "HP" },
	{ p = "^%+(%d+) Mana$", s = "MP" },

	{ p = "^Живучесть$", s = { "MP5", "HP5" }, v = 4 },
	{ p = "^Свирепость$", s = "AP", v = 70 },
	{ p = "^Верный шаг$", s = "HIT", v = 10 }, -- Az: does this increase spell hit rating now as well?
	{ p = "^Ледяная душа$", s = { "FROSTDMG", "SHADOWDMG" }, v = 54 },
	{ p = "^Солнечный огонь$", s = { "ARCANEDMG", "FIREDMG" }, v = 50 },
	{ p = "^Ледопроходец$", s = { "CRIT", "HIT" }, v = 12 },
	{ p = "^Точность$", s = { "CRIT", "HIT" }, v = 25 },

	{ p = "%+(%d+) ко всем характеристикам", s = { "STR", "AGI", "STA", "INT", "SPI" } }, -- Chest + Bracer Enchant

	{ p = "%+(%d+) к урону от заклинаний тайной магии", s = "ARCANEDMG" },
	{ p = "%+(%d+) к урону от заклинаний огня", s = "FIREDMG" },
	{ p = "%+(%d+) к урону от сил природы", s = "NATUREDMG" },
	{ p = "%+(%d+) к урону от заклинаний магии льда", s = "FROSTDMG" },
	{ p = "%+(%d+) к урону от заклинаний темной магии", s = "SHADOWDMG" },
	{ p = "%+(%d+) к урону от заклинаний светлой магии", s = "HOLYDMG" },

	{ p = "%+(%d+) к защите", s = "DEFENSE" }, -- Exclude "Rating" from this pattern due to Paladin ZG Enchant
	{ p = "%+(%d+) к рейтингу защиты", s = "DEFENSE" },
	{ p = "%+(%d+) к рейтингу уклонения", s = "DODGE" },
	{ p = "%+(%d+) к рейтингу парирования", s = "PARRY" },
	{ p = "%+(%d+) к рейтингу блока ?щ?и?т?о?м?", s = "BLOCK" }, -- Combined Pattern: Covers [Shield Enchant] [Socket Bonus]
	{ p = "%+(%d+) к рейтингу блока", s = "BLOCK" },
	{ p = "%+(%d+) к блокированию ?щ?и?т?о?м?", s = "BLOCK" }, --id 2583,
	{ p = "%+(%d+) к блоку", s = "BLOCKVALUE" }, -- id 2975, 2888

	{ p = "%+(%d+) Block Value", s = "BLOCKVALUE" },

	{ p = "%+(%d+) к силе атаки", s = "AP" },
	{ p = "%+(%d+) к силе атаки дальнего боя", s = "RAP" },
	{ p = "%+(%d+) к рейтингу меткости", s = { "HIT", "SPELLHIT" } },
	{ p = "%+(%d+) к рейтингу критического удара", s = { "CRIT", "SPELLCRIT" } },
	{ p = "%+(%d+) Critical S?t?r?i?k?e? ?Rating", s = { "CRIT", "SPELLCRIT" } }, -- Matches two versions, with/without "Strike". No "Strike" on "Unstable Citrine".
	{ p = "%+(%d+) к ?р?е?й?т?и?н?г?у? устойчивости", s = "RESILIENCE" },
	{ p = "%+(%d+) к рейтингу скорости", s = "HASTE" },
	{ p = "%+(%d+) к рейтингу мастерства", s = "EXPERTISE" },

	{ p = "%+(%d+) к силе заклинаний", s = { "SPELLDMG", "HEAL" } }, -- Was used in a few items/gems before WotLK, but is now the permanent spell pattern
	{ p = "%+(%d+) Spell Hit", s = "SPELLHIT" }, -- Exclude "Rating" from this pattern to catch Mage ZG Enchant
	{ p = "%+(%d+) Spell Crit Rating", s = "SPELLCRIT" },
--	{ p = "%+(%d+) Spell Critical S?t?r?i?k?e? ?Rating", s = "SPELLCRIT" }, -- Matches two versions, with/without "Strike"
	{ p = "%+(%d+) Spell Critical ", s = "SPELLCRIT" }, -- Matches three versions, with Strike + Rating, with Rating, and without any suffix at all
	{ p = "%+(%d+) Spell Haste Rating", s = "SPELLHASTE" }, -- Found on gems
	{ p = "%+(%d+) к проникающей способности заклинаний", s = "SPELLPENETRATION" },

	-- Should no longer be relavent for WotLK, but keeping them in case something turns up on enchants I've yet to see
--	{ p = "%+(%d+) Healing", s = "HEAL" }, -- Has to appear before patterns with a SPELLDMG entry, due to the workaround
--	{ p = "%+(%d+) Healing and Spell Damage", s = "SPELLDMG" }, -- Warlock ZG Enchant (Healing will be caught by the pattern above)
--	{ p = "Spell Damage %+(%d+)", s = { "SPELLDMG", "HEAL" } }, -- WORKAROUND: Infused Amethyst (31116)
--	{ p = "%+(%d+) Spell Damage", s = { "SPELLDMG", "HEAL" } },
--	{ p = "%+(%d+) Damage and Healing Spells", s = { "SPELLDMG", "HEAL" } },
--	{ p = "%+(%d+) Damage Spells", s = "SPELLDMG" }, -- New 2.3: Damage part of the previously "+Healing" enchants

	{ p = "%+(%d+) к урону оружием", s = "WPNDMG" }, -- Added optional space as I found a "+1  Weapon Damage" enchant on someone
	{ p = "^Прицел %(%+(%d+) урону%)$", s = "RANGEDDMG" },

	-- Demon's Blood
	{ p = "Увеличивает рейтинг защиты на 5, сопротивления темной магии – на 10 ед. и скорости восполнения здоровья – на 3%.", s = { "DEFENSE", "SHADOWRESIST", "HP5" }, v = { 5, 10, 3 } },

	-- Void Star Talisman (Warlock T5 Class Trinket)
	{ p = "Увеличивает сопротивление прислужника магии на 130, а вашу силу заклинаний – на 48%.", s = "SPELLDMG", v = 48 },

	-- Temp Enchants (Disabled as they are not part of "gear" stats)
	--{ p = "Minor Mana Oil", s = "MP5", v = 4 },
	--{ p = "Lesser Mana Oil", s = "MP5", v = 8 },
	--{ p = "Superior Mana Oil", s = "MP5", v = 14 },
	--{ p = "Brilliant Mana Oil", s = { "MP5", "HEAL" }, v = { 12, 25 } },

	--{ p = "Minor Wizard Oil", s = "SPELLDMG", v = 8 },
	--{ p = "Lesser Wizard Oil", s = "SPELLDMG", v = 16 },
	--{ p = "Wizard Oil", s = "SPELLDMG", v = 24 },
	--{ p = "Superior Wizard Oil", s = "SPELLDMG", v = 42 },
	--{ p = "Brilliant Wizard Oil", s = { "SPELLDMG", "SPELLCRIT" }, v = { 36, 14 } },

	-- Future Patterns (Disabled)
	--{ p = "When struck in combat inflicts (%d+) .+ damage to the attacker.", s = "DMGSHIELD" },
};

--------------------------------------------------------------------------------------------------------
--                                        Stat Order & Naming                                         --
--------------------------------------------------------------------------------------------------------

Examiner.StatEntryOrder = {
	{ name = "Основные", stats = {"STR", "AGI", "STA", "INT", "SPI", "ARMOR"} },
	{ name = "Жизни и мана", stats = {"HP", "MP", "HP5", "MP5"} },
	{ name = "Ближний и дальний бой", stats = {"AP", "RAP", "APFERAL", "CRIT", "HIT", "HASTE", "WPNDMG", "RANGEDDMG", "ARMORPENETRATION", "ARMORPENETRATIONRATING", "EXPERTISE"} },
	{ name = "Магия", stats = {"HEAL", "SPELLDMG", "ARCANEDMG", "FIREDMG", "NATUREDMG", "FROSTDMG", "SHADOWDMG", "HOLYDMG", "SPELLCRIT", "SPELLHIT", "SPELLHASTE", "SPELLPENETRATION"} },
	{ name = "Защита", stats = {"DEFENSE", "DODGE", "PARRY", "BLOCK", "BLOCKVALUE", "RESILIENCE"} },
};

ExScanner.StatNames = {
	["STR"] = "Сила",
	["AGI"] = "Ловкость",
	["STA"] = "Выносливость",
	["INT"] = "Интеллект",
	["SPI"] = "Дух",

	["ARMOR"] = "Броня",

    ["ARCANERESIST"] = "Сопротивление Тайной магии",
    ["FIRERESIST"] = "Сопротивление огню",
    ["NATURERESIST"] = "Сопротивление природе",
    ["FROSTRESIST"] = "Сопротивление льду",
    ["SHADOWRESIST"] = "Сопротивление темной магии",

    ["DODGE"] = "Рейтинг уклонения",
    ["PARRY"] = "Рейтинг парирования",
    ["DEFENSE"] = "Рейтинг защиты",
    ["BLOCK"] = "Рейтинг блокирования",
    ["BLOCKVALUE"] = "Показатель блока щитом",
    ["RESILIENCE"] = "Рейтинг устойчивости",

    ["AP"] = "Сила атаки",
    ["RAP"] = "Сила атаки дальнего боя",
    ["APFERAL"] = "Сила атаки(зверь)",
    ["CRIT"] = "Рейтинг крит. удара",
    ["HIT"] = "Рейтинг меткости",
    ["HASTE"] = "Рейтинг скорости",
    ["WPNDMG"] = "К урону оружием",
    ["RANGEDDMG"] = "К урону дальнего боя",
    ["ARMORPENETRATION"] = "Игнорирование брони",
    ["EXPERTISE"] = "Рейтинг мастерства",

    ["SPELLCRIT"] = "Рейтинг крит. удара заклинаниями",
    ["SPELLHIT"] = "Рейтинг меткости заклинания",
    ["SPELLHASTE"] = "Рейтинг скорости",
    ["SPELLPENETRATION"] = "Проникновение заклинаний",

    ["HEAL"] = "Лечение",
    ["SPELLDMG"] = "Урон заклинаниями",
    ["ARCANEDMG"] = "Урон заклинаниями (тайная магия)",
    ["FIREDMG"] = "Урон заклинаниями (огонь)",
    ["NATUREDMG"] = "Урон заклинаниями (природа)",
    ["FROSTDMG"] = "Урон заклинаниями (лед)",
    ["SHADOWDMG"] = "Урон заклинаниями (темная магия)",
    ["HOLYDMG"] = "Урон заклинаниями (свет)",

	["HP"] = "Жизни",
	["MP"] = "Мана",

    ["HP5"] = "Регенерация здоровья",
    ["MP5"] = "Восстановление маны",
};
end
