-- Elsia: This handles filters for zones/instances

function Recount:SetZoneFilter(instanceType)
	
	if not instanceType then return end
	
	if Recount.db.profile.ZoneFilters[instanceType] then
		if Recount.db.profile.HideCollect and not Recount.CurrentDataCollect then
			Recount.MainWindow:Show()
			Recount:RefreshMainWindow()
		end
		Recount.CurrentDataCollect = true
	else
		if Recount.db.profile.HideCollect and Recount.CurrentDataCollect then
			Recount.MainWindow:Hide()
		end
		Recount.CurrentDataCollect = false
	end
end

-- Elsia: This handles filters for groupings

-- groupType: 0 solo, 1 party, 2 raid

function Recount:SetGroupFilter(groupType)

	 if Recount.db.profile.GroupFilters[groupType] then
		if Recount.db.profile.HideCollect and not Recount.CurrentDataCollect then
			Recount.MainWindow:Show()
			Recount:RefreshMainWindow()
		end
		Recount.CurrentDataCollect = true
	else
		if Recount.db.profile.HideCollect and Recount.CurrentDataCollect then
			Recount.MainWindow:Hide()
		end
		Recount.CurrentDataCollect = false
	 end
end


-- Elsia: This handles the combined case of group/zone filtering

function Recount:SetZoneGroupFilter(instanceType,groupType)
	
	if not instanceType or not groupType then return end
	
	if Recount.db.profile.ZoneFilters[instanceType] and Recount.db.profile.GroupFilters[groupType] then
		if Recount.db.profile.HideCollect and not Recount.MainWindow:IsShown() then
			Recount.MainWindow:Show()
			Recount:RefreshMainWindow()
		end
		Recount.CurrentDataCollect = true
	else
		if Recount.db.profile.HideCollect and Recount.MainWindow:IsShown() then
			Recount.MainWindow:Hide()
		end
		Recount.CurrentDataCollect = false
	end
end


-- Elsia: Main entry, call this to update main window visibility based on collection filters.

function Recount:UpdateZoneGroupFilter()
	local groupType, instanceType

	if Recount.inRaid then
	   groupType = 3
	elseif Recount.inGroup then
	   groupType = 2
	else
	   groupType = 1
	end

	_, instanceType = IsInInstance()
	if not UnitIsGhost(Recount.PlayerName) then Recount:SetZoneGroupFilter(instanceType, groupType) end -- Use zone-based filters.
end

function Recount:GetGroupState(groupType)
	 if groupType == 3 then
	    	return Recount.inRaid
	 elseif groupType == 2 then
	 	return not Recount.inRaid and Recount.inGroup
	 else
		return not Recount.inRaid and not Recount.inGroup 
	 end
end