local numSpellButtons = 14
local selectedSpells = {}

local trees = {"DMG", "HEAL", "PET"}

function CritlineAnnounce_CreateSpellButtons(self)
	local button, name
	name = self:GetName().."Button"
	for i = 1, numSpellButtons do
		button = CreateFrame("CheckButton", name..i, self, "CritlineListItemTemplate")
		if i == 1 then
			button:SetPoint("TOPLEFT")
		else
			button:SetPoint("TOP", name..(i - 1), "BOTTOM", 0, 4)
		end
	end
	
	self:SetWidth(300)
	self:SetHeight(numSpellButtons * 22 + 8)
end


function CritlineAnnounce_CreateChannel(curValue, curText)
	local tex = {
		text = curText,
		value = curValue,
		func = function()
			UIDropDownMenu_SetSelectedValue(CritlineAnnounceFrameChannel, curValue)
			if curValue == 15 then
				CritlineAnnounceFrameTarget:Show()
				CritlineAnnounceFrameTarget:SetFocus()
			else
				CritlineAnnounceFrameTarget:Hide()
			end
		end
	}
	UIDropDownMenu_AddButton(tex)
end


function CritlineAnnounce_SendAnnounce()
	local norm,	crit, normcrit, mychan
	local mychanID = UIDropDownMenu_GetSelectedValue(CritlineAnnounceFrameChannel)
	local selectedTree = trees[UIDropDownMenu_GetSelectedValue(CritlineAnnounceFrameTree)]
	
	if mychanID == 0 or mychanID == nil then
		Critline_Message("Critline Announce: "..CL_ANNOUNCE_MISSINGCHANNEL_TEXT..".")
		return
	end 
	
	if mychanID == 11 then
		mychan = "GUILD"
	elseif mychanID == 12 then
		mychan = "PARTY"
	elseif mychanID == 13 then
		mychan = "RAID"
	elseif mychanID == 14 then
		mychan = "SAY"
	elseif mychanID == 15 then
		mychan = "WHISPER"
		mychanID = CritlineAnnounceFrameTarget:GetText()
		if mychanID == "" then
			Critline_Message("Critline Announce: "..CL_ANNOUNCE_BADPLAYER_TEXT..".")
			return
		end
	else
		mychan = "CHANNEL"
	end
	
	for i = 1, #selectedSpells do
		norm = nil
		crit = nil
		if CL_DATABASE[selectedTree][selectedSpells[i]]["NORM"] then
			norm = CL_DATABASE[selectedTree][selectedSpells[i]]["NORM"]["Amount"]
		end
		if CL_DATABASE[selectedTree][selectedSpells[i]]["CRIT"] then
			crit = CL_DATABASE[selectedTree][selectedSpells[i]]["CRIT"]["Amount"]
		end
		if norm and crit then
			normcrit = CL_NORMAL_TEXT..": "..norm.." "..CL_CRIT_TEXT..": "..crit
		elseif norm then
			normcrit = CL_NORMAL_TEXT..": "..norm.." "..CL_CRIT_TEXT..": N/A"
		elseif crit then
			normcrit = CL_NORMAL_TEXT..": N/A "..CL_CRIT_TEXT..": "..crit
		end
		SendChatMessage(selectedSpells[i].." - "..normcrit, mychan, nil, mychanID)
	end
	
	CritlineAnnounceFrameTarget:ClearFocus()
end


function CritlineAnnounce_ResetRecords()
	local selectedTree = trees[UIDropDownMenu_GetSelectedValue(CritlineResetFrameTree)]
	
	if CritlineResetFrameAllButton:GetChecked() then
		CL_DATABASE[selectedTree] = {}
		CritlineResetFrameAllButton:SetChecked(false)
	else
		for i = 1, table.maxn(selectedSpells) do
			norm = nil
			crit = nil
			for v in pairs(CL_DATABASE[selectedTree]) do
				if v == selectedSpells[i] then
					CL_DATABASE[selectedTree][selectedSpells[i]] = nil
					do break end
				end
			end
		end
	end
	selectedSpells = {}

	CLASpellScrollBar_Update(CritlineResetFrameSpellListScrollBar)
	Critline_RebuildAllTooltips()
end


function CritlineAnnounce_LoadChannels()
	if IsInGuild() then
		CritlineAnnounce_CreateChannel(11, GUILD)
	end
	if GetNumPartyMembers() > 0 then
		CritlineAnnounce_CreateChannel(12, PARTY)
	end
	if GetNumRaidMembers() > 0 then
		CritlineAnnounce_CreateChannel(13, RAID)
	end
	
	CritlineAnnounce_CreateChannel(14, SAY)
	CritlineAnnounce_CreateChannel(15, WHISPER)

	local id, name
	
	for i = 1, 10 do
		id, name = select((i * 2 - 1), GetChannelList())
		if id then
			CritlineAnnounce_CreateChannel(id, name)
		end
	end
end


function CritlineAnnounce_ChannelInitialize()
	UIDropDownMenu_Initialize(CritlineAnnounceFrameChannel, CritlineAnnounce_LoadChannels)
	UIDropDownMenu_SetWidth(CritlineAnnounceFrameChannel, 120)
end


function CritlineAnnounce_TreeInitialize(self)
	local parent = self:GetParent()
	local scrollBar = _G[parent:GetName().."SpellListScrollBar"]
	UIDropDownMenu_Initialize(self, function(self)
		local tex
		tex = {
			text = DAMAGE,
			value = 1,
			func = function()
				UIDropDownMenu_SetSelectedValue(self, 1)
				selectedSpells = {}
				FauxScrollFrame_SetOffset(scrollBar, 0)
				CLASpellScrollBar_Update(scrollBar)
			end
		}
		UIDropDownMenu_AddButton(tex)
		
		tex = {
			text = HEALS,
			value = 2,
			func = function()
				UIDropDownMenu_SetSelectedValue(self, 2)
				selectedSpells = {}
				FauxScrollFrame_SetOffset(scrollBar, 0)
				CLASpellScrollBar_Update(scrollBar)
			end
		}
		UIDropDownMenu_AddButton(tex)
		
		tex = {
			text = PET,
			value = 3,
			func = function()
				UIDropDownMenu_SetSelectedValue(self, 3)
				selectedSpells = {}
				FauxScrollFrame_SetOffset(scrollBar, 0)
				CLASpellScrollBar_Update(scrollBar)
			end
		}
		UIDropDownMenu_AddButton(tex)
	end)
	
	UIDropDownMenu_SetWidth(self, 120)
	UIDropDownMenu_SetSelectedValue(self, 1)
end


function CritlineAnnounceSpellButton_OnClick(self)
	local buttonName = self:GetName()
	if self:GetChecked() then
		PlaySound("igMainMenuOptionCheckBoxOn")
		tinsert(selectedSpells, _G[buttonName.."Text"]:GetText())
	else
		PlaySound("igMainMenuOptionCheckBoxOff")
		for i = 1, #selectedSpells do
			if selectedSpells[i] == _G[buttonName.."Text"]:GetText() then
				tremove(selectedSpells, i)
				return
			end
		end
	end
end


function CLASpellScrollBar_Update(self)
	local buttonName, button
	local frameName = self:GetParent():GetName()
	local selectedTree = trees[UIDropDownMenu_GetSelectedValue(_G[self:GetParent():GetParent():GetName().."Tree"])]
	
	local lineplusoffset -- an index into our data calculated from the scroll offset
	local CLA_SPELLS = {}
	local norm, crit, normcrit, checked

	for k, v in pairs(CL_DATABASE[selectedTree]) do
		tinsert(CLA_SPELLS, k)
	end
	sort(CLA_SPELLS)
	local size = #CLA_SPELLS
	FauxScrollFrame_Update(_G[frameName.."ScrollBar"], size, numSpellButtons, 16)
	for line = 1, numSpellButtons do
		norm = 0
		crit = 0
		buttonName = frameName.."Button"..line
		button = _G[buttonName]
		lineplusoffset = line + FauxScrollFrame_GetOffset(_G[frameName.."ScrollBar"])
		if lineplusoffset <= size then
			_G[buttonName.."Text"]:SetText(CLA_SPELLS[lineplusoffset])
			
			if CL_DATABASE[selectedTree][CLA_SPELLS[lineplusoffset]]["NORM"] then
				norm = CL_DATABASE[selectedTree][CLA_SPELLS[lineplusoffset]]["NORM"]["Amount"]
			end
			if CL_DATABASE[selectedTree][CLA_SPELLS[lineplusoffset]]["CRIT"] then
				crit = CL_DATABASE[selectedTree][CLA_SPELLS[lineplusoffset]]["CRIT"]["Amount"]
			end
			
			if norm and crit then
				normcrit = HIGHLIGHT_FONT_COLOR_CODE..norm..FONT_COLOR_CODE_CLOSE.."/"..GREEN_FONT_COLOR_CODE..crit..FONT_COLOR_CODE_CLOSE
			elseif norm then
				normcrit = HIGHLIGHT_FONT_COLOR_CODE..norm..FONT_COLOR_CODE_CLOSE
			elseif crit then
				normcrit = GREEN_FONT_COLOR_CODE..crit..FONT_COLOR_CODE_CLOSE
			end
			_G[buttonName.."RecordAmount"]:SetText("["..normcrit.."] ")
			
			checked = false
			for k, v in ipairs(selectedSpells) do
				if v == CLA_SPELLS[lineplusoffset] then
					checked = true
					break
				end
			end
			button:SetChecked(checked)
			
			button:Show()
		else
			button:Hide()
		end
	end
end


-- XML function calls
function CLASpellScrollBar_OnVerticalScroll(self, offset)
	FauxScrollFrame_OnVerticalScroll(self, offset, numSpellButtons, CLASpellScrollBar_Update)
end


function CritlineAnnounceAllButton_OnClick(self)
	if self:GetChecked() then
		PlaySound("igMainMenuOptionCheckBoxOn")
	else
		PlaySound("igMainMenuOptionCheckBoxOff")
	end
end


function CritlineAnnounceButton1_OnClick()
	PlaySound("gsTitleOptionOK")
	if CritlineAnnounceFrame:IsShown() then
		CritlineAnnounce_SendAnnounce()
	elseif CritlineResetFrame:IsShown() then
		CritlineAnnounce_ResetRecords()
	end
end


function CritlineAnnounce_OnShow(scrollBar)
	selectedSpells = {}
	FauxScrollFrame_SetOffset(scrollBar, 0)
	CLASpellScrollBar_Update(scrollBar)
	CritlineAnnounceFrameTarget:SetAutoFocus(false)
	CritlineAnnounceFrameTarget:Hide()
	CritlineAnnounce_ChannelInitialize()
	UIDropDownMenu_SetSelectedValue(CritlineAnnounceFrameChannel, 14)
end