local ldb = LibStub:GetLibrary("LibDataBroker-1.1")


local dmg = ldb:NewDataObject("Critline damage", {
	type = "data source",
	icon = CRITLINE_DMG_ICON,
	OnClick = function(_, msg)
		-- if msg == "LeftButton" then
			InterfaceOptionsFrame_OpenToCategory(CritlineSettingsBasic)
		-- end
	end,
	OnTooltipShow = function(self)
		self:AddLine("|cffffffffCritline damage|r")
		Critline_AddTooltipText(Critline_GetSummaryRichText("DMG"))
	end
})

Critline_OnUpdateRegister(function() dmg.text = Critline_GetHighest("DMG", "NORM").."/"..Critline_GetHighest("DMG", "CRIT") end)


local heal = ldb:NewDataObject("Critline healing", {
	type = "data source",
	icon = CRITLINE_HEAL_ICON,
	OnClick = function(_, msg)
		-- if msg == "LeftButton" then
			InterfaceOptionsFrame_OpenToCategory(CritlineSettingsBasic)
		-- end
	end,
	OnTooltipShow = function(self)
		self:AddLine("|cffffffffCritline healing|r")
		Critline_AddTooltipText(Critline_GetSummaryRichText("HEAL"))
	end
})

Critline_OnUpdateRegister(function() heal.text = Critline_GetHighest("HEAL", "NORM").."/"..Critline_GetHighest("HEAL", "CRIT") end)


local pet = ldb:NewDataObject("Critline pet", {
	type = "data source",
	icon = CRITLINE_PET_ICON,
	OnClick = function(_, msg)
		-- if msg == "LeftButton" then
			InterfaceOptionsFrame_OpenToCategory(CritlineSettingsBasic)
		-- end
	end,
	OnTooltipShow = function(self)
		self:AddLine("|cffffffffCritline pet|r")
		Critline_AddTooltipText(Critline_GetSummaryRichText("PET"))
	end
})

Critline_OnUpdateRegister(function() pet.text = Critline_GetHighest("PET", "NORM").."/"..Critline_GetHighest("PET", "CRIT") end)