local filterTree = "DMG"

local numSpellFilterButtons = 15
local numMobFilterButtons = 15

local UnitBuff = UnitBuff
local UnitDebuff = UnitDebuff

Critline_SpecialAuras = {
	18173,	-- Burning Adrenaline (Vaelastrasz the Corrupt)
	44406,	-- Energy Infusion (Vexallus)
	44335,	-- Energy Feedback (Vexallus)
	41337,	-- Aura of Anger (Reliquary of Souls)
	41350,	-- Aura of Desire (Reliquary of Souls)
	58549,	-- Tenacity (Lake Wintergrasp)
	60964,	-- Strength of Wrynn (The Battle For The Undercity)
	59641,	-- Warchief's Blessing (The Battle For The Undercity)
	55849,	-- Power Spark (Malygos)
	56648,	-- Potent Fungus (Amanitar)
}


local specialMobs = {
	12460,	-- Death Talon Wyrmguard
	12461,	-- Death Talon Overseer
	14020,	-- Chromaggus
	15339,	-- Ossirian the Unscarred
	22841,	-- Shade of Akama
	15928,	-- Thaddius
}


function CritlineFilters_OnLoad(self)
	self.name = "Filters"
	self.parent = "Critline"
	InterfaceOptions_AddCategory(self)

	self:RegisterEvent("ADDON_LOADED")

	CLF_Pre_SpellButton_OnModifiedClick = SpellButton_OnModifiedClick
	SpellButton_OnModifiedClick = CLF_SpellButton_OnModifiedClick
end


function CritlineFilters_CreateSpellButtons(self)
	local button, name
	name = self:GetName().."Button"
	for i = 1, numSpellFilterButtons do
		button = CreateFrame("CheckButton", name..i, self, "CritlineSpellFilterButtonTemplate")
		if i == 1 then
			button:SetPoint("TOPLEFT", 0, -8)
		else
			button:SetPoint("TOP", name..(i - 1), "BOTTOM", 0, 4)
		end
	end
	
	self:SetWidth(300)
	self:SetHeight(numSpellFilterButtons * 22 + 16)
end


function CritlineFiltersFilterType_OnLoad(self)
	UIDropDownMenu_Initialize(self, function(self)
		local tex
		tex = {
			text = "Spell filter",
			value = 1,
			func = function()
				UIDropDownMenu_SetSelectedValue(self, 1)
				CritlineFiltersMobFilterFrame:Hide()
				CritlineFiltersSpellFilterFrame:Show()
			end
		}
		UIDropDownMenu_AddButton(tex)
		
		tex = {
			text = "Mob filter",
			value = 2,
			func = function()
				UIDropDownMenu_SetSelectedValue(self, 2)
				CritlineFiltersSpellFilterFrame:Hide()
				CritlineFiltersMobFilterFrame:Show()
			end
		}
		UIDropDownMenu_AddButton(tex)
	end)
	
	UIDropDownMenu_SetWidth(self, 120)
	UIDropDownMenu_SetSelectedValue(self, 1)
end


function CritlineFilter_CreateMobButtons(self)
	local button, name
	name = self:GetName().."Button"
	for i = 1, numMobFilterButtons do
		button = CreateFrame("Button", name..i, self, "CritlineMobFilterButtonTemplate")
		if i == 1 then
			button:SetPoint("TOPLEFT", 0, -5)
		else
			button:SetPoint("TOP", name..(i - 1), "BOTTOM")
		end
		button:SetID(i)
	end
	
	self:SetWidth(300)
	self:SetHeight(numMobFilterButtons * 16 + 8)
end


function CLF_SpellButton_OnModifiedClick(self, drag)
	if IsShiftKeyDown() then
		if CritlineFilters:IsVisible() then
			local spellID = SpellBook_GetSpellID(self:GetID())
			if spellID > MAX_SPELLS then
				return
			end
			local spellName, spellRank = GetSpellName(spellID, SpellBookFrame.bookType)
			CritlineFilters_AddSpell(spellName, filterTree)
			return
		end
    end
    CLF_Pre_SpellButton_OnModifiedClick(self, drag)
end


function CLFSpellScrollBar_Update()
	local lineplusoffset -- an index into our data calculated from the scroll offset
	local CL_SPELLS = {}

	if CL_FILTERS[filterTree] then
		for k, v in pairs(CL_FILTERS[filterTree]) do
			tinsert(CL_SPELLS, v)
		end
		for k, v in pairs(CL_DATABASE[filterTree]) do
			if type(k) == "number" then
				CL_DATABASE[filterTree][k] = nil -- need to get rid of old 113 errors...they are stored as numbers and cause errors when compared with string names
			elseif not CritlineFilters_IsSpellInFilter(k, filterTree) then
				tinsert(CL_SPELLS, k)
			end
		end
	end

	sort(CL_SPELLS)
	local size = #CL_SPELLS
	local buttonName, button
	
	FauxScrollFrame_Update(CLFSpellScrollBar, size, numSpellFilterButtons, 16)
	for line = 1, numSpellFilterButtons do
		buttonName = "CritlineFiltersSpellFilterFrameButton"..line
		button = _G[buttonName]
		lineplusoffset = line + FauxScrollFrame_GetOffset(CLFSpellScrollBar)
		if lineplusoffset <= size then
			_G[buttonName.."Text"]:SetText(CL_SPELLS[lineplusoffset])
			if CritlineFilters_IsSpellInFilter(CL_SPELLS[lineplusoffset], filterTree) then
				button:SetChecked(true)
			else
				button:SetChecked(false)
			end
			button:Show()
		else
			button:Hide()
		end
	end
end


function CLFMobScrollBar_Update()
	local lineplusoffset -- an index into our data calculated from the scroll offset
	local size
	
	if CritlineMobFilter then
		size = #CritlineMobFilter
	else
		size = 0
	end
	
	local button
	
	FauxScrollFrame_Update(CLFMobScrollBar, size, numMobFilterButtons, 16)
	for line = 1, numMobFilterButtons do
		button = _G["CritlineFiltersMobFilterFrameButton"..line]
		lineplusoffset = line + FauxScrollFrame_GetOffset(CLFMobScrollBar)
		if lineplusoffset <= size then
			button:SetText(CritlineMobFilter[lineplusoffset])
			button:Show()
		else
			button:Hide()
		end
		if CLFMobScrollBar.selected then
			if (CLFMobScrollBar.selected - FauxScrollFrame_GetOffset(CLFMobScrollBar)) == button:GetID() then
				button:LockHighlight()
			else
				button:UnlockHighlight()
			end
		end
	end
end

 
function CritlineFiltersSpellFilterTree_OnLoad(self)
	UIDropDownMenu_Initialize(self, function(self)
		local tex
		tex = {
			text = DAMAGE,
			value = 1,
			func = function()
				UIDropDownMenu_SetSelectedValue(self, 1)
				FauxScrollFrame_SetOffset(CLFSpellScrollBar, 0)
				filterTree = "DMG"
				CLFSpellScrollBar_Update()
			end
		}
		UIDropDownMenu_AddButton(tex)
		
		tex = {
			text = HEALS,
			value = 2,
			func = function()
				UIDropDownMenu_SetSelectedValue(self, 2)
				FauxScrollFrame_SetOffset(CLFSpellScrollBar, 0)
				filterTree = "HEAL"
				CLFSpellScrollBar_Update()
			end
		}
		UIDropDownMenu_AddButton(tex)
		
		tex = {
			text = PET,
			value = 3,
			func = function()
				UIDropDownMenu_SetSelectedValue(self, 3)
				FauxScrollFrame_SetOffset(CLFSpellScrollBar, 0)
				filterTree = "PET"
				CLFSpellScrollBar_Update()
			end
		}
		UIDropDownMenu_AddButton(tex)
	end)
	
	UIDropDownMenu_SetWidth(self, 120)
	UIDropDownMenu_SetSelectedValue(self, 1)
end


function CritlineFilters_AddTarget()
	local targetName = UnitName("target")
	if targetName then
		if CritlineFilters_IsMobInFilter(targetName) then
			Critline_Message(targetName.." is already in mob filter.")
		elseif UnitIsPlayer("target") then
			Critline_Message("Target is a player.")
		else
			tinsert(CritlineMobFilter, targetName)
			CLFMobScrollBar_Update()
			Critline_Message(targetName.." added to mob filter.")
		end
	else
		Critline_Message("No target selected.")
	end
end


function CritlineFilters_DeleteTarget()
	if CLFMobScrollBar.selected then
		Critline_Message(CritlineMobFilter[CLFMobScrollBar.selected].." removed from mob filter.")
		tremove(CritlineMobFilter, CLFMobScrollBar.selected)
		_G["CritlineFiltersMobFilterFrameButton"..(CLFMobScrollBar.selected - FauxScrollFrame_GetOffset(CLFMobScrollBar))]:UnlockHighlight()
		CLFMobScrollBar.selected = nil
		CritlineFiltersMobFilterFrameDelete:Disable()
		CLFMobScrollBar_Update()
	end
end


function CritlineFilters_AddSpell(spellname, tree)
	if spellname then
		if not CritlineFilters_IsSpellInFilter(spellname,tree) then
			tinsert(CL_FILTERS[tree], spellname)
			CLFSpellScrollBar_Update()
			Critline_RebuildAllTooltips()
		end
	end
end


function CritlineFilters_DeleteSpell(spellname, tree)
	for k, v in pairs(CL_FILTERS[tree]) do
		if v == spellname then
			tremove(CL_FILTERS[tree], k)
			do break end
		end
	end
	CLFSpellScrollBar_Update()
	Critline_RebuildAllTooltips()
end


function CritlineFilters_IsMobInFilter(mobName, GUID)
	if GUID then
		local id = tonumber(strsub(GUID, 6, 12), 16)
		for i, v in ipairs(specialMobs) do
			if v == id then
				Critline_Debug("Name of Mob ("..mobName..") is in Filter ...")
				return true
			end
		end
	end
	for i, v in ipairs(CritlineMobFilter) do
		if v == mobName then
			Critline_Debug("Name of Mob ("..mobName..") is in Filter ...")
			return true
		end
	end
	Critline_Debug("Name of Mob ("..mobName..") is NOT in Filter ...")
	return false
end


function CritlineFilters_HasSpecialAura()
	for j = 1, 40 do
		local buffName, _, buffIcon = UnitBuff("player", j)
		local debuffName, _, debuffIcon = UnitDebuff("player", j)
		for i, v in ipairs(Critline_SpecialAuras) do
			local name, _, icon = GetSpellInfo(v)
			if (buffName == name and buffIcon == icon) or (debuffName == name and debuffIcon == icon) then
				return true
			end
		end
	end
	return false
end


function CritlineFilters_IsSpellInFilter(spellName, tree)
	for k, v in pairs(CL_FILTERS[tree]) do
		if v == spellName then
			Critline_Debug("Name of Spell ("..spellName..") is in Filter ...")
			return true
		end
	end
	Critline_Debug("Name of Spell ("..spellName..") is NOT in Filter ...")
	return false
end


function CritlineFilters_IsSpellInSpellbook(spellname)
	local numspells = 1
	while GetSpellName(numspells, BOOKTYPE_SPELL) do --find the top rank of every spell
		local name = GetSpellName(numspells, BOOKTYPE_SPELL)
		if name == spellname then
			return true
		end
		numspells = numspells + 1
	end
	return false
end


function CritlineFiltersButton_OnClick(self)
	local scrollBar = CLFMobScrollBar
	
	if scrollBar.selected then
		if (scrollBar.selected - FauxScrollFrame_GetOffset(scrollBar)) == self:GetID() then
			-- clicking the selected button, clear selection
			self:UnlockHighlight()
			scrollBar.selected = nil
		else
			-- clear selection if visible, and set new selection
			local prevHighlight = _G["CritlineFiltersMobFilterFrameButton"..(scrollBar.selected - FauxScrollFrame_GetOffset(scrollBar))]
			if prevHighlight then
				prevHighlight:UnlockHighlight()
			end
			self:LockHighlight()
			scrollBar.selected = self:GetID() + FauxScrollFrame_GetOffset(scrollBar)
		end
	else
		-- no previous selection, just set new and lock highlight
		self:LockHighlight()
		scrollBar.selected = self:GetID() + FauxScrollFrame_GetOffset(scrollBar)
	end
	
	-- enable/disable "Delete" button depending on if selection exists
	if scrollBar.selected then
		CritlineFiltersMobFilterFrameDelete:Enable()
	else
		CritlineFiltersMobFilterFrameDelete:Disable()
	end
end


function CritlineSettings_SpellButton_OnClick(self)
	local buttonText = _G[self:GetName().."Text"]
	if self:GetChecked() then
		CritlineFilters_AddSpell(buttonText:GetText(), filterTree)
	else
		CritlineFilters_DeleteSpell(buttonText:GetText(), filterTree)
	end
end