﻿function CL_ToggleMod()
	if (CL_SETTINGS["ON"] == 1) then
		CritlineDisplay_UpdateTree("DMG", false)
		CritlineDisplay_UpdateTree("HEAL", false)
		CritlineDisplay_UpdateTree("PET", false)
	else
		CritlineDisplay_UpdateTree("DMG", true)
		CritlineDisplay_UpdateTree("HEAL", true)
		CritlineDisplay_UpdateTree("PET", true)
	end
end

function CritlineDisplay_UpdateTree(tree, enabled)
	local mytree = _G["CritlineDisplay"..tree]
	local mybutton = _G["CritlineDisplay"..tree.."Button"]
	Critline_Debug("CritlineDisplay"..tree.."Button")
	local visiblebuttoncount = 0
	
	local trees = {
		DMG = 8,
		HEAL = 9,
		PET = 10,
	}
	
	if (enabled) then
		CL_SETTINGS["SHOW"..tree] = 1
		CritlineDisplay:Show()
		Critline_Debug("Show:"..tree)
		mybutton:Show()
		mytree:Show()
	else
		CL_SETTINGS["SHOW"..tree] = 0
		Critline_Debug("Hide:"..tree)
		mybutton:Hide()
		mytree:Hide()
	end
	_G["CritlineSettingsBasicOption"..trees[tree]]:SetChecked(enabled)
	
	-- check for anchors
	local myDMGButton = CritlineDisplayDMGButton
	local myHEALButton = CritlineDisplayHEALButton
	local myPETButton = CritlineDisplayPETButton
	if myHEALButton:IsVisible() then
		myHEALButton:ClearAllPoints()
		if myDMGButton:IsVisible() then
			myHEALButton:SetPoint("TOP", "CritlineDisplayDMGButton", "BOTTOM", 0, -2)
			Critline_Debug("Anchor HEAL to DMG")
		else
			myHEALButton:SetPoint("TOPLEFT", 5, -5)
			Critline_Debug("Anchor HEAL to Parent")
		end
	end
	if myPETButton:IsVisible() then
		myPETButton:ClearAllPoints()
		if myHEALButton:IsVisible() then
			myPETButton:SetPoint("TOP", "CritlineDisplayHEALButton", "BOTTOM", 0, -2)
			Critline_Debug("Anchor PET to HEAL")
		elseif myDMGButton:IsVisible() then
			myPETButton:SetPoint("TOP", "CritlineDisplayDMGButton", "BOTTOM", 0, -2)
			Critline_Debug("Anchor PET to DMG")
		else
			myPETButton:SetPoint("TOPLEFT", 5, -5)
			Critline_Debug("Anchor PET to Parent")
		end
	end
	
	if myDMGButton:IsVisible() then
		visiblebuttoncount = visiblebuttoncount + 1
	end
	if myHEALButton:IsVisible() then
		visiblebuttoncount = visiblebuttoncount + 1
	end
	if myPETButton:IsVisible() then
		visiblebuttoncount = visiblebuttoncount + 1
	end
	
	CritlineDisplay:SetHeight(visiblebuttoncount * 22 + 8)
	
	
	if not (CL_SETTINGS["SHOWDMG"] == 1 or CL_SETTINGS["SHOWHEAL"] == 1 or CL_SETTINGS["SHOWPET"] == 1) then
		CritlineDisplay:Hide()
	end
end

function CritlineDisplay_OnLoad(self)
	Critline_OnUpdateRegister(CritlineDisplay_OnUpdate)
	self:RegisterEvent("ADDON_LOADED")
end

function CritlineDisplay_OnEvent(self, event, ...)
	if (event == "ADDON_LOADED" and (...) == "Critline") then
		CritlineDisplay_OnUpdate()
		CritlineDisplay:SetScale(CL_SETTINGS["SCALE"])

		local _, myClass = UnitClass("player")
		if (CL_SETTINGS["FIRSTLOAD"] == 1 or CL_SETTINGS["FIRSTLOAD"] == nil) then -- by default on first time load, all trees are on
			Critline_Debug("FIRSTLOAD == 1")
			Critline_Debug("."..myClass..".")
			local shownTrees = {
				-- CLASS = {dmg, heal, pet}
				DEATHKNIGHT = {true, false, false},
				DRUID = {true, true, false},
				HUNTER = {true, false, true},
				MAGE = {true, false, false},
				PALADIN = {true, true, false},
				PRIEST = {true, true, false},
				ROGUE = {true, false, false},
				SHAMAN = {true, true, false},
				WARLOCK = {true, false, true},
				WARRIOR = {true, false, false},
			}
			for i, tree in ipairs({"DMG", "HEAL", "PET"}) do
				if shownTrees[myClass] then
					CritlineDisplay_UpdateTree(tree, shownTrees[myClass][i])
				end
			end
			CL_SETTINGS["FIRSTLOAD"] = 0
		else -- not a first time load, so use user settings to update trees which are still defaulted to on in the CritlineDisplay.xml
			Critline_Debug("FIRSTLOAD == false")
			for i, tree in ipairs({"DMG", "HEAL", "PET"}) do
				CritlineDisplay_UpdateTree(tree, (CL_SETTINGS["SHOW"..tree] == 1 and true or false))
			end
		end
	end 
end

function CritlineDisplay_OnUpdate()
	local rtfText
	for i, tree in ipairs({"DMG", "HEAL", "PET"}) do
		rtfText = strsub("      "..Critline_GetHighest(tree, "NORM"), -6).."/"..strsub(Critline_GetHighest(tree, "CRIT").."      ", 1, 6)	--rtfText will always be 13 chars long with / in the middle..this keeps all numbers aligned
		_G["CritlineDisplay"..tree]:SetText(rtfText)
		Critline_Debug(rtfText)
	end
end

function Critline_AddTooltipText(text)
	if text then
		-- Append a "\n" to the end 
		if (strsub(text, -1, -1) ~= "\n") then
			text = text.."\n"
		end
		
		for text1, text2 in gmatch(text, "([^\t\n]*)\t?([^\t\n]*)\n") do
			if (text2 ~= "") then
				GameTooltip:AddDoubleLine(text1, text2)
			elseif (text1 ~= "") then
				GameTooltip:AddLine(text1)
			else
				GameTooltip:AddLine("\n")
			end
		end
		GameTooltip:Show()
	end
end