function CritlineMinimap_OnTooltip(self, v1, v2)
	GameTooltip:SetOwner(self, "ANCHOR_LEFT")
	GameTooltip:AddLine(v1)
	GameTooltip:AddLine(v2, 0.8, 0.8, 0.8, 1)
	GameTooltip:Show()
end


function CritlineMinimap_OnEvent(self, event, ...)
	if event == "ADDON_LOADED" and (...) == "Critline" then
		if CL_SETTINGS["SHOWMINIMAP"] == 1 then
			CritlineMinimapFrame:Show()
		else
			CritlineMinimapFrame:Hide()
		end 
		CritlineMinimap_MoveMinimap()
	end
end


function CritlineMinimap_OnUpdate(self)
	if self.isDragging then
		local xpos, ypos = GetCursorPosition()
		local xmin, ymin = Minimap:GetLeft(), Minimap:GetBottom()

		xpos = xmin - xpos / Minimap:GetEffectiveScale() + 70
		ypos = ypos / Minimap:GetEffectiveScale() - ymin - 70

		CL_SETTINGS["MINIMAPPOS"] = deg(atan2(ypos, xpos))
		CritlineMinimap_MoveMinimap()
	end
end


function CritlineMinimap_MoveMinimap()
	local xpos, ypos
	local angle = CL_SETTINGS["MINIMAPPOS"]

	xpos = 80 * cos(angle)
	ypos = 80 * sin(angle)

	CritlineMinimapFrame:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - xpos, ypos - 52)
end


function CritlineMinimap_OnClick(self, button)
	if (button == "LeftButton") then
		if CritlineDisplay:IsVisible() then
			CritlineDisplay:Hide()
		else
			if (CL_SETTINGS["SHOWDMG"] == 1 or CL_SETTINGS["SHOWHEAL"] == 1 or CL_SETTINGS["SHOWPET"] == 1) then
				CritlineDisplay:Show()
			else
				CL_SETTINGS["FIRSTLOAD"] = 1
				CritlineDisplay_OnEvent(CritlineDisplay, "ADDON_LOADED", "Critline") -- if all tree are hidden when minimap is called to show, reload by class
			end
		end
	elseif (button == "RightButton") then
		InterfaceOptionsFrame_OpenToCategory(CritlineSettingsBasic)
	end
end