--[[ addon functions ]]

function CritlineSettings_OnLoad(self)
	self.name = "Critline"
	InterfaceOptions_AddCategory(self)
	InterfaceOptions_AddCategory(_G[self:GetName().."Basic"])
	InterfaceOptions_AddCategory(_G[self:GetName().."Advanced"])
	

	self:RegisterEvent("ADDON_LOADED")

	SlashCmdList["CRITLINESETTINGS"] = function(msg)
		InterfaceOptionsFrame_OpenToCategory(CritlineSettingsBasic)
	end
	
	SLASH_CRITLINESETTINGS1 = "/critline"
end


function CritlineSettings_OnEvent(self, event, ...)
	if (event == "ADDON_LOADED" and (...) == "Critline") then
		CritlineSettings_LoadSettings()
	end
end


function CritlineSettings_CreateBasicOptions(self)
	local option, name, sliderName
	name = self:GetName().."Option"
	for i = 1, 12 do
		option = CreateFrame("CheckButton", name..i, self, "CritlineSettingsCheckButtonTemplate")
		if i == 1 then
			option:SetPoint("TOPLEFT", CritlineSettingsBasicSubText, "BOTTOMLEFT", -2, -8)
		elseif i == 8 then
			option:SetPoint("TOPLEFT", CritlineSettingsBasicSubText, "BOTTOM", 0, -8)
		else
			option:SetPoint("TOP", name..(i - 1), "BOTTOM", 0, -8)
		end
	end
	
	sliderName = self:GetName().."Slider1"
	option = CreateFrame("Slider", sliderName, self, "CritlineSettingsSliderTemplate")
	option:SetMinMaxValues(-1, 10)
	option:SetValueStep(1)
	option:SetPoint("TOPLEFT", name.."7", "BOTTOMLEFT", 10, -20)
	option:SetScript("OnValueChanged", function(self)
		local lvAdj = self:GetValue()
		if lvAdj == -1 then
			CritlineSettingsBasicSlider1Text2:SetText(OFF)
		else
			CritlineSettingsBasicSlider1Text2:SetText(tostring(lvAdj))
		end
		if CL_SETTINGS then
			CL_SETTINGS["LVLADJ"] = lvAdj
		end
	end)
	_G[sliderName.."Low"]:SetText(OFF)
	_G[sliderName.."High"]:SetText("10")
	_G[sliderName.."Text"]:SetText(CL_OPTION_LVLADJ_TEXT)
	option.tooltipText = CL_OPTION_LVLADJ_TOOLTIPTEXT
end


function CritlineSettings_CreateAdvancedOptions(self)
	local option, buttonName, colorName, sliderName, sliderData
	buttonName = self:GetName().."Option"
	for i = 1, 7 do
		option = CreateFrame("CheckButton", buttonName..i, self, "CritlineSettingsCheckButtonTemplate")
		if i == 1 then
			option:SetPoint("TOPLEFT", CritlineSettingsAdvancedSubText, "BOTTOMLEFT", -2, -8)
		elseif i == 4 then
			option:SetPoint("TOPLEFT", CritlineSettingsAdvancedSubText, "BOTTOM", 0, -8)
		else
			option:SetPoint("TOP", buttonName..(i - 1), "BOTTOM", 0, -8)
		end
	end
	
	colorName = self:GetName().."Color"
	
	option = CreateFrame("Button", colorName.."1", self, "CritlineSettingsColorTemplate")
	option:SetID(1)
	option:SetPoint("TOPLEFT", buttonName.."3", "BOTTOMLEFT", 0, -8)
	
	option = CreateFrame("Button", colorName.."2", self, "CritlineSettingsColorTemplate")
	option:SetID(2)
	option:SetPoint("TOPLEFT", colorName.."1", "BOTTOMLEFT", 0, -8)

	sliderName = self:GetName().."Slider"
	
	sliderData = {
		{
			relativeTo = colorName.."2",
			text = CL_UISCALESLIDER_TEXT,
			tooltipText = CL_UISCALESLIDER_TOOLTIPTEXT,
			onValueChanged = function(self)
				local value = self:GetValue()
				CritlineDisplay:SetScale(value)
				_G[self:GetName().."Text2"]:SetText(format("%.0f", value * 100).."%")
				if CL_SETTINGS then
					CL_SETTINGS["SCALE"] = value
				end
			end,
		},
		{
			relativeTo = sliderName.."1",
			text = CL_SPLASHSCALESLIDER_TEXT,
			tooltipText = CL_SPLASHSCALESLIDER_TOOLTIPTEXT,
			onValueChanged = function(self)
				local value = self:GetValue()
				CritlineSplashFrame:SetScale(value)
				_G[self:GetName().."Text2"]:SetText(format("%.0f", value * 100).."%")
				if CL_SETTINGS then
					CL_SETTINGS["SPLASHSCALE"] = value
				end
			end,
		},
		{
			relativeTo = sliderName.."2",
			text = CL_SPLASHTIMERSLIDER_TEXT,
			tooltipText = CL_SPLASHTIMERSLIDER_TOOLTIPTEXT,
			onValueChanged = function(self)
				local value = self:GetValue()
				_G[self:GetName().."Text2"]:SetText(tostring(value))
				if CL_SETTINGS then
					CL_SETTINGS["SPLASHTIMER"] = value
					CritlineSplashFrame:SetTimeVisible(value)
				end
			end,
		},
	}
	
	local minValue, maxValue, defaultValue, valueStep = 0.5, 1.5, 1, 0.01
	local x, y, anchor, relativePoint = 0, -40, "TOPLEFT", "BOTTOMLEFT"
	local lowText, highText = CL_MIN_TEXT, CL_MAX_TEXT
	
	for i, v in ipairs(sliderData) do
		option = CreateFrame("Slider", sliderName..i, self, "CritlineSettingsSliderTemplate")
		if i == 3 then
			minValue, maxValue, defaultValue, valueStep = 0.5, 3, 2, 0.5
			x, y, anchor, relativePoint = 40, 0, "LEFT", "RIGHT"
			lowText, highText = "0.5", "3"
		end
		option:SetMinMaxValues(minValue, maxValue)
		option:SetValueStep(valueStep)
		option:SetPoint(anchor, v.relativeTo, relativePoint, x, y)
		option:SetScript("OnValueChanged", v.onValueChanged)
		_G[sliderName..i.."Low"]:SetText(lowText)
		_G[sliderName..i.."High"]:SetText(highText)
		_G[sliderName..i.."Text"]:SetText(v.text)
		option.tooltipText = v.tooltipText
	end
end


function CritlineSettings_LoadSettings()
	local basicOptions = {
		{
			text = CL_OPTION_RECORD_DMG_TEXT,
			tooltipText = CL_OPTION_RECORD_DMG_TOOLTIPTEXT,
			setting = "DMG",
		},
		{
			text = CL_OPTION_RECORD_HEAL_TEXT,
			tooltipText = CL_OPTION_RECORD_HEAL_TOOLTIPTEXT,
			setting = "HEAL",
		},
		{
			text = CL_OPTION_RECORD_PET_TEXT,
			tooltipText = CL_OPTION_RECORD_PET_TOOLTIPTEXT,
			setting = "PET",
		},
		{
			text = CL_OPTION_RECORDPVE_TEXT,
			tooltipText = CL_OPTION_RECORDPVE_TOOLTIPTEXT,
			setting = "RECORDPVE",
		},
		{
			text = CL_OPTION_RECORDPVP_TEXT,
			tooltipText = CL_OPTION_RECORDPVP_TOOLTIPTEXT,
			setting = "RECORDPVP",
		},
		{
			text = CL_OPTION_PLAYSOUND_TEXT,
			tooltipText = CL_OPTION_PLAYSOUND_TOOLTIPTEXT,
			setting = "PLAYSOUND",
		},
		{
			text = CL_OPTION_SCREENCAP_TEXT,
			tooltipText = CL_OPTION_SCREENCAP_TOOLTIPTEXT,
			setting = "SNAPSHOT",
		},
		{
			text = CL_OPTION_SHOWDMG_TEXT,
			tooltipText = CL_OPTION_SHOWDMG_TOOLTIPTEXT,
			setting = "SHOWDMG",
		},
		{
			text = CL_OPTION_SHOWHEAL_TEXT,
			tooltipText = CL_OPTION_SHOWHEAL_TOOLTIPTEXT,
			setting = "SHOWHEAL",
		},
		{
			text = CL_OPTION_SHOWPET_TEXT,
			tooltipText = CL_OPTION_SHOWPET_TOOLTIPTEXT,
			setting = "SHOWPET",
		},
		{
			text = CL_OPTION_SUPPRESSMC_TEXT,
			tooltipText = CL_OPTION_SUPPRESSMC_TOOLTIPTEXT,
			setting = "SUPPRESSMC",
		},
		{
			text = CL_OPTION_DETAILED_TEXT,
			tooltipText = CL_OPTION_DETAILED_TOOLTIPTEXT,
			setting = "DETAILED",
		},
	}
	
	local name, option
	
	for i, v in ipairs(basicOptions) do
		name = "CritlineSettingsBasicOption"..i
		option = _G[name]
		_G[name.."Text"]:SetText(v.text)
		option.tooltipText = v.tooltipText
		option.setting = v.setting
		option:SetChecked(CL_SETTINGS[v.setting])
	end
	
	CritlineSettingsBasicSlider1:SetValue(CL_SETTINGS["LVLADJ"])
	
	local advancedOptions = {
		{
			text = CL_OPTION_SHOWMINIMAP_TEXT,
			tooltipText = CL_OPTION_SHOWMINIMAP_TOOLTIPTEXT,
			setting = "SHOWMINIMAP",
		},
		{
			text = CL_OPTION_SPLASH_TEXT,
			tooltipText = CL_OPTION_SPLASH_TOOLTIPTEXT,
			setting = "SPLASH",
		},
		{
			text = CL_OPTION_MOVESPLASH_TEXT,
			tooltipText = CL_OPTION_MOVESPLASH_TOOLTIPTEXT,
			setting = "MOVESPLASH",
		},
		{
			text = CL_OPTION_INVERTDMG_TEXT,
			tooltipText = CL_OPTION_INVERTDMG_TOOLTIPTEXT,
			setting = "INVERTDMG",
		},
		{
			text = CL_OPTION_INVERTHEAL_TEXT,
			tooltipText = CL_OPTION_INVERTHEAL_TOOLTIPTEXT,
			setting = "INVERTHEAL",
		},
		{
			text = CL_OPTION_INVERTPET_TEXT,
			tooltipText = CL_OPTION_INVERTPET_TOOLTIPTEXT,
			setting = "INVERTPET",
		},
		{
			text = CL_OPTION_DONTFILTERMAGIC_TEXT,
			tooltipText = CL_OPTION_DONTFILTERMAGIC_TOOLTIPTEXT,
			setting = "DONTFILTERMAGIC",
		},
	}
	
	for i, v in ipairs(advancedOptions) do
		name = "CritlineSettingsAdvancedOption"..i
		option = _G[name]
		_G[name.."Text"]:SetText(v.text)
		option.tooltipText = v.tooltipText
		option.setting = v.setting
		option:SetChecked((i == 3) and false or CL_SETTINGS[v.setting])
	end
	
	CritlineSettingsAdvancedSlider1:SetValue(CL_SETTINGS["SCALE"])
	CritlineSettingsAdvancedSlider2:SetValue(CL_SETTINGS["SPLASHSCALE"])
	CritlineSettingsAdvancedSlider3:SetValue(CL_SETTINGS["SPLASHTIMER"])

	local swatch = CritlineSettingsAdvancedColor1Swatch
	swatch.r = CL_SETTINGS["SPELLCOLOR"]["r"]
	swatch.g = CL_SETTINGS["SPELLCOLOR"]["g"]
	swatch.b = CL_SETTINGS["SPELLCOLOR"]["b"]
	swatch:SetVertexColor(swatch.r, swatch.g, swatch.b)
	CritlineSettingsAdvancedColor1.tooltipText = CL_OPTION_SPLASHSPELLCOLOR_TOOLTIPTEXT

	CritlineSettingsAdvancedColor1Text:SetText("Spell Color")
	
	swatch = CritlineSettingsAdvancedColor2Swatch
	swatch.r = CL_SETTINGS["AMOUNTCOLOR"]["r"]
	swatch.g = CL_SETTINGS["AMOUNTCOLOR"]["g"]
	swatch.b = CL_SETTINGS["AMOUNTCOLOR"]["b"]
	swatch:SetVertexColor(swatch.r, swatch.g, swatch.b)
	CritlineSettingsAdvancedColor2.tooltipText = CL_OPTION_SPLASHAMOUNTCOLOR_TOOLTIPTEXT
	
	CritlineSettingsAdvancedColor2Text:SetText("Amount Color")
end


function CritlineSettings_ResetRecords()
	Critline_DataReset()
end


function CritlineSettings_Button_OnClick(self)
	Critline_Debug(self.setting.." toggled.")
	if self.Setting == "MOVESPLASH" then -- temporary setting....not to be saved
		if self:GetChecked() then
			CritlineSplashFrame.locked = false
			CritlineSplashFrame:EnableMouse(1)
		else
			CritlineSplashFrame.locked = true
			CritlineSplashFrame:EnableMouse(0)
			CritlineSplashFrame:Clear()
		end
	else
		if self:GetChecked() then
			CL_SETTINGS[self.setting] = 1
		else
			CL_SETTINGS[self.setting] = 0
		end
		if (self.setting == "SHOWDMG" or self.setting == "SHOWHEAL" or self.setting == "SHOWPET") then
			CritlineDisplay_UpdateTree(strsub(self.setting, 5), self:GetChecked())
		end
		if (self.setting == "DETAILED") or (self.setting == "INVERTDMG") or (self.setting == "INVERTHEAL") or (self.setting == "INVERTPET") then
			Critline_RebuildAllTooltips()
		end
		if (self.setting == "SHOWMINIMAP") then
			if (self:GetChecked()) then
				CritlineMinimapFrame:Show()
			else
				CritlineMinimapFrame:Hide()
			end
		end
	end
end


local CritlineSettings_CancelFunc = {
	[1] = function(x) CritlineSettings_CancelColor(1, x) end,
	[2] = function(x) CritlineSettings_CancelColor(2, x) end,
	[3] = function(x) CritlineSettings_CancelColor(3, x) end,
	[4] = function(x) CritlineSettings_CancelColor(4, x) end,
	[5] = function(x) CritlineSettings_CancelColor(5, x) end,
	[6] = function(x) CritlineSettings_CancelColor(6, x) end
}

local CritlineSettings_SetColorFunc = {
	[1] = function() CritlineSettings_SetColor(1) end,
	[2] = function() CritlineSettings_SetColor(2) end,
	[3] = function() CritlineSettings_SetColor(3) end,
	[4] = function() CritlineSettings_SetColor(4) end,
	[5] = function() CritlineSettings_SetColor(5) end,
	[6] = function() CritlineSettings_SetColor(6) end
}


function CritlineSettings_ColorPicker(id)
	CloseMenus()
	local texture = _G["CritlineSettingsAdvancedColor"..id.."Swatch"]
	if not texture.a then
		texture.a = 1
	end
	ColorPickerFrame.func = CritlineSettings_SetColorFunc[id]
	ColorPickerFrame:SetColorRGB(texture.r, texture.g, texture.b)
	ColorPickerFrame.previousValues = {r = texture.r, g = texture.g, b = texture.b, opacity =texture.a}
	ColorPickerFrame.cancelFunc = CritlineSettings_CancelFunc[id]
	ColorPickerFrame.hasOpacity = false
	
	ColorPickerFrame:Show()
end


function CritlineSettings_SetColor(id)
	local r, g, b = ColorPickerFrame:GetColorRGB()
	local texture = _G["CritlineSettingsAdvancedColor"..id.."Swatch"]
	--SHTSetOpacity(id)
	texture:SetVertexColor(r, g, b)
	texture.r = r
	texture.g = g
	texture.b = b
	if id == 1 then
		CL_SETTINGS["SPELLCOLOR"]["r"] = r
		CL_SETTINGS["SPELLCOLOR"]["g"] = g
		CL_SETTINGS["SPELLCOLOR"]["b"] = b
	elseif id == 2 then
		CL_SETTINGS["AMOUNTCOLOR"]["r"] = r
		CL_SETTINGS["AMOUNTCOLOR"]["g"] = g
		CL_SETTINGS["AMOUNTCOLOR"]["b"] = b
	end
end


function CritlineSettings_CancelColor(id, prev)
	local texture = _G["CritlineSettingsAdvancedColor"..id.."Swatch"]
	local r = prev.r
	local g = prev.g
	local b = prev.b
	local a = prev.opacity
	texture:SetVertexColor(r, g, b)
	texture:SetAlpha( a )
	texture.r = r
	texture.g = g
	texture.b = b
	texture.a = a
end