﻿---------------------------------------------------------------------------------
--
-- Prat - A framework for World of Warcraft chat mods
--
-- Copyright (C) 2006-2007  Prat Development Team
--
-- This program is free software; you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to:
--
-- Free Software Foundation, Inc., 
-- 51 Franklin Street, Fifth Floor, 
-- Boston, MA  02110-1301, USA.
--
--
-------------------------------------------------------------------------------

--[[
Name: PratSounds
Revision: $Revision: 80553 $
Author(s): Sylvanaar - Copy/Pasted from ChatSounds hy TotalPackage
Website: http://www.wowace.com/files/index.php?path=Prat/
Documentation: http://www.wowace.com/wiki/Prat/Integrated_Modules#Filtering
Subversion: http://svn.wowace.com/wowace/trunk/Prat/
Discussions: http://groups.google.com/group/wow-prat
Issues and feature requests: http://code.google.com/p/prat/issues/list
Description: A port of the Chatsounds addon to the Prat framework. (default=off).
Dependencies: Prat
]]

Prat:AddModuleToLoad(function() 

local PRAT_MODULE = Prat:RequestModuleName("Sounds")

if PRAT_MODULE == nil then 
    return 
end

local L = Prat:GetLocalizer({})

--[===[@debug@
L:AddLocale("enUS", {
	["Sounds"] = true,
	["A module to play sounds on certain chat messages."] = true,
	["Add a custom channel"] = true,
	["Play a sound for a certain channel name (can be a substring)"] = true,
	["Remove a custom channel"] = true,
	["Reset settings"] = true,
	["Restore default settings and resets custom channel list"] = true,
	["Incoming Sounds"] = true,
	["Sound selection for incoming chat messages"] = true,
	["party_name"] = "Party",
	["party_desc"] = "Sound for %s party messages",
	["raid_name"] = "Raid",
	["raid_desc"] = "Sound for %s raid or battleground group/leader messages",
	["guild_name"] = "Guild",
	["guild_desc"] = "Sound for %s guild messages",
	["officer_name"] = "Officer",
	["officer_desc"] = "Sound for %s officer or custom channel messages",
	["whisper_name"] = "Whisper",
	["whisper_desc"] = "Sound for %s whisper messages",
	["incoming"] = true,
	["outgoing"] = true,
	["Outgoing Sounds"] = true,
	["Sound selection for outgoing (from you) chat messages"] = true,
	["Custom Channels"] = true,
})
--@end-debug@]===]

-- These Localizations are auto-generated. To help with localization
-- please go to http://www.wowace.com/projects/prat-3-0/localization/


--@non-debug@
L:AddLocale("enUS", 
{
	["Add a custom channel"] = true,
	["A module to play sounds on certain chat messages."] = true,
	["Custom Channels"] = true,
	guild_desc = "Sound for %s guild messages",
	guild_name = "Guild",
	incoming = true,
	["Incoming Sounds"] = true,
	officer_desc = "Sound for %s officer or custom channel messages",
	officer_name = "Officer",
	outgoing = true,
	["Outgoing Sounds"] = true,
	party_desc = "Sound for %s party messages",
	party_name = "Party",
	["Play a sound for a certain channel name (can be a substring)"] = true,
	raid_desc = "Sound for %s raid or battleground group/leader messages",
	raid_name = "Raid",
	["Remove a custom channel"] = true,
	["Reset settings"] = true,
	["Restore default settings and resets custom channel list"] = true,
	Sounds = true,
	["Sound selection for incoming chat messages"] = true,
	["Sound selection for outgoing (from you) chat messages"] = true,
	whisper_desc = "Sound for %s whisper messages",
	whisper_name = "Whisper",
}

)
L:AddLocale("frFR",  
{
	-- ["Add a custom channel"] = "",
	-- ["A module to play sounds on certain chat messages."] = "",
	-- ["Custom Channels"] = "",
	-- guild_desc = "",
	-- guild_name = "",
	-- incoming = "",
	-- ["Incoming Sounds"] = "",
	-- officer_desc = "",
	-- officer_name = "",
	-- outgoing = "",
	-- ["Outgoing Sounds"] = "",
	-- party_desc = "",
	-- party_name = "",
	-- ["Play a sound for a certain channel name (can be a substring)"] = "",
	-- raid_desc = "",
	-- raid_name = "",
	-- ["Remove a custom channel"] = "",
	-- ["Reset settings"] = "",
	-- ["Restore default settings and resets custom channel list"] = "",
	-- Sounds = "",
	-- ["Sound selection for incoming chat messages"] = "",
	-- ["Sound selection for outgoing (from you) chat messages"] = "",
	-- whisper_desc = "",
	-- whisper_name = "",
}

)
L:AddLocale("deDE", 
{
	-- ["Add a custom channel"] = "",
	-- ["A module to play sounds on certain chat messages."] = "",
	-- ["Custom Channels"] = "",
	-- guild_desc = "",
	-- guild_name = "",
	-- incoming = "",
	-- ["Incoming Sounds"] = "",
	-- officer_desc = "",
	-- officer_name = "",
	-- outgoing = "",
	-- ["Outgoing Sounds"] = "",
	-- party_desc = "",
	-- party_name = "",
	-- ["Play a sound for a certain channel name (can be a substring)"] = "",
	-- raid_desc = "",
	-- raid_name = "",
	-- ["Remove a custom channel"] = "",
	-- ["Reset settings"] = "",
	-- ["Restore default settings and resets custom channel list"] = "",
	-- Sounds = "",
	-- ["Sound selection for incoming chat messages"] = "",
	-- ["Sound selection for outgoing (from you) chat messages"] = "",
	-- whisper_desc = "",
	-- whisper_name = "",
}

)
L:AddLocale("koKR",  
{
	-- ["Add a custom channel"] = "",
	-- ["A module to play sounds on certain chat messages."] = "",
	-- ["Custom Channels"] = "",
	-- guild_desc = "",
	-- guild_name = "",
	-- incoming = "",
	-- ["Incoming Sounds"] = "",
	-- officer_desc = "",
	-- officer_name = "",
	-- outgoing = "",
	-- ["Outgoing Sounds"] = "",
	-- party_desc = "",
	-- party_name = "",
	-- ["Play a sound for a certain channel name (can be a substring)"] = "",
	-- raid_desc = "",
	-- raid_name = "",
	-- ["Remove a custom channel"] = "",
	-- ["Reset settings"] = "",
	-- ["Restore default settings and resets custom channel list"] = "",
	-- Sounds = "",
	-- ["Sound selection for incoming chat messages"] = "",
	-- ["Sound selection for outgoing (from you) chat messages"] = "",
	-- whisper_desc = "",
	-- whisper_name = "",
}

)
L:AddLocale("esMX",  
{
	-- ["Add a custom channel"] = "",
	-- ["A module to play sounds on certain chat messages."] = "",
	-- ["Custom Channels"] = "",
	-- guild_desc = "",
	-- guild_name = "",
	-- incoming = "",
	-- ["Incoming Sounds"] = "",
	-- officer_desc = "",
	-- officer_name = "",
	-- outgoing = "",
	-- ["Outgoing Sounds"] = "",
	-- party_desc = "",
	-- party_name = "",
	-- ["Play a sound for a certain channel name (can be a substring)"] = "",
	-- raid_desc = "",
	-- raid_name = "",
	-- ["Remove a custom channel"] = "",
	-- ["Reset settings"] = "",
	-- ["Restore default settings and resets custom channel list"] = "",
	-- Sounds = "",
	-- ["Sound selection for incoming chat messages"] = "",
	-- ["Sound selection for outgoing (from you) chat messages"] = "",
	-- whisper_desc = "",
	-- whisper_name = "",
}

)
L:AddLocale("ruRU",  
{
	["Add a custom channel"] = "Добавить свой канал",
	["A module to play sounds on certain chat messages."] = "Модуль проигрывает зуки для определённых сообщений в чате.",
	["Custom Channels"] = "Личные каналы",
	guild_desc = "Звук %s для сообщений гильдии",
	guild_name = "Гильдия",
	incoming = "Входящие",
	["Incoming Sounds"] = "Звук входящих",
	officer_desc = "Звук %s для сообщений офицеров или личного канала",
	officer_name = "Офицеры",
	outgoing = "Исходящие",
	["Outgoing Sounds"] = "Звуки исходящего",
	party_desc = "Звук %s для сообщений группы",
	party_name = "Группа",
	["Play a sound for a certain channel name (can be a substring)"] = "Проигрывает зук для определённого канала чата (can be a substring)",
	raid_desc = "Звук %s для сообщений группы/лидера рейда или поля сражений",
	raid_name = "Рейд",
	["Remove a custom channel"] = "Удалить свой канал",
	["Reset settings"] = "Сброс настроек",
	["Restore default settings and resets custom channel list"] = "Восстановление стандартных настроек и сброс списка своих каналов чата.",
	-- Sounds = "",
	["Sound selection for incoming chat messages"] = "Выбор звука для входящих сообщений в чате",
	["Sound selection for outgoing (from you) chat messages"] = "Выбор звука для исходящих (от вас) сообщений в чате",
	whisper_desc = "Звук  %s для личных сообщений",
	whisper_name = "Шепот",
}

)
L:AddLocale("zhCN",  
{
	-- ["Add a custom channel"] = "",
	-- ["A module to play sounds on certain chat messages."] = "",
	-- ["Custom Channels"] = "",
	-- guild_desc = "",
	-- guild_name = "",
	-- incoming = "",
	-- ["Incoming Sounds"] = "",
	-- officer_desc = "",
	-- officer_name = "",
	-- outgoing = "",
	-- ["Outgoing Sounds"] = "",
	-- party_desc = "",
	-- party_name = "",
	-- ["Play a sound for a certain channel name (can be a substring)"] = "",
	-- raid_desc = "",
	-- raid_name = "",
	-- ["Remove a custom channel"] = "",
	-- ["Reset settings"] = "",
	-- ["Restore default settings and resets custom channel list"] = "",
	-- Sounds = "",
	-- ["Sound selection for incoming chat messages"] = "",
	-- ["Sound selection for outgoing (from you) chat messages"] = "",
	-- whisper_desc = "",
	-- whisper_name = "",
}

)
L:AddLocale("esES",  
{
	-- ["Add a custom channel"] = "",
	-- ["A module to play sounds on certain chat messages."] = "",
	-- ["Custom Channels"] = "",
	-- guild_desc = "",
	-- guild_name = "",
	-- incoming = "",
	-- ["Incoming Sounds"] = "",
	-- officer_desc = "",
	-- officer_name = "",
	-- outgoing = "",
	-- ["Outgoing Sounds"] = "",
	-- party_desc = "",
	-- party_name = "",
	-- ["Play a sound for a certain channel name (can be a substring)"] = "",
	-- raid_desc = "",
	-- raid_name = "",
	-- ["Remove a custom channel"] = "",
	-- ["Reset settings"] = "",
	-- ["Restore default settings and resets custom channel list"] = "",
	-- Sounds = "",
	-- ["Sound selection for incoming chat messages"] = "",
	-- ["Sound selection for outgoing (from you) chat messages"] = "",
	-- whisper_desc = "",
	-- whisper_name = "",
}

)
L:AddLocale("zhTW",  
{
	-- ["Add a custom channel"] = "",
	-- ["A module to play sounds on certain chat messages."] = "",
	-- ["Custom Channels"] = "",
	-- guild_desc = "",
	-- guild_name = "",
	-- incoming = "",
	-- ["Incoming Sounds"] = "",
	-- officer_desc = "",
	-- officer_name = "",
	-- outgoing = "",
	-- ["Outgoing Sounds"] = "",
	-- party_desc = "",
	-- party_name = "",
	-- ["Play a sound for a certain channel name (can be a substring)"] = "",
	-- raid_desc = "",
	-- raid_name = "",
	-- ["Remove a custom channel"] = "",
	-- ["Reset settings"] = "",
	-- ["Restore default settings and resets custom channel list"] = "",
	-- Sounds = "",
	-- ["Sound selection for incoming chat messages"] = "",
	-- ["Sound selection for outgoing (from you) chat messages"] = "",
	-- whisper_desc = "",
	-- whisper_name = "",
}

)
--@end-non-debug@




----[[
--	Chinese Local : CWDG Translation Team 昏睡墨鱼 (Thomas Mo)
--	CWDG site: http://Cwowaddon.com
--	$Rev: 80553 $
--]]
--

--

--

--

--




-- create prat module
local module = Prat:NewModule(PRAT_MODULE, "AceEvent-3.0")


Prat:SetModuleDefaults(module.name, {
	profile = {
		on	= false,
		["incoming"] = {
			["GUILD"] = "Kachink",
			["OFFICER"] = "Link",
			["PARTY"] = "Text1",
			["RAID"] = "Text2",
			["WHISPER"] = "Heart",
		},
		["outgoing"] = {
			["GUILD"] = "None",
			["OFFICER"] = "None",
			["PARTY"] = "None",
			["RAID"] = "None",
			["WHISPER"] = "None",
		},
		["customlist"] = GetLocale() == "zhTW" and {
		}
		or { ["*"] = "None" },
	}
})



local media, SOUND

--[[------------------------------------------------
    Module Event Functions
------------------------------------------------]]--
-- things to do when the module is enabled
function module:OnModuleEnable()
	media = Prat.Media    
	SOUND = media.MediaType.SOUND
	self:BuildSoundList()
	self:RegisterEvent("UPDATE_CHAT_COLOR", "RefreshOptions")

	Prat.RegisterChatEvent(self, Prat.Events.POST_ADDMESSAGE)

	media.RegisterCallback(self, "LibSharedMedia_Registered", "SharedMedia_Registered")
	media.RegisterCallback(self, "LibSharedMedia_SetGlobal", "SharedMedia_Registered")
end



-- things to do when the module is disabled
function module:OnModuleDisable()
    self:UnregisterAllEvents()
	Prat.UnregisterAllChatEvents(self)
	media.UnregisterAllCallbacks(self)
end

local soundslist = {}


function module:BuildSoundList()
	if not media then return end

    for i,v in ipairs(soundslist) do
        soundslist[i] = nil
    end
    
    for k,v in pairs(media.MediaTable[SOUND]) do
        soundslist[k]=k
    end
end

function module:SharedMedia_Registered(mediatype, name)
    if mediatype == SOUND then
        self:BuildSoundList()
    end
end

do
	local optionGroup_mt = {
			type = "select",
			get = "GetChanOptValue",
			set = "SetChanOptValue",
			dialogControl = 'LSM30_Sound',
			values = AceGUIWidgetLSMlists.sound,
		}

	local optionGroup_mt = { __index = optionGroup_mt }
	
	local function newOptionGroup(text, incoming)
		local t= setmetatable({}, optionGroup_mt)
		t.name = L[text.."_name"]
		t.desc = (L[text.."_desc"]):format(incoming and L["incoming"] or L["outgoing"])
		return t
	end

    local customchans = {}

    function module:RefreshOptions()   
        local o = customchans
        for _,n in ipairs(DEFAULT_CHAT_FRAME.channelList) do
            if not o[n] then
                o[n] = 	{
                name = n, desc = n,
        		type = "select",
    			get = "GetCChanOptValue",
    			set = "SetCChanOptValue",
    			dialogControl = 'LSM30_Sound',
    			values = AceGUIWidgetLSMlists.sound, }
            end
    	end
    end
	
	Prat:SetModuleOptions(module.name, {
	        name = L["Sounds"],
	        desc = L["A module to play sounds on certain chat messages."],
	        type = "group",
			childGroups  = "tab",
			args = {
				cchan = {
					type = "group",
					name = L["Custom Channels"],
					desc = L["Custom Channels"],
					args = customchans
				},
				incoming = {
					type = "group",
					name = L["Incoming Sounds"],
					desc = L["Sound selection for incoming chat messages"],
					order = 20,
					args = {
						party = newOptionGroup("party", true),
						raid = newOptionGroup("raid", true),
						guild = newOptionGroup("guild", true),
						officer = newOptionGroup("officer", true),
						whisper = newOptionGroup("whisper", true),
					},
				},
				outgoing = {
					type = "group",
					name = L["Outgoing Sounds"],
					desc = L["Sound selection for outgoing (from you) chat messages"],
					order = 30,
					args = {
						party = newOptionGroup("party"),
						raid = newOptionGroup("raid"),
						guild = newOptionGroup("guild"),
						officer = newOptionGroup("officer"),
						whisper = newOptionGroup("whisper"),
					},
				},
			},
		}
	)	
end

function module:GetChanOptValue(info, ...)
	return self.db.profile[info[#info-1]][info[#info]:upper()]
end

function module:SetChanOptValue(info, val, ...)
	Prat:PlaySound(val)
	self.db.profile[info[#info-1]][info[#info]:upper()] = val
end

function module:GetCChanOptValue(info, ...)
	return self.db.profile.customlist[info[#info]]
end

function module:SetCChanOptValue(info, val, ...)
	self.db.profile.customlist[info[#info]] = val
end




--[[------------------------------------------------
	Core Functions
------------------------------------------------]]--
function module:Prat_PostAddMessage(info, message, frame, event, text, r, g, b, id)
    if Prat.EVENT_ID and Prat.EVENT_ID == self.lastevent and self.lasteventtype == event then return end
    
	local msgtype = string.sub(event, 10)
	local plr, svr = strsplit("-", (message.PLAYERLINK or ""))
	local outgoing = (plr == UnitName("player")) and true or false
	local sndprof = outgoing and self.db.profile.outgoing or self.db.profile.incoming
    
    if msgtype == "CHANNEL" then 
	    local chan = string.lower(message.ORG.CHANNEL)
		for cname,value in pairs(self.db.profile.customlist) do
			if strlen(cname) > 0 and string.find(chan, string.lower(cname)) then
                self:PlaySound(value)
			end
		end
    else 
		if msgtype == "WHISPER_INFORM" then
		    msgtype = "WHISPER"
		    sndprof = self.db.profile.outgoing
		elseif msgtype == "WHISPER" then
		    sndprof = self.db.profile.incoming
		end
		
		if msgtype == "RAID_LEADER" or msgtype == "BATTLEGROUND" or msgtype == "BATTLEGROUND_LEADER" then
			msgtype = "RAID"
		end
 
		self:PlaySound(sndprof[msgtype], event)
    end
end


function module:PlaySound(sound, event)
    self.lasteventtype = event
    self.lastevent = Prat.EVENT_ID
    Prat:PlaySound(sound)
end

  return
end ) -- Prat:AddModuleToLoad