/* Silent Hill Events */

// Called bevore a player killed
public EVENTS_PlayerKilled_Post( victim, killer )
{
	// Silent Hill isn't enabled
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	// Save that the player is dead
	p_data_b[victim][PLAYER_STATUS] = false;
	
	// Check to see if weapons were silenced on death
	new iWeaponUSPEnt = find_ent_by_owner( -1, "weapon_usp", victim );
	new iWeaponM4A1Ent = find_ent_by_owner( -1, "weapon_m4a1", victim );
		
	if ( is_valid_ent( iWeaponUSPEnt ) )
	{
		g_Silenced[victim][SILENCED_USP] = ( cs_get_weapon_silen( iWeaponUSPEnt ) ) ? true : false;
	}

	if ( is_valid_ent( iWeaponM4A1Ent ) )
	{
		g_Silenced[victim][SILENCED_M4A1] = ( cs_get_weapon_silen( iWeaponM4A1Ent ) ) ? true : false;
	}
	
	/* Clean up any defusal kits we might have made! */
	if ( !g_DefuseKit )
	{
		return HAM_IGNORED;
	}
	
	/* This might have a race condition for team switches... */
	if ( fm_get_user_team( victim ) == CS_TEAM_CT )
	{
		cs_set_user_defuse( victim, 0 );
	}
	
	return HAM_IGNORED;
}

// Called on weaponchange
public EVENTS_CurWeapon( id )
{
	// Silent Hill isn't enabled
	if ( !SH_Check() )
	{
		return;
	}
	
	// The player is a monster
	if ( p_data_b[id][PLAYER_ISMONSTER] )
	{
		// Get the weapon
		static weapon;
		weapon = read_data( 2 );
		
		// The weapon wasn't a knife :0
		if ( weapon != CSW_KNIFE )
		{
			// We have a running strip task
			if ( !task_exists( id + TASK_STRIPWEAPONS ) )
			{
				// Create the task
				set_task( 0.1, "PLAYER_strip_weapons", id + TASK_STRIPWEAPONS );
			}
		}
		
		// Freezetime over?
		if ( g_FreezeTimeOver )
		{
			// Set the speed
			set_pev( id, pev_maxspeed, character_data[p_data[id][PLAYER_CHARACTER]][CHAR_SPEED] ); 
		}
		
		// We can go out
		return;
	}
	
	// We found a VIP and we're in the first dimension?
	if ( g_VIPPlayerID == id && !g_dimension )
	{
		// Freezetime over?
		if ( g_FreezeTimeOver )
		{
			// Set the decreased speed
			set_pev( g_VIPPlayerID, pev_maxspeed, g_vip_speed ); 
		}
	}
	
	// Get the weapon
	static iWeapon;
	iWeapon = read_data( 2 );
	
	// The weapon can't be reloaded - it has no ammo and clip - go out
	if ( (1<<iWeapon) & CANT_RELOAD_BITSUM )
	{
		// Go out
		return;
	}
	
	// her we save the maxammo
	static iMaxAmmo;
	
	// Should we refill the ammo?
	switch ( sh_ammo )
	{
		case 0: // No ammo give
		{
			return;
		}
		
		case 1: // Yes, give him unlimited ammo
		{
			// Get the maxammo
			iMaxAmmo = g_weapon_ammo[iWeapon][MAX_AMMO];
			
			// Something is wrong here, go out
			if ( iMaxAmmo <= 0 )
			{
				return;
			}
			
			// Player hasn't enough ammo
			if ( PLAYER_get_bpammo( id, iWeapon ) < 1 )
			{
				// Set the new ammo
				PLAYER_set_bpammo( id, iWeapon, iMaxAmmo );
			}
		}
		
		case 2: // Yes, give him unlimited clip
		{
			// Get the maxammo
			iMaxAmmo = g_weapon_ammo[iWeapon][MAX_CLIP];
			
			// Something is wrong here, go out
			if ( iMaxAmmo <= 0 )
			{
				return;
			}
			
			// Player hasn't enough clip
			if ( read_data( 3 ) < 1 )
			{
				// Get the weaponname
				static weaponname[32];
				get_weaponname( iWeapon, weaponname, charsmax( weaponname ) );
				
				// Find the entity id
				static iEnt;
				iEnt = find_ent_by_owner( -1, weaponname, id );
				
				// Set the new clip
				set_pdata_int( iEnt, OFFSET_CLIPAMMO, iMaxAmmo, EXTRAOFFSET_WEAPONS );
			}
		}
	}
}

// Called on a new round
public EVENTS_NewRound()
{
	// Silent Hill isn't enabled
	if ( !SH_Check() )
	{
		return;
	}
	
	// Backup our global Christabella health var to default
	g_ChristaHP = sh_christahp;
	
	// Freezetime isn't over now
	g_FreezeTimeOver = false;
	
	// Get the gametime
	g_roundstarttime = get_gametime();
	
	// On new round we're always in the first dimension, we set all back
	WEATHER_SetDefault();
	
	// We didn't used the dimension start mode
	g_bDimensionStart = false;
	
	// Reset christabellas position
	g_ChristaPos[0] = 0.0;
	g_ChristaPos[1] = 0.0;
	g_ChristaPos[2] = 0.0;
	
	// Start the ambience sound
	PLAYER_StartAmbience();
	
	// player can use again guns 
	for ( new i = 0; i < MAX_PLAYERS; ++i )
	{
		p_data_b[i][PLAYER_USEDGUNS] = false;
				
		// Player used the changechar menu - not
		p_data_b[i][PLAYER_USEDCHAR] = false;
	}
	
	return;
}	

// Called after the freezetime is over
public EVENTS_FreezeTimeComplete()
{
	// Silent Hill isn't enabled
	if ( !SH_Check() )
	{
		return;
	}
	
	// Freezetime is over
	g_FreezeTimeOver = true;
	
	// Set every monster the speed
	set_task( 0.3, "PLAYER_SetAllSpeed", TASK_SPEED );
	
	// Set up the tasks for the next dimension switch
	WEATHER_DimensionTask();
	
	return;
}

// Called on the end of a round
public EVENTS_EndRound()
{
	// Silent Hill isn't enabled
	if ( !SH_Check() )
	{
		return;
	}
	
	// Remove dimension initial task
	if ( task_exists( TASK_DIMINITIAL ) )
	{
		remove_task( TASK_DIMINITIAL );
	}
	
	// Remove dimension task
	if ( task_exists( TASK_DIMENSION ) )
	{
		remove_task( TASK_DIMENSION );
	}
	
	// Remove dimension back task
	if ( task_exists( TASK_DIMENSIONBACK ) )
	{
		remove_task( TASK_DIMENSIONBACK );
	}
	
	// Remove the distance check
	if ( task_exists( TASK_DISTANCECHECK ) )
	{
		remove_task( TASK_DISTANCECHECK );
	}
	
	// Remove the light task
	if ( task_exists( TASK_LIGHT ) )
	{
		remove_task( TASK_LIGHT );
	}
	
	// Remove Christabella effect
	if ( task_exists( TASK_LIGHTCHRISTA ) )
	{
		remove_task( TASK_LIGHTCHRISTA );
	}
	
	// On the next round we have a new vip
	g_VIPPlayerID = -1;
	
	// Remove the nightvision from the monsters 
	static players[32], playersnum;
	get_players( players, playersnum );
	
	// Loop through all players
	for ( new i = 0; i < playersnum; ++i )
	{
		// Player alive?
		if ( is_user_alive( players[i] ) )
		{
			// is the player a monster
			if ( p_data_b[players[i]][PLAYER_ISMONSTER] )
			{
				// Remove nightvision
				cs_set_user_nvg( players[i], 0 );
			}
		}
	}
	
	// Random Teams are enabled?
	if ( sh_randomteams >= 1 )
	{
		// Switch the players
		TSWITCH_SwitchTeams();
	}
	
	return;
}

// Called when a player spawns
public EVENTS_PlayerSpawn( id )
{
	// Silent Hill isn't enabled or the player isn't alive
	if ( !SH_Check() || !is_user_alive( id ) || !cs_get_user_team( id ) )
	{
		return HAM_IGNORED;
	}
	
	// Detect if the player is a monster
	PLAYER_is_monster( id );
	
	// The player is alive, hold that for our status var
	p_data_b[id][PLAYER_STATUS] = true;
	
	// Remove previous tasks (if any)
	remove_task( id + TASK_MODELSET );
	
	// Is the player a monster?
	if ( p_data_b[id][PLAYER_ISMONSTER] )
	{
		// Store our custom model in g_player_model[id]
		formatex( g_player_model[id], charsmax( g_player_model[] ), "%s", character_pmodel[p_data[id][PLAYER_CHARACTER]] );
	
		 // Get current model
		new currentmodel[32];
		PLAYER_get_model( id, currentmodel, charsmax( currentmodel ) );
		
		  // Check whether it matches the custom model
		if ( !equal( currentmodel, g_player_model[id] ) )
		{
			// An additional delay is offset at round start
			// since SVC_BAD is more likely to be triggered there
			if ( get_gametime() - g_roundstarttime < 5.0 )
			{
				set_task( 5.0 * MODELCHANGE_DELAY, "PLAYER_model_update", id + TASK_MODELSET );
			}
			else
				PLAYER_model_update( id + TASK_MODELSET );
		}
	}
	
	 // Not a monster, but still has a custom model
	else if ( g_has_custom_model[id] )
	{
		// Reset it back to the default one
		PLAYER_reset_model( id );
	}

	// We have characters enabled?
	if ( sh_characters > 0 && g_charcounter > 1 )
	{
		// The player is a monster AND a Bot
		if ( p_data_b[id][PLAYER_ISMONSTER] && is_user_bot( id ) )
		{
			// Hasn't selected a character
			if ( !p_data_b[id][PLAYER_SELECTEDCHAR] )
			{
				// Okay now he has a char
				p_data_b[id][PLAYER_SELECTEDCHAR] = true;
				
				// Get a random character
				new iRandomNum = random_num( 0, g_charcounter );
				
				// Player get the random monster
				p_data[id][PLAYER_CHARACTER] = iRandomNum;
			}
		}
		
		// The player is terrorist (a monster) 
		else if ( p_data_b[id][PLAYER_ISMONSTER] )
		{
			// He hasn't selected a character yet
			if ( !p_data_b[id][PLAYER_SELECTEDCHAR] )
			{
				// Okay. Show him the character select menu
				MENU_SelectChar( id );
			}
		}
	}
	
	// Just open the guns-menu if the player is CT and equip menu is enabled
	if ( !p_data_b[id][PLAYER_ISMONSTER] && sh_equipmenu == 1 )
	{
		// the player is a bot, give him random weapons
		if ( is_user_bot( id ) )
		{
			// Give him the rnd weapons
			PLAYER_bot_rndwpns( id );
			
			// We can go out
			return HAM_IGNORED;
		}
		
		// Open the Equip-Menu
		if ( g_mShowuser[id] )
		{
			MENU_EquipMain( id );
		}
	
		// give the player the previous setup
		else
		{
			// Give him previus weapons
			EQUIP_PrevSetup( id );
			
			// Tell him how to re-enable the menu
			client_print( id, print_chat, "%s %L", MOD_NAME, id, "CHAT_EQUIPREENABLE" );
		}
	}
	
	// The player is a terrorist (Monster) he has no weapons just a knife
	if ( p_data_b[id][PLAYER_ISMONSTER] )
	{
		// Strip all weapons
		set_task( 0.1, "PLAYER_strip_weapons", ( TASK_STRIPWEAPONS + id ) );
		
		// Give him the bonus abilitys
		PLAYER_MonsterAdv( id );
	}
	
	return HAM_IGNORED;
}

// Called on ClientKeyValue
public EVENTS_SetClientKeyValue( id, const infobuffer[], const key[] )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return FMRES_IGNORED;
	}
	
	// Block CS model changes
	if ( g_has_custom_model[id] && equal( key, "model" ) )
		return FMRES_SUPERCEDE;
    
	return FMRES_IGNORED;
}

// Called on ClientUserInfoChanged
public EVENTS_ClientUserInfoChanged( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return FMRES_IGNORED;
	}
	
	 // Player doesn't have a custom model
	if ( !g_has_custom_model[id] )
		return FMRES_IGNORED;
    
	// Get current model
	static currentmodel[32];
	PLAYER_get_model( id, currentmodel, charsmax( currentmodel ) );
    
	// Check whether it matches the custom model - if not, set it again
	if ( !equal( currentmodel, g_player_model[id] ) && !task_exists( id + TASK_MODELSET ) )
		PLAYER_set_model( id + TASK_MODELSET );
    
	return FMRES_IGNORED;
}

// For the block event
public EVENTS_addToFullPack( es, e, ent, host, hostflags, player, pSet )
{
	// Is silent hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// The player available?
	if ( player )
	{
		// We're in the first dimension
		if ( !g_dimension && p_data_b[host][PLAYER_STATUS] )
		{
			// This let all players hide in their own worlds (thanks connor)
			set_es( es, ES_Origin, Float:{ 8192.0, 8192.0, 8192.0 } );
		}		
	}
	
	return;
}

// Callen onf Prethink Post
public EVENTS_prethink_post( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return FMRES_IGNORED;
	}
	
	// What we're doing here?
	if ( !g_brestorevel )
	{
		return FMRES_IGNORED;
	}
	
	// set it back
	g_brestorevel = false;
	
	// Get the flags from the player
	static flag;
	flag = pev( id, pev_flags );
	
	if ( !( flag & FL_ONTRAIN ) )
	{
		// Get the entitiy
		static ent;
		ent = pev( id, pev_groundentity );
		
		if ( pev_valid( ent ) && ( flag & FL_CONVEYOR ) )
		{
			static Float:vectemp[3];
			pev( id, pev_basevelocity, vectemp );
			
			xs_vec_add( g_vecvel, vectemp, g_vecvel );
		}

		if ( g_hitdelay[id] > get_gametime() && ( !( pev( id, pev_flags ) & FL_DUCKING ) ) )
		{
			xs_vec_mul_scalar( g_vecvel, character_data[p_data[id][PLAYER_CHARACTER]][CHAR_HITSPEED], g_vecvel );
		}
	
		set_pev( id, pev_velocity, g_vecvel );
		return FMRES_HANDLED;
	}
	
	return FMRES_IGNORED;
}

// Called on Prethink
public EVENTS_preThink( id )
{
	// Is silent hill enabled?
	if ( !SH_Check() )
	{
		return FMRES_IGNORED;
	}
	
	// Player alive?
	if ( !is_user_alive( id ) )
	{
		// We save that in our status array
		p_data_b[id][PLAYER_STATUS] = false;
		
		return FMRES_IGNORED;
	}
	
	// Is the player a monster?
	if ( p_data_b[id][PLAYER_ISMONSTER] )
	{
		// Get the flags
		static flags
		flags = pev( id, pev_flags );
	
		// Player is on ground
		if ( flags & FL_ONGROUND )
		{
			pev( id, pev_velocity, g_vecvel );
			g_brestorevel = true;
		}
		
		// Get the Character ID from the player
		static iCharID;
		iCharID = p_data[id][PLAYER_CHARACTER];
		
		// Get the gametime
		static Float:fGameTime;
		fGameTime = get_gametime();
	
		// Get the hp from the player
		static Float:fHP;
		pev( id, pev_health, fHP );
		
		// We're under the normal hp and regeneration time was expired
		if ( fHP < character_data[iCharID][CHAR_HEALTH] && g_regendelay[id]  < fGameTime )
		{
			// Regenerate one hp
			set_pev( id, pev_health, fHP + 1.0 );
			
			// And set up the delay
			g_regendelay[id] = fGameTime + character_data[iCharID][CHAR_REGENDLY];
		}
	}
	
	return FMRES_IGNORED;
}

// Called if a player gets damage
public EVENTS_takedamage_player( victim, inflictor, attacker, Float:damage, damagetype )
{
	// Is silent hill enabled?
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	// Let us do some checks
	if ( damagetype & DMG_GENERIC || victim == attacker || !is_user_alive( victim ) || !is_user_connected( attacker ) )
	{
		return HAM_IGNORED;
	}
	
	// More Checks
	if ( ( p_data_b[attacker][PLAYER_ISMONSTER] && p_data_b[victim][PLAYER_ISMONSTER] ) || ( !p_data_b[attacker][PLAYER_ISMONSTER] && !p_data_b[victim][PLAYER_ISMONSTER] ) || ( ( damagetype & DMG_HEGRENADE ) && p_data_b[attacker][PLAYER_ISMONSTER] ) )
	{
		return HAM_SUPERCEDE;
	}
	
	// The attacker was a human
	if ( p_data_b[victim][PLAYER_ISMONSTER] )
	{
		// Get the gametime
		static Float:fGameTime;
		fGameTime = get_gametime();
		
		// Set the new delay
		g_regendelay[victim] = fGameTime + character_data[p_data[victim][PLAYER_CHARACTER]][CHAR_HITREGENDLY];
		g_hitdelay[victim] = fGameTime + character_data[p_data[victim][PLAYER_CHARACTER]][CHAR_HITDELAY];
		
		// Calculate the new damage depend on the inflictor = hegrenade
		damage *= ( damagetype & DMG_HEGRENADE ) ? character_data[p_data[victim][PLAYER_CHARACTER]][CHAR_HEDEFENCE] : character_data[p_data[victim][PLAYER_CHARACTER]][CHAR_DEFENCE];
		
		// set the new damage value on the ham event
		SetHamParamFloat( 4, damage );
	}
	
	// The attacker was a monster
	else
	{
		// On more check
		if ( get_user_weapon( attacker ) != CSW_KNIFE )
		{
			return HAM_SUPERCEDE;
		}
		
		// Calculate the new damage
		damage *= character_data[p_data[attacker][PLAYER_CHARACTER]][CHAR_ATTACK];
		
		// Set the new damage
		SetHamParamFloat( 4, damage );
	}
	
	return HAM_HANDLED;
}

// Remove the BuyZone
public EVENTS_touch_buyzone( ent, id )
{
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	// Set as Solid_Not
	set_pev ( ent, pev_solid, SOLID_NOT );
	
	// Send it back
	return HAM_SUPERCEDE;
}

// Someone spawned with the bomb - strip all weapons and give him all back (without C4)
public EVENTS_SpawnWithBomb()
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// get the id
	new id = get_loguser_index();
	
	// wrong player?!
	if ( !is_user_alive( id ) )
	{
		return;
	}
	
	// Remove the icon
	// Just the icon because the bomb will later stripped (all monsters have no weapons)
	message_begin( MSG_ONE, get_user_msgid( "StatusIcon" ), _, id );
	write_byte( 0 );
	write_string( "c4" );
	message_end();
	
	return;
}

// Called on a traceattack on christabella
public EVENTS_traceChrista( victim, attacker, Float:damage, Float:direction[3], tracehandle, damagetype )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	// A human can't attack christabella
	if ( !p_data_b[attacker][PLAYER_ISMONSTER] )
	{
		return HAM_SUPERCEDE;
	}
	
	// We're on a cs_ map?
	if ( g_PlayCSMap )
	{
		// Can't trace christa
		return HAM_SUPERCEDE;
	}
	
	return HAM_IGNORED;
}

// Called when someone gets attacked
public EVENTS_traceattack( victim, attacker, Float:damage, Float:direction[3], tracehandle, damagetype )
{
	// Silent isn't enabled
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	// we're not in the second dimension
	if ( !g_dimension )
	{
		return HAM_SUPERCEDE;
	}
	
	// Some more checks
	if ( !is_user_connected( attacker ) || !p_data_b[victim][PLAYER_ISMONSTER] )
	{
		return HAM_IGNORED;
	}
	
	// Can't attack other teammember
	if ( ( p_data_b[attacker][PLAYER_ISMONSTER] && p_data_b[victim][PLAYER_ISMONSTER] ) || ( !p_data_b[attacker][PLAYER_ISMONSTER] && !p_data_b[victim][PLAYER_ISMONSTER] ) )
	{
		return HAM_SUPERCEDE;
	}
	
	// Get the weapon knockback
	static kbpower;
	kbpower = g_weapon_knockback[get_user_weapon( attacker )];
	
	// The weapon has knockback
	if ( kbpower != -1 ) 
	{
		// Get the velocity
		static Float:velocity[3];
		pev( victim, pev_velocity, velocity );
		
		// Save it temporary
		static Float:tempvec;
		tempvec = velocity[2];	
		
		// Set the knockback
		xs_vec_mul_scalar( direction, damage, direction );
		xs_vec_mul_scalar( direction, character_data[p_data[victim][PLAYER_CHARACTER]][CHAR_KNOCKBACK], direction );
		xs_vec_mul_scalar( direction, g_knockbackpower[kbpower], direction );
			
		xs_vec_add( direction, velocity, velocity );
		velocity[2] = tempvec;
			
		set_pev( victim, pev_velocity, velocity );
			
		return HAM_HANDLED;
	
	}
	
	return HAM_IGNORED;
}

// Called on audio send (CT win, T win etc)
public EVENTS_sendaudio( msgid, dest, id )
{
	// Silent Hill is enabled?
	if ( !SH_Check() )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Get the audiocode
	static audiocode[22];
	get_msg_arg_string( 2, audiocode, charsmax( audiocode ) );
	
	// Terrors won 
	if( equal( audiocode[7], "terwin" ) )
	{
		set_msg_arg_string( 2, t_winsounds[_random( g_iTWinS )] );
	}
	
	// CounterTerrorists won
	else if ( equal( audiocode[7], "ctwin" ) )
	{
		set_msg_arg_string( 2, ct_winsounds[_random( g_iCTWinS )] );
	}
	
	// Fire in the hole sound
	else if ( equal( audiocode, "%!MRAD_FIREINHOLE" ) )
	{
		// We're in the first dimension
		if ( !g_dimension )
		{
			return PLUGIN_HANDLED;
		}
	}
	
	return PLUGIN_CONTINUE;
}

// Message event (like 'Counter Terrorists Win' etc)
public EVENTS_textmsg( msgid, dest, id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Get the message
	static txtmsg[25], txtmsg5[25], txtmsg6[25], WinMsg[256];
	get_msg_arg_string( 2, txtmsg, charsmax( txtmsg ) );
	
	// We have a 5 msg
	if ( get_msg_args() == 5 )
	{
		get_msg_arg_string( 5, txtmsg5, charsmax( txtmsg5 ) );
	}
	
	// We have a 6 msg
	else if ( get_msg_args() == 6 )
	{
		get_msg_arg_string( 6, txtmsg6, charsmax( txtmsg6 ) );
	}
	
	// Injured a hostage?
	if ( equal( txtmsg[1], "Injured_Hostage" ) )
	{
		// hide this text
		return PLUGIN_HANDLED;
	}
	
	// Dropped the bomb
	else if ( equal( txtmsg[1], "Game_bomb_drop" ) )
	{
		// hide this text
		return PLUGIN_HANDLED;
	}
	
	// Hostages rescued
	else if ( equal( txtmsg[1], "All_Hostages_Rescued" ) )
	{
		// Formate the right text for the win message
		formatex( WinMsg, charsmax( WinMsg ), "%L", id, "TXT_CHRISTA_RESCUED" );
		
		// Set the winmessage
		set_msg_arg_string( 2, WinMsg );
	}
	
	// Monsters won the round
	else if ( equal( txtmsg[1], "Terrorists_Win" ) )
	{
		// Formate the right text for the win message
		formatex( WinMsg, charsmax( WinMsg ), "%L", id, "TXT_MONSTERS_WIN" );
		
		// Set the winmessage
		set_msg_arg_string( 2, WinMsg );
	}
	
	// Humans won the roung
	else if ( equal( txtmsg[1], "CTs_Win" ) || equal( txtmsg[1], "Target_Saved" ) )
	{
		// Formate the right text for the win message
		formatex( WinMsg, charsmax( WinMsg ), "%L", id, "TXT_HUMANS_WIN" );
		
		// Set the winmessage
		set_msg_arg_string( 2, WinMsg );
	}
	
	// Killed a hostage :0
	else if ( equal( txtmsg[1], "Killed_Hostage" ) )
	{
		// hide this text
		return PLUGIN_HANDLED;
	}
	
	// Fire in the hole msg
	else if ( equal( txtmsg5[1], "Fire_in_the_hole" ) || equal( txtmsg6[1], "Fire_in_the_hole" ) )
	{
		// We're in the first dimension
		if ( !g_dimension )
		{
			// Block the msg
			return PLUGIN_HANDLED;
		}
	}
	
	// VIP was killed
	else if ( equal( txtmsg[1], "VIP_Assassinated" ) )
	{
		// Formate the new message
		formatex( WinMsg, charsmax( WinMsg ), "%L", id, "TXT_VINCENT_DIED" );
		
		// Set the winmsg
		set_msg_arg_string( 2, WinMsg );
	}
	
	// VIP rescued
	else if ( equal( txtmsg[1], "VIP_Escaped" ) )
	{
		// Formate the new message
		formatex( WinMsg, charsmax( WinMsg ), "%L", id, "TXT_VINCENT_RESCUED" );
		
		// Set the winmsg
		set_msg_arg_string( 2, WinMsg );
	}
	
	return PLUGIN_CONTINUE;
}

// Christabella gets damage
public EVENTS_ChristaDamage( victim, inflictor, attacker, Float:damage, dmgtype )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	// The attacker is a human?! no thats not possible
	if ( !p_data_b[attacker][PLAYER_ISMONSTER] )
	{
		return HAM_SUPERCEDE;
	}
	
	// We're on a cs_ map?
	if ( g_PlayCSMap )
	{
		// It's not possible to dmg christabella
		return HAM_SUPERCEDE;
	}
	
	// We have a de_ map
	else if ( g_PlayDEMap )
	{
		// Get the health from the hostage
		static Float:fHP;
		pev( victim, pev_health, fHP );
		
		// Backup our global Christabella health var
		g_ChristaHP = ( fHP - damage );
	}
	
	return HAM_IGNORED;
}

// Christabella died
public EVENTS_ChristaKilled( victim, killer )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	// We have a de_ map
	if ( g_PlayDEMap && pev_valid( victim ) )
	{
		// Set the global var to zero
		g_ChristaHP = 0.0;
			
		// Get all players
		static players[32], playersnum;
		get_players( players, playersnum );
			
		// Loop through all players
		for ( new i = 0; i < playersnum; ++i )
		{
			// Is the player a monster?
			if ( p_data_b[players[i]][PLAYER_ISMONSTER] )
			{
				// Step 
				continue;
			}
				
			// Kill the player - silent
			user_silentkill( players[i] );
			
			// Remove the death and the selfkill frag
			cs_set_user_deaths( players[i], get_user_deaths( players[i] ) - 1 );
		}
	}
	
	return HAM_IGNORED;
}
	

// Remove the radarpoints on the radar
public EVENTS_radarmsg()
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Hide the points
	return PLUGIN_HANDLED;
}

// Called on weapon reload (hide the sound if we're in the first dimension)
public EVENTS_OnReload( const i_Ent )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	// We're in the right dimension?
	if ( !g_dimension )
	{
		// We're reloading?
		if ( PLAYER_IsWeaponReloading ( pev ( i_Ent , pev_owner ), i_Ent ) )
		{
			// Is currently the dimension switch sound running?
			if ( !g_StartedDimSound )
			{
				// Okay stop the reload sound
				client_cmd ( 0, "stopsound" ); // execute a stop sound to hide the reload sound
			}
		}
	}
	
	return HAM_IGNORED;
}

// Called on every scoreattrib event
public EVENTS_scoreattrib( msgid, dest, id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// filter the message
	static attrib;
	attrib = get_msg_arg_int( 2 );
	
	// Player is a VIP and we're on a as_ map?
	if ( g_PlayASMap && ( attrib == ATTRIB_VIP ) )
	{
		// We have no vip
		if ( g_VIPPlayerID < 0 )
		{	
			// Custome objectives available?
			if ( sh_objectives > 0 )
			{
				// Save the ID
				g_VIPPlayerID = id;
			}
		}
	}
	
	// Player is the bomb carrier - not !
	else if( attrib == ATTRIB_BOMB )
	{
		set_msg_arg_int( 2, ARG_BYTE, 0 );
	}
}

// Called on weapon drop
public EVENTS_WeaponBoxSpawn( iEnt )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return HAM_IGNORED;
	}
	
	if ( pev_valid( iEnt ) )
	{
		// Remove the dropped weapon
		entity_set_int( iEnt, EV_INT_flags, FL_KILLME );
		call_think( iEnt );
	}
	
	return HAM_IGNORED;
}

// Called on a thrown grenade
public grenade_throw( id, iEnt, wID )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// We're in the first dimension
	if ( !g_dimension && pev_valid( iEnt ) )
	{
		// remove this entity
		remove_entity( iEnt );
	}
}

// Called on an entity spawn (only activ between plugin_precache and plugin_init)
public EVENTS_ObjectSpawn( iEnt )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return FMRES_IGNORED;
	}
	
	// Valid entity?
	if ( !pev_valid( iEnt ) )
	{
		return FMRES_IGNORED;
	}
	
	// Get the classname
	static classname[32];
	pev( iEnt, pev_classname, classname, charsmax( classname ) );
	
	// We found a hostage
	if ( equal( classname, "hostage_entity" ) )
	{
		// Add the classtype
		g_iObjectiveEntType[g_iTotalObjectiveEnts] = OBJENT_HOSTAGE;
		
		// Get the origin and save it
		get_brush_entity_origin( iEnt, g_fObjectiveOrigin[g_iTotalObjectiveEnts] );

		// Increment the total number
		g_iTotalObjectiveEnts++;
		
		// Remove the hostage
		engfunc( EngFunc_RemoveEntity, iEnt );
		
		// Block the spawn effect
		return FMRES_SUPERCEDE;
	}
	
	// We found a buyzone
	else if ( equal( classname, "func_buyzone" ) )
	{
		// Remove the buyzone
		engfunc( EngFunc_RemoveEntity, iEnt );
		
		// Block the spawn
		return FMRES_SUPERCEDE;
	}
	
	return FMRES_IGNORED;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
