/* Silent Hill Player functions */

// Set Monster abilitys
public PLAYER_MonsterAdv( id )
{
	// get the char id
	static iCharID;
	iCharID = p_data[id][PLAYER_CHARACTER];
	
	// get the current health
	static Float:fHealth;
	pev( id, pev_health, fHealth );
	
	// The health is under the normal health
	if ( fHealth < character_data[iCharID][CHAR_HEALTH] )
	{
		// set the health
		set_pev( id, pev_health, character_data[iCharID][CHAR_HEALTH] );
	}
	
	// Set the gravity
	set_pev( id, pev_gravity, character_data[iCharID][CHAR_GRAVITY] );
	
	return;
}

// Set for all the speed
public PLAYER_SetAllSpeed()
{
	// Get all players
	static players[32], playersnum;
	get_players( players, playersnum );
	
	// Loop through all players
	for ( new i = 0; i < playersnum; ++i )
	{
		// Player isn't alive
		if ( !is_user_alive( players[i] ) )
		{
			continue;
		}
		
		// The player is a monster
		if ( p_data_b[players[i]][PLAYER_ISMONSTER] )
		{
			// Set the speed
			set_pev( players[i], pev_maxspeed, character_data[p_data[players[i]][PLAYER_CHARACTER]][CHAR_SPEED] );
		}
		
		// The player is a vip :0
		else if ( players[i] == g_VIPPlayerID && g_PlayASMap )
		{
			// Set the VIP speed
			set_pev( players[i], pev_maxspeed, g_vip_speed ); 
		}
	}
}

// Get the right ID from a logevent (thanks VEN)
stock get_loguser_index() 
{
	new loguser[80], name[32];
	read_logargv( 0, loguser, charsmax( loguser ) );
	parse_loguser(loguser, name, charsmax( name ) );
 
	// Return the ID
	return get_user_index( name );
}

// Strip all weapons 
public PLAYER_strip_weapons( id ) 
{
	// Detect the right id
	if ( id > TASK_STRIPWEAPONS )
	{
		id -= TASK_STRIPWEAPONS;
	}
	
	// Player alive?
	if ( !is_user_alive( id ) )
	{
		return;
	}
	
	// Strip all weapons
	static stripent;
	if ( !pev_valid( stripent ) )
	{
		stripent = engfunc ( EngFunc_CreateNamedEntity, engfunc( EngFunc_AllocString, "player_weaponstrip" ) );
		dllfunc ( DLLFunc_Spawn, stripent );
		set_pev ( stripent, pev_solid, SOLID_NOT );
	}
	dllfunc ( DLLFunc_Use, stripent, id );
	
	// Give him a knife back and a nightvision
	EQUIP_give_weapon( id, "weapon_knife" );
	cs_set_user_nvg( id, 1 );
	
	// Show him the monster hands
	set_pev( id, pev_weaponmodel2, "" );
	set_pev( id, pev_viewmodel2, character_wmodel[p_data[id][PLAYER_CHARACTER]] ); 
	
	// Extra check (maybe the player has armor from the last round)
	cs_set_user_armor( id, 0, CS_ARMOR_NONE );
} 

// Reset data for the new player
public PLAYER_ResetData( id )
{
	// Reset some VAR's
	g_mShowuser[id] = true;
	g_mNades[id] = false;
	g_mArmor[id] = false;
	g_Silenced[id][SILENCED_M4A1] = false;
	g_Silenced[id][SILENCED_USP] = false;
	g_regendelay[id] = 0.0;
	g_hitdelay[id] = 0.0;
	g_has_custom_model[id] = 0;
		
	// Reset the data arrays
	for ( new i = 0; i < MAX_DATA; ++i )
	{
		p_data[id][i] = 0;
	}
	
	// Reset the data bool arrays
	for ( new i = 0; i < MAX_DATA_B; ++i )
	{
		p_data_b[id][i] = false;
	}
}

// Detect if the player is a monster
public PLAYER_is_monster( id )
{
	// The player is a terror, he is a monster
	p_data_b[id][PLAYER_ISMONSTER] = ( fm_get_user_team( id ) == CS_TEAM_T ? true : false );
}

// update the model
public PLAYER_model_update( taskid )
{
	static Float:current_time;
	current_time = get_gametime();
    
	// Do we need a delay?
	if ( current_time - g_models_targettime >= MODELCHANGE_DELAY )
	{
		PLAYER_set_model( taskid );
		g_models_targettime = current_time;
	}
    
	else
	{
		set_task( ( g_models_targettime + MODELCHANGE_DELAY ) - current_time, "PLAYER_set_model", taskid );
		g_models_targettime = g_models_targettime + MODELCHANGE_DELAY;
	}
}

public PLAYER_set_model( player )
{
	// Get actual player id
	player -= TASK_MODELSET;
    
	// Is player alive or nomore a monster 
	if ( !is_user_alive( player ) || !p_data_b[player][PLAYER_ISMONSTER] )
	{
		return;
	}
	
	// Set new model
	engfunc( EngFunc_SetClientKeyValue, player, engfunc( EngFunc_GetInfoKeyBuffer, player ), "model", character_pmodel[p_data[player][PLAYER_CHARACTER]] );
    
	// Remember this player has a custom model
	g_has_custom_model[player] = true;
}

stock PLAYER_get_model( player, model[], len )
{
	// Retrieve current model
	engfunc( EngFunc_InfoKeyValue, engfunc( EngFunc_GetInfoKeyBuffer, player ), "model", model, len );
}

stock PLAYER_reset_model( id )
{
	// Player doesn't have a custom model any longer
	g_has_custom_model[id] = false;

	// Reset the model
	dllfunc( DLLFunc_ClientUserInfoChanged, id, engfunc( EngFunc_GetInfoKeyBuffer, id ) );
	
	static viewmodel[64];
	pev( id, pev_viewmodel2, viewmodel, 63 );
    
	// Reset the weapon (hands)
	if ( equal( viewmodel, character_wmodel[p_data[id][PLAYER_CHARACTER]] ) )
	{
		static weapon;
		weapon = fm_lastknife( id );

		if ( pev_valid( weapon ) )
			ExecuteHam( Ham_Item_Deploy, weapon );
	}
}

// Set the user to a team
stock PLAYER_set_user_team( index, team )
{
	set_pdata_int(index,OFFSET_TEAM, team)
	emessage_begin(MSG_ALL, g_msg_teaminfo)
	ewrite_byte(index)
	ewrite_string(g_teaminfo[team])
	emessage_end()
	
	return 1;
}

// Creathe the Hud-Message for all players
public PLAYER_CreateHud()
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// Get all players
	static players[32], playersnum, PlayerText[256], Float:fHP;
	get_players( players, playersnum );
	
	// Set the position from the hudmessage
	set_hudmessage( _, _, _, 0.015, 0.78, _, 0.2, 0.2 );
	
	// Loop through every player
	for ( new i = 0; i < playersnum; ++i )
	{
		// player isn't alive
		if ( !is_user_alive( players[i] ) )
		{
			continue;
		}
		
		// Reset the text from the player before
		PlayerText[0] = 0;
		
		// The player is a monster, add the hp and the charactername
		if ( p_data_b[players[i]][PLAYER_ISMONSTER] )
		{
			// Get the hp from the player
			pev( players[i], pev_health, fHP );
			
			// Create the text
			formatex( PlayerText, charsmax( PlayerText ), "HP: %d Char: %s ", floatround( fHP ), character_name[p_data[players[i]][PLAYER_CHARACTER]] );
		}
		
		// We're on a de_ map, add the life from christabella
		if ( g_PlayDEMap )
		{
			formatex( PlayerText, charsmax( PlayerText ), "%sChristabella: %dhp", PlayerText, floatround( g_ChristaHP ) );
		}
		
		// And set up the hudmessage
		ShowSyncHudMsg( players[i], g_SyncHud, PlayerText );
	}
}

// Blocks the teamswitch
public PLAYER_BlockSwitch( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Player switched, save that
	p_data_b[id][PLAYER_STATUS] = true;
	
	// The player switched to spectators?
	if ( fm_get_user_team( id) == CS_TEAM_SPECTATOR )
	{
		// Save that
		p_data_b[id][PLAYER_STATUS] = false;
		
		// Okay
		return PLUGIN_CONTINUE;
	}
	
	// Player alive?
	if ( is_user_alive( id ) )
	{
		// Then block the teamswitch
		return PLUGIN_HANDLED;
	}
	
	return PLUGIN_CONTINUE;
}

// Starts the Ambience sound
public PLAYER_StartAmbience()
{
	// Stop all sounds before we play a new
	StopSound();
	
	// Here we save our random number
	static iRandomNum;
	
	// We're in the first dimension
	if ( !g_dimension )
	{
		// Get a random number
		iRandomNum = random_num( 0, g_iFirstAmbienceS - 1 );
		
		// Play the sound file
		PlaySound( ambience_first_sound[iRandomNum] );
	}
	
	// We're in the second dimension
	else 
	{
		// Get a random num
		iRandomNum = random_num( 0, g_iSeconAmbienceS - 1 );
		
		// Play the sound file
		PlaySound( ambience_secon_sound[iRandomNum] );
	}
}

// Checks if a player is reloading
public PLAYER_IsWeaponReloading ( const id, const i_Ent )
{
	// --| If we're holding a shotgun.
         if ( 1 << get_pdata_int ( i_Ent, m_iId, 4 ) & SHOTGUNS_BITSUM )
         {
		// --| We check its animation instead of m_fInSpecialReload because
		// --| Event_OnReload will be called 3 times by ball and it's a pain to
		// --| deal with that when we want to play the sound one time.
		if ( pev ( id, pev_weaponanim ) == sg_start_reload )  { return 1; }
         }

	// --| Other weapons.
         return get_pdata_int ( i_Ent, m_fInReload, 4 );
}

// Create's a flare attached to a player
public PLAYER_AttachFlare( id )
{
	// Get the original id
	id -= TASK_FLARE;
	
	// we're in the wrong dimension, go out of this
	if ( !g_dimension )
	{
		return;
	}
	
	static Float:originF[3];
	pev( id, pev_origin, originF );
	
	// Lighting
	engfunc(EngFunc_MessageBegin, MSG_PAS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_DLIGHT) // TE id
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	write_byte(25) // radius
	write_byte(255) // r
	write_byte(255) // g
	write_byte(255) // b
	write_byte(10) //life
	write_byte(1) //decay rate
	message_end()
	
	// Set up the task again
	set_task( 0.5, "PLAYER_AttachFlare", id + TASK_FLARE );
}

// Give a bot random weapons
public PLAYER_bot_rndwpns( id )
{
	// We can give him a secondary weapon
	if ( g_mSecStatus )
	{
		// Save the random weapon in our array
		g_SecWeapons[id] = random_num( 0, MAX_SECONDARY - 1 );
	}
			
	// We can give him a primary weapon
	else if ( g_mPrimStatus )
	{
		// Save the random num for the primary weapons
		g_PrimWeapons[id] = random_num( 0, MAX_PRIMARY - 1 );
	}
			
	// Open the Armor menu
	else if ( g_mArmorStatus )
	{
		// Give him maybe armor
		g_mArmor[id] = ( random_num( 0, 1 ) ? true : false );
	}
			
	// Open the Grenades menu
	else if ( g_mNadeStatus )
	{
		// Give him maybe grenades
		g_mNades[id] = ( random_num( 0, 1 ) ? true : false );
	}
			
	// Set all weapons
	EQUIP_equipUser( id, EQUIP_ALL );
}

// Returns the bpammo
stock PLAYER_get_bpammo( index, weapon )
{
	static offset
	switch(weapon)
	{
		case CSW_AWP: offset = OFFSET_AMMO_338MAGNUM
		case CSW_SCOUT, CSW_AK47, CSW_G3SG1: offset = OFFSET_AMMO_762NATO
		case CSW_M249: offset = OFFSET_AMMO_556NATOBOX
		case CSW_FAMAS, CSW_M4A1, CSW_AUG, 
		CSW_SG550, CSW_GALI, CSW_SG552: offset = OFFSET_AMMO_556NATO
		case CSW_M3, CSW_XM1014: offset = OFFSET_AMMO_BUCKSHOT
		case CSW_USP, CSW_UMP45, CSW_MAC10: offset = OFFSET_AMMO_45ACP
		case CSW_FIVESEVEN, CSW_P90: offset = OFFSET_AMMO_57MM
		case CSW_DEAGLE: offset = OFFSET_AMMO_50AE
		case CSW_P228: offset = OFFSET_AMMO_357SIG
		case CSW_GLOCK18, CSW_TMP, CSW_ELITE, 
		CSW_MP5NAVY: offset = OFFSET_AMMO_9MM
		default: offset = 0
	}
	return offset ? get_pdata_int(index, offset) : 0
}

// Set the new bpammo
stock PLAYER_set_bpammo( index, weapon, amount )
{
	static offset
	switch(weapon)
	{
		case CSW_AWP: offset = OFFSET_AMMO_338MAGNUM
		case CSW_SCOUT, CSW_AK47, CSW_G3SG1: offset = OFFSET_AMMO_762NATO
		case CSW_M249: offset = OFFSET_AMMO_556NATOBOX
		case CSW_FAMAS, CSW_M4A1, CSW_AUG, 
		CSW_SG550, CSW_GALI, CSW_SG552: offset = OFFSET_AMMO_556NATO
		case CSW_M3, CSW_XM1014: offset = OFFSET_AMMO_BUCKSHOT
		case CSW_USP, CSW_UMP45, CSW_MAC10: offset = OFFSET_AMMO_45ACP
		case CSW_FIVESEVEN, CSW_P90: offset = OFFSET_AMMO_57MM
		case CSW_DEAGLE: offset = OFFSET_AMMO_50AE
		case CSW_P228: offset = OFFSET_AMMO_357SIG
		case CSW_GLOCK18, CSW_TMP, CSW_ELITE, 
		CSW_MP5NAVY: offset = OFFSET_AMMO_9MM
		default: offset = 0
	}
	
	if(offset) 
		set_pdata_int(index, offset, amount)
	
	return 1
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
