/* Silent Hill Team-Switch */

// Called on a new round - switch the players
public TSWITCH_SwitchTeams()
{
	// Get all players
	static players[32], playersnum;
	get_players( players, playersnum );
	
	// Not enough players
	if ( playersnum < 2 )
	{
		return;
	}
	
	// Loop through all players
	new iCTCount, iTCount, iTeam, iRandomNum;
	for ( new i = 0; i < playersnum; ++i )
	{
		// Save the team
		iTeam = fm_get_user_team( players[i] );
		
		// Player is on a team?
		if ( iTeam != CS_TEAM_T && iTeam != CS_TEAM_CT )
		{
			continue;
		}
		
		// Get a random num
		iRandomNum = random_num( 1, 2 );
		
		// Force the player to the team
		PLAYER_set_user_team( players[i], iRandomNum );
		
		// Add one to the counter
		iRandomNum == 1 ? iTCount++ : iCTCount++;
	}
	
	// Let us check if the teams are bad
	new difference = iTCount - iCTCount;
	
	// We have a difference?
	if ( difference > 1 )
	{
		// We have to force some players to the CT team
		while ( difference > 1 )
		{
			// Get a random player
			iRandomNum = random_num( 0, playersnum );
			
			// Player is connected 
			if ( !is_user_connected( players[iRandomNum] ) )
			{
				continue;
			}
		
			// Save the team
			iTeam = fm_get_user_team( players[iRandomNum] );
		
			// Player is on T-Team?
			if ( iTeam != CS_TEAM_T )
			{
				continue;
			}
			
			// We found a valid player, switch him
			PLAYER_set_user_team( players[iRandomNum], CS_TEAM_CT );
			
			// We found one, remove one from the difference
			difference--;
		}
	}
	
	// we have a difference?
	else if ( difference < -1 )
	{
		// We have to force some player to the T team
		while ( difference < -1 )
		{
			// Get a random player
			iRandomNum = random_num( 0, playersnum );
			
			// Player is connected 
			if ( !is_user_connected( players[iRandomNum] ) )
			{
				continue;
			}
		
			// Save the team
			iTeam = fm_get_user_team( players[iRandomNum] );
		
			// Player is on CT-Team?
			if ( iTeam != CS_TEAM_CT )
			{
				continue;
			}
			
			// We found a valid player, switch him
			PLAYER_set_user_team( players[iRandomNum], CS_TEAM_T );
			
			// We found one, add one from the difference
			difference++;
		}
	}
}
			
			
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
