/* Silent Hill constants and defines */

// Task offsets
enum (+= 100)
{
	TASK_FOG = 2000,
	TASK_DIMENSION,
	TASK_DIMINITIAL,
	TASK_DIMENSIONBACK,
	TASK_DISTANCECHECK,
	TASK_LIGHT,
	TASK_SILENCER,
	TASK_STRIPWEAPONS,
	TASK_SPEED,
	TASK_MODELSET,
	TASK_LIGHTCHRISTA,
	TASK_FLARE
}

// Fog density offsets
new const fog_density[] =
{
	0,
	0,
	0,
	0,
	111,
	18,
	3,
	58,
	111,
	18,
	125,
	58,
	66,
	96,
	27,
	59,
	90,
	101,
	60,
	59,
	90,
	101,
	68,
	59,
	10,
	41,
	95,
	59,
	111,
	18,
	125,
	59,
	111,
	18,
	3,
	60,
	68,
	116,
	19,
	60
}

// Fakemeta function (for snow etc.)
#define OFFSET_LASTKNI 370
#define OFFSET_TEAM 114
#define fm_create_entity(%1)	engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, %1))
#define fm_lastknife(%1) get_pdata_cbase(id, OFFSET_LASTKNI)
#define write_coord_f(%1) engfunc(EngFunc_WriteCoord,%1)
#define fm_get_user_team(%1) get_pdata_int(%1, OFFSET_TEAM)

// Random function for a random num
#define _random(%1) random_num(0, %1 - 1)

// Section Numbers for the ini file
#define SECTION_CHARACTERS 1
#define SECTION_DEFAULTCHAR 2
#define SECTION_WEATHER 3
#define SECTION_DIMENSION 4
#define SECTION_EQUIP 5
#define SECTION_EQUIPSEC 6
#define SECTION_EQUIPPRIM 7
#define SECTION_SOUNDS 8
#define SECTION_OBJECTS 9

// -------------------------------------- General --------------------------------------
// General define's
#define MOD_NAME "[SILENTHILL]"

// Maximum is all
#define MAX_PLAYERS 33
#define MAX_CHARS 8 		// max Characters in the ini
#define MAX_SOUNDS 8 // Maximum sounds

// Player data array defines (used for p_data var)
#define MAX_DATA 2
#define PLAYER_CHARACTER 0
#define MENUS_SIDE 1

// Player bool data array defines (user for p_data_b var)
#define MAX_DATA_B 5
#define PLAYER_USEDGUNS 0
#define PLAYER_SELECTEDCHAR 1
#define PLAYER_ISMONSTER 2
#define PLAYER_USEDCHAR 3
#define PLAYER_STATUS 4

#define MODELCHANGE_DELAY 0.5 // delay between model changes

// Character data array defines (used for character_data var)
#define MAX_CHAR_DATA 11
#define CHAR_HEALTH 0
#define CHAR_SPEED 1
#define CHAR_GRAVITY 2
#define CHAR_ATTACK 3
#define CHAR_DEFENCE 4
#define CHAR_HEDEFENCE 5
#define CHAR_HITSPEED 6
#define CHAR_HITDELAY 7
#define CHAR_REGENDLY 8
#define CHAR_HITREGENDLY 9
#define CHAR_KNOCKBACK 10

// Dimension data array defines (used for dimension_data var)
#define MAX_DIM_DATA 5
#define DIM_MODE 0
#define DIM_OCCURTIME 1
#define DIM_TIME 2
#define DIM_RADIUS 3
#define DIM_MAXTIME 4

// thanks twistedeuphoria - from objective proximity warning
#define MAX_OBJECTIVES 11
#define OBJENT_VIP_ESCAPE 0
#define OBJENT_HOSTAGE 1
#define OBJENT_BOMBSITE	2
#define OBJENT_HOSTAGE_ESCAPE 3

// -------------------------------------- Weapons ---------------------------------------
#define SILENCED_M4A1 0
#define SILENCED_USP 1
#define DMG_HEGRENADE (1<<24)

#define CANT_RELOAD_BITSUM  ( 1 << CSW_HEGRENADE | 1 << CSW_SMOKEGRENADE | 1<<CSW_FLASHBANG | 1 << CSW_KNIFE | 1 << CSW_C4 )
#define SHOTGUNS_BITSUM     ( 1 << CSW_XM1014 | 1 << CSW_M3 )
#define MAX_WEAPONS         30   // --| Max number of weapons. ( cs1.6/cz )
#define ATTRIB_BOMB 1
#define ATTRIB_VIP 4
    
#define	EQUIP_PRI	(1<<0)
#define	EQUIP_SEC	(1<<1)
#define	EQUIP_ARMOR	(1<<2)
#define	EQUIP_GREN	(1<<3)
#define EQUIP_ITEMS	(1<<4)
#define	EQUIP_ALL	(EQUIP_PRI|EQUIP_SEC|EQUIP_ARMOR|EQUIP_GREN|EQUIP_ITEMS)

#define MAX_SECONDARY 6
#define MAX_PRIMARY 18
#define MAX_WEAPONS_SIDE 7

#define	SLOT_PRIMARY	1
#define	SLOT_SECONDARY	2

// Secondary Weapon defines
#define WPN_USP 0
#define WPN_GLOCK 1
#define WPN_DEAGLE 2
#define WPN_P228 3
#define WPN_ELITE 4
#define WPN_FIVESEVEN 5

// Primary Weapon defines
#define WPN_M4A1 0
#define WPN_AK47 1
#define WPN_AUG 2
#define WPN_SG552 3
#define WPN_GALIL 4
#define WPN_FAMAS 5
#define WPN_SCOUT 6
#define WPN_AWP 7
#define WPN_SG550 8
#define WPN_M249 9
#define WPN_G3SG1 10
#define WPN_UMP45 11
#define WPN_MP5 12
#define WPN_M3 13
#define WPN_XM1014 14
#define WPN_TMP 15
#define WPN_MAC 16
#define WPN_P90 17

// Secondary Weapon names
new const g_seconnames[MAX_SECONDARY][] = {
	"USP",
	"Glock",
	"Deagle",
	"P228",
	"Elite",
	"FiveSeven"
}

// Primary Weapon names
new const g_primnames[MAX_PRIMARY][] = {
	"M4A1",
	"AK47",
	"AUG",
	"SG552",
	"Galil",
	"Famas",
	"Scout",
	"AWP",
	"SG550",
	"M249",
	"G3SG1",
	"UMP 45",
	"MP5 Navy",
	"M3",
	"XM1014",
	"TMP",
	"Mac10",
	"P90"
}

//Weapon slot lookup table (credits BAILOPAN)
stock g_WeaponSlots[] = {
	0,
	2,	//CSW_P228
	0,
	1,	//CSW_SCOUT
	4,	//CSW_HEGRENADE
	1,	//CSW_XM1014
	5,	//CSW_C4
	1,	//CSW_MAC10
	1,	//CSW_AUG
	4,	//CSW_SMOKEGRENADE
	2,	//CSW_ELITE
	2,	//CSW_FIVESEVEN
	1,	//CSW_UMP45
	1,	//CSW_SG550
	1,	//CSW_GALIL
	1,	//CSW_FAMAS
	2,	//CSW_USP
	2,	//CSW_GLOCK18
	1,	//CSW_AWP
	1,	//CSW_MP5NAVY
	1,	//CSW_M249
	1,	//CSW_M3
	1,	//CSW_M4A1
	1,	//CSW_TMP
	1,	//CSW_G3SG1
	4,	//CSW_FLASHBANG
	2,	//CSW_DEAGLE
	1,	//CSW_SG552
	1,	//CSW_AK47
	3,	//CSW_KNIFE
	1	//CSW_P90
}

#define MAX_AMMO 1
#define MAX_CLIP 0

//Maximum ammo
new const g_weapon_ammo[][] =
{
	{ -1, -1 },
	{ 13, 52 },
	{ -1, -1 },
	{ 10, 90 },
	{ -1, -1 },
	{ 7, 32 },
	{ -1, -1 },
	{ 30, 100 },
	{ 30, 90 },
	{ -1, -1 },
	{ 30, 120 },
	{ 20, 100 },
	{ 25, 100 },
	{ 30, 90 },
	{ 35, 90 },
	{ 25, 90 },
	{ 12, 100 },
	{ 20, 120 },
	{ 10, 30 },
	{ 30, 120 },
	{ 100, 200 },
	{ 8, 32 },
	{ 30, 90 },
	{ 30, 120 },
	{ 20, 90 },
	{ -1, -1 },
	{ 7, 35 },
	{ 30, 90 },
	{ 30, 90 },
	{ -1, -1 },
	{ 50, 100 }
}

// For knockback
enum
{
	KBPOWER_357SIG = 0,
	KBPOWER_762NATO,
	KBPOWER_BUCKSHOT,
	KBPOWER_45ACP,
	KBPOWER_556NATO,
	KBPOWER_9MM,
	KBPOWER_57MM,
	KBPOWER_338MAGNUM,
	KBPOWER_556NATOBOX,
	KBPOWER_50AE
}

// Which weapon has knockback
new const g_weapon_knockback[] =
{
	-1, 
	KBPOWER_357SIG, 
	-1, 
	KBPOWER_762NATO, 
	-1, 
	KBPOWER_BUCKSHOT, 
	-1, 
	KBPOWER_45ACP, 
	KBPOWER_556NATO, 
	-1, 
	KBPOWER_9MM, 
	KBPOWER_57MM,
	KBPOWER_45ACP, 
	KBPOWER_556NATO, 
	KBPOWER_556NATO, 
	KBPOWER_556NATO, 
	KBPOWER_45ACP,
	KBPOWER_9MM, 
	KBPOWER_338MAGNUM,
	KBPOWER_9MM, 
	KBPOWER_556NATOBOX,
	KBPOWER_BUCKSHOT, 
	KBPOWER_556NATO, 
	KBPOWER_9MM, 
	KBPOWER_762NATO, 
	-1, 
	KBPOWER_50AE, 
	KBPOWER_556NATO, 
	KBPOWER_762NATO, 
	-1, 
	KBPOWER_57MM
}

// Knockback power
new const Float:g_knockbackpower[] =
{
	3.0,  // KBPOWER_357SIG
	4.0,  // KBPOWER_762NATO
	9.5,  // KBPOWER_BUCKSHOT
	3.0,  // KBPOWER_45ACP
	4.5,  // KBPOWER_556NATO
	3.0,  // KBPOWER_9MM
	3.5,  // KBPOWER_57MM
	12.0, // KBPOWER_338MAGNUM
	4.0,  // KBPOWER_556NATOBOX
	3.8   // KBPOWER_50AE
}

// Team information
new const g_teaminfo[][] = 
{ 
	"UNASSIGNED", 
	"TERRORIST",
	"CT",
	"SPECTATOR" 
}

enum
{
	CS_TEAM_UNASSIGNED = 0,
	CS_TEAM_T,
	CS_TEAM_CT,
	CS_TEAM_SPECTATOR
}

const sg_start_reload = 5;    // --| Shotgun start reload sequence.
const m_iId           = 43;   // --| Weapon offset. ( return CSW_* )
const m_fInReload     = 54;   // --| Weapon offset.


#define OFFSET_CLIPAMMO	51
#define EXTRAOFFSET_WEAPONS 4

#define OFFSET_AMMO_338MAGNUM 377
#define OFFSET_AMMO_762NATO 378
#define OFFSET_AMMO_556NATOBOX 379
#define OFFSET_AMMO_556NATO 380
#define OFFSET_AMMO_BUCKSHOT 381
#define OFFSET_AMMO_45ACP 382
#define OFFSET_AMMO_57MM 383
#define OFFSET_AMMO_50AE 384
#define OFFSET_AMMO_357SIG 385
#define OFFSET_AMMO_9MM 386
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
