/* Silent Hill CVARs */

// Register all the CVARs and the console commands
public CVARS_LoadCVARS()
{
	// Is Silent Hill enabled?
	PCVAR_sh_enabled = register_cvar( "sh_enabled", "1" );
	
	// Use we characters?
	PCVAR_sh_characters = register_cvar( "sh_characters", "1" );
	
	// Should the weapon equip menu available?
	PCVAR_sh_equipmenu = register_cvar( "sh_equipmenu", "1" );
	
	// Christabella's healthpoints
	PCVAR_sh_christahp = register_cvar( "sh_christahp", "1500" );
	
	// Ammo setup
	PCVAR_sh_ammo = register_cvar( "sh_ammo", "2" );
	
	// Objectives are enabled?
	PCVAR_sh_objectives = register_cvar( "sh_objectives", "1" );
	
	// Random Teams enabled?
	PCVAR_sh_randomteams = register_cvar( "sh_randomteams", "1" );
	
	// Register some chat/console commands
	register_clcmd( "jointeam", "PLAYER_BlockSwitch" ); // Blocks the manual teamswitch
	register_clcmd( "chooseteam", "PLAYER_BlockSwitch" ); // Blocks the manual teamswitch
	register_clcmd( "guns", "MENU_EquipMain" ); // Open the Equip-Menu
	register_clcmd( "/guns", "MENU_EquipMain" ); // Open the Equip-Menu
	register_clcmd( "say guns", "MENU_EquipMain" ); // Open the Equip-Menu
	register_clcmd( "say /guns", "MENU_EquipMain" ); // Open the Equip-Menu
	register_clcmd( "say_team guns", "MENU_EquipMain" ); // Open the Equip-Menu
	register_clcmd( "say_team /guns", "MENU_EquipMain" ); // Open the Equip-Menu
	register_clcmd( "changechar", "MENU_SelectChar" ); // Open the Select-Char-Menu
	register_clcmd( "/changechar", "MENU_SelectChar" ); // Open the Select-Char-Menu
	register_clcmd( "say changechar", "MENU_SelectChar" ); // Open the Select-Char-Menu
	register_clcmd( "say /changechar", "MENU_SelectChar" ); // Open the Select-Char-Menu
	register_clcmd( "say_team changechar", "MENU_SelectChar" ); // Open the Select-Char-Menu
	register_clcmd( "say_team /changechar", "MENU_SelectChar" ); // Open the Select-Char-Menu
	register_clcmd( "shmenu", "MENU_MainHelp" ); // Open the SH Main menu
	register_clcmd( "/shmenu", "MENU_MainHelp" ); // Open the SH Main menu
	register_clcmd( "say shmenu", "MENU_MainHelp" ); // Open the SH Main menu
	register_clcmd( "say_team shmenu", "MENU_MainHelp" ); // Open the SH Main menu
	register_clcmd( "say /shmenu", "MENU_MainHelp" ); // Open the SH Main menu
	register_clcmd( "say_team /shmenu", "MENU_MainHelp" ); // Open the SH Main menu
	register_clcmd( "help", "MENU_MainHelp" ); // Open the help menu
	register_clcmd( "/help", "MENU_MainHelp" ); // Open the help menu
	register_clcmd( "say help", "MENU_MainHelp" ); // Open the help menu
	register_clcmd( "say_team help", "MENU_MainHelp" ); // Open the help menu
	register_clcmd( "say /help", "MENU_MainHelp" ); // Open the help menu
	register_clcmd( "say_team /help", "MENU_MainHelp" ); // Open the help menu
	
	// Set this for the hands. They would be lightened in the dark
	set_cvar_num( "sv_skycolor_r", 0 );
	set_cvar_num( "sv_skycolor_g", 0 );
	set_cvar_num( "sv_skycolor_b", 0 );
}

// Load the silenthill.cfg
public CVARS_SilentHill_CFG()
{
	static configpath[256];
	
	// Get the configs dir
	get_configsdir( configpath, charsmax( configpath ) );
	
	// Add the file path
	add( configpath, charsmax( configpath ), "/silenthill/silenthill_cvars.cfg" );
	
	// Execute the file if it exists
	if ( file_exists( configpath ) )
	{
		server_cmd( "exec %s", configpath );
	}
	
	// File doesn't exist
	else
	{
		log_amx( "[ERROR] Config file '%s' missing!", configpath );
		
		// Set plugin to unload
		set_fail_state( "Config file is missing, unable to load plugin" );
	}
}

// Copy the content from the pcvars to the vars
public CVARS_CopyPCVARS()
{
	// Is Silent Hill enabled? 
	sh_enabled = get_pcvar_num( PCVAR_sh_enabled );
	
	// Use we characters?
	sh_characters = get_pcvar_num( PCVAR_sh_characters );
	
	// Should the weapon equip menu available?
	sh_equipmenu = get_pcvar_num( PCVAR_sh_equipmenu );
	
	// Chrstabella's hp
	sh_christahp = get_pcvar_float( PCVAR_sh_christahp );
	
	// Ammo setup
	sh_ammo = get_pcvar_num( PCVAR_sh_ammo );
	
	// Objectives are enabled?
	sh_objectives = get_pcvar_num( PCVAR_sh_objectives );
	
	// Random Teams are enabled?
	sh_randomteams = get_pcvar_num( PCVAR_sh_randomteams );
	
	// Backup our global Christabella health var to default
	g_ChristaHP = sh_christahp;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
