/* Silent Hill InI file */

// Load the Characters and settings from the ini file
public INI_LoadData()
{
	// The the configs path
	static configsdir[256];
	get_configsdir( configsdir, charsmax( configsdir ) );
	
	// create one string with the path and the config file
	static configfile[256];
	formatex( configfile, charsmax( configfile ), "%s/%s", configsdir, "silenthill/silenthill.ini" );
	
	// is the file there?
	if ( !file_exists( configfile ) )
	{
		// Nope. Set the plugin failed.
		static sError[256];
		formatex( sError, charsmax( sError ), "Cannot load customization file %s", configfile );
		set_fail_state( sError );
		
		return;
	}
	
	// Set up some vars to hold parsing info
	new linedata[1024], key[64], value[960], section;
	
	// Open customization file for reading
	new file = fopen( configfile, "rt" );
		
	while ( file && !feof( file ) )
	{
		// Read one line at a time
		fgets( file, linedata, charsmax( linedata ) );
		
		// Replace newlines with a null character to prevent headaches
		replace( linedata, charsmax( linedata ), "^n", "" );
		
		// Blank line or comment
		if ( !linedata[0] || linedata[0] == ';' ) 
			continue;
		
		// New section starting
		if ( linedata[0] == '[' )
		{
			section++;
			continue;
		}
		
		// Get key and value(s)
		strtok( linedata, key, charsmax( key ), value, charsmax( value ), '=' );
		
		// Trim spaces
		trim( key );
		trim( value );
		
		switch ( section )
		{
			case SECTION_CHARACTERS: // Here we load all the characters
			{
				// we reached the chars max
				if ( g_charcounter > MAX_CHARS )
				{
					// So go out of this
					continue;
				}
				
				if ( equal( key, "NAME" ) )
				{
					// We found a name. This must be a new Character
					g_charcounter++;
					
					// Save the name from the character in the array
					formatex( character_name[g_charcounter], 31, "%s", value );
				}
				
				else if ( equal( key, "DESC" ) )
				{
					// Save the description from the char in the array
					formatex( character_desc[g_charcounter], 31, "%s", value );
				}
				
				else if ( equal( key, "PMODEL" ) )
				{
					// save the modelname and path in the array
					formatex( character_pmodel[g_charcounter], 127, "%s", value );
				}
				
				else if ( equali( key, "WMODEL" ) )
				{
					// Save the modelname and path in the array
					formatex( character_wmodel[g_charcounter], 127, "models/%s.mdl", value );
				}
				
				else if ( equali( key, "HEALTH" ) )
				{
					// Save the health in the array
					character_data[g_charcounter][CHAR_HEALTH] = str_to_float( value );
				}
				
				else if ( equali( key, "SPEED" ) )
				{
					// Save the speed in the array
					character_data[g_charcounter][CHAR_SPEED] = str_to_float( value );
				}
				
				else if ( equali( key, "GRAVITY" ) )
				{
					// Save the gravity in the array
					character_data[g_charcounter][CHAR_GRAVITY] = str_to_float( value );
				}
				
				else if ( equali( key, "ATTACK" ) )
				{
					// Save the damage multiplier in the array
					character_data[g_charcounter][CHAR_ATTACK] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFENCE" ) )
				{
					// Save the bullet multiplier in the array
					character_data[g_charcounter][CHAR_DEFENCE] = str_to_float( value );
				}
				
				else if ( equali( key, "HEDEFENCE" ) )
				{
					// Save the HE damage multiplier in the array
					character_data[g_charcounter][CHAR_HEDEFENCE] = str_to_float( value );
				}
				
				else if ( equali( key, "HITSPEED" ) )
				{
					// Save the Pain speed multiplier in the array
					character_data[g_charcounter][CHAR_HITSPEED] = str_to_float( value );
				}
				
				else if ( equali( key, "HITDELAY" ) )
				{
					// Save the Pain speed delay value in the array
					character_data[g_charcounter][CHAR_HITDELAY] = str_to_float( value );
				}
				
				else if ( equali( key, "REGENDLY" ) )
				{
					// Save the Regeneration delay value in the array
					character_data[g_charcounter][CHAR_REGENDLY] = str_to_float( value );
				}
				
				else if ( equali( key, "HITREGENDLY" ) )
				{
					// Save the Pain regeneration delay value in the array
					character_data[g_charcounter][CHAR_HITREGENDLY] = str_to_float( value );
				}
				
				else if ( equali( key, "KNOCKBACK" ) )
				{
					// Save the Knockback multiplier in the array
					character_data[g_charcounter][CHAR_KNOCKBACK] = str_to_float( value );
				}
			}
			
			case SECTION_DEFAULTCHAR: // Here we get the settings for the default character
			{
				if ( equali( key, "DEFAULT_HEALTH" ) )
				{
					// Save the default health in the array
					character_defaultdata[CHAR_HEALTH] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_SPEED" ) )
				{
					// Save the speed in the array
					character_defaultdata[CHAR_SPEED] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_GRAVITY" ) )
				{
					// Save the gravity in the array
					character_defaultdata[CHAR_GRAVITY] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_ATTACK" ) )
				{
					// Save the damage multiplier in the array
					character_defaultdata[CHAR_ATTACK] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_DEFENCE" ) )
				{
					// Save the bullet multiplier in the array
					character_defaultdata[CHAR_DEFENCE] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_HEDEFENCE" ) )
				{
					// Save the HE damage multiplier in the array
					character_defaultdata[CHAR_HEDEFENCE] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_HITSPEED" ) )
				{
					// Save the Pain speed multiplier in the array
					character_defaultdata[CHAR_HITSPEED] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_HITDELAY" ) )
				{
					// Save the Pain speed delay value in the array
					character_defaultdata[CHAR_HITDELAY] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_REGENDLY" ) )
				{
					// Save the Regeneration delay value in the array
					character_defaultdata[CHAR_REGENDLY] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_HITREGENDLY" ) )
				{
					// Save the Pain regeneration delay value in the array
					character_defaultdata[CHAR_HITREGENDLY] = str_to_float( value );
				}
				
				else if ( equali( key, "DEFAULT_KNOCKBACK" ) )
				{
					// Save the Knockback multiplier in the array
					character_defaultdata[CHAR_KNOCKBACK] = str_to_float( value );
				}
			}
			
			case SECTION_WEATHER: // Here we get the settings for the weather
			{
				if ( equali( key, "FOG_R" ) )
				{
					// Save the fog red color in the array
					fog_color[0] = str_to_num( value );
				}
				
				else if ( equali( key, "FOG_G" ) )
				{
					// Save the fog red color in the array
					fog_color[1] = str_to_num( value );
				}
				
				else if ( equali( key, "FOG_B" ) )
				{
					// Save the fog red color in the array
					fog_color[2] = str_to_num( value );
				}
				
				else if ( equali( key, "FOG_DENSITY" ) )
				{
					// Save the density level in a var
					g_fogdensity_level = str_to_num( value );
				}
				
				else if ( equali( key, "LIGHT" ) )
				{
					copy( light_chars, charsmax( light_chars ), value );
				}
			}
			
			case SECTION_DIMENSION:
			{
				if ( equali( key, "DIMENSION_MODE" ) )
				{
					// Save the dimensionmode option
					dimension_data[DIM_MODE] = str_to_num( value );
				}
				
				else if ( equali( key, "DIMENSION_OCCUR_TIME" ) )
				{
					// Save the occur time 
					dimension_data[DIM_OCCURTIME] = str_to_num( value );
				}
				
				else if ( equali( key, "DIMENSION_TIME" ) )
				{
					// Save the specific time
					dimension_data[DIM_TIME] = str_to_num( value );
				}
				
				else if ( equali( key, "DIMENSION_LIGHT_TIME" ) )
				{
					g_fLight = str_to_float( value );
				}
				
				else if ( equali( key, "DIMENSION_RADIUS" ) )
				{
					// Save the dimension radius
					dimension_data[DIM_RADIUS] = str_to_num( value );
				}
				
				else if ( equali( key, "DIMENSION_MAXTIME" ) )
				{
					// Save the max time for the random effect
					dimension_data[DIM_MAXTIME] = str_to_num( value );
				}
			}
			
			case SECTION_EQUIP: // Settings for the equipment menu
			{
				// Which menu should be shown
				if ( equali( key, "MENUS" ) )
				{
					// Show up the primary menu
					if ( containi( value, "p" ) != -1 )
					{
						g_mPrimStatus = true;
					}
			
					// Show up the Secondary menu
					if ( containi( value, "s" ) != -1 )
					{
						g_mSecStatus = true;
					}
			
					// Show up the Armor menu
					if ( containi( value, "a" ) != -1 ) 
					{
						g_mArmorStatus = true;
					}
			
					// Show up the Grenades menu
					if ( containi( value, "g" ) != -1 )
					{
						g_mNadeStatus = true;
					}
				}
				
				// Autoitems
				else if ( equali( key, "AUTOITEMS" ) )
				{
					// Give auto armor
					if ( containi( value, "a" )  != -1 )
					{
						//Disable Armor Menu
						g_mArmorStatus = false;
						g_mAutoArmor = true;
				
						g_Armor = 1;
					}
						
					// Give auto helm
					if ( containi( value, "h" ) != -1 )
					{
						//Disable Armor Menu
						g_mArmorStatus = false;
						g_mAutoArmor = true;
						g_Armor = 2;
					}
			
					// Give auto grenades
					if ( containi( value, "g" ) != -1 )
					{
						//Disable Grenade Menu
						g_mNadeStatus = false;
						g_mAutoNades = true;
					}
			
					// Give auto a defuse kit
					if ( containi( value, "d" ) != -1 )
					{
						g_DefuseKit = true;
					}
			
					// Give auto a nightvision
					if ( containi( value, "n" ) != -1 )
					{
						g_NightVision = true;
					}
				}
				
				// Grenade settings
				else if ( equali( key, "GRENADES" ) )
				{
					// Flashbang
					if ( containi( value, "f" ) != -1 )
					{
						g_Flash = true;
					}
			
					// HE Grenades
					if ( containi( value, "h" ) != -1 )
					{
						g_Nade = true;
					}
			
					// Smokenades
					if ( containi( value, "s" ) != -1 )
					{
						g_Smoke = true;
					}
				}
				
				// Flashbang number
				else if ( equali( key, "FNADESNUM" ) )
				{
					fnadesnum = str_to_num( value );
				}
			}
			
			case SECTION_EQUIPSEC: // Weapons in the secondary equipment menu
			{
				if ( equali( key, "USP" ) )
				{
					// USP is disabled
					g_DisabledSec[WPN_USP] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "GLOCK" ) )
				{
					// Glock is disabled
					g_DisabledSec[WPN_GLOCK] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "DEAGLE" ) )
				{
					// Deagle is disabled
					g_DisabledSec[WPN_DEAGLE] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "P228" ) )
				{
					// P228 is disabled
					g_DisabledSec[WPN_P228] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "ELITE" ) )
				{
					// Elite is disabled
					g_DisabledSec[WPN_ELITE] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "FIVESEVEN" ) )
				{
					// Five Seven is disabled
					g_DisabledSec[WPN_FIVESEVEN] = str_to_num( value ) == 1 ? false : true;
				}
			}
			
			case SECTION_EQUIPPRIM: // Weapons in the primary equipment menu
			{
				if ( equali( key, "M4A1" ) )
				{
					// M4A1 is disabled
					g_DisabledPrim[WPN_M4A1] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "AK47" ) )
				{
					// AK47 is disabled
					g_DisabledPrim[WPN_AK47] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "AUG" ) )
				{
					// AUG is disabled
					g_DisabledPrim[WPN_AUG] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "SG552" ) )
				{
					// SG552 is disabled
					g_DisabledPrim[WPN_SG552] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "GALIL" ) )
				{
					// Galil is disabled
					g_DisabledPrim[WPN_GALIL] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "FAMAS" ) )
				{
					// Famas is disabled
					g_DisabledPrim[WPN_FAMAS] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "SCOUT" ) )
				{
					// Scout is disabled
					g_DisabledPrim[WPN_SCOUT] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "AWP" ) )
				{
					// AWP is disabled
					g_DisabledPrim[WPN_AWP] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "SG550" ) )
				{
					// SG550 is disabled
					g_DisabledPrim[WPN_SG550] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "M249" ) )
				{
					// M249 is disabled
					g_DisabledPrim[WPN_M249] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "G3SG1" ) )
				{
					// G3SG1 is disabled
					g_DisabledPrim[WPN_G3SG1] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "UMP45" ) )
				{
					// UMP 45 is disabled
					g_DisabledPrim[WPN_UMP45] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "MP5" ) )
				{
					// MP5 is disabled
					g_DisabledPrim[WPN_MP5] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "M3" ) )
				{
					// M3 is disabled
					g_DisabledPrim[WPN_M3] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "XM1014" ) )
				{
					// XM1014 is disabled
					g_DisabledPrim[WPN_XM1014] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "TMP" ) )
				{
					// TMP is disabled
					g_DisabledPrim[WPN_TMP] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "MAC" ) )
				{
					// MAC is disabled
					g_DisabledPrim[WPN_MAC] = str_to_num( value ) == 1 ? false : true;
				}
				
				else if ( equali( key, "P90" ) )
				{
					// P90 is disabled
					g_DisabledPrim[WPN_P90] = str_to_num( value ) == 1 ? false : true;
				}
			}
			
			case SECTION_SOUNDS: // Here we load the CT / T Wind sounds
			{
				if ( equali( key, "CTWINSOUND" ) )
				{
					// Add the CT winsound 
					formatex( ct_winsounds[g_iCTWinS], 127, "%s", value );
					
					// Add one for the counter
					g_iCTWinS++;
				}
				
				else if ( equali( key, "TWINSOUND" ) )
				{
					// Add the T winsound
					formatex( t_winsounds[g_iTWinS], 127, "%s", value );
					
					// Add one for the counter
					g_iTWinS++;
				}
				
				else if ( equali( key, "DIMENSIONSOUND" ) )
				{
					// Add the Dimension start sound
					formatex( dimension_startsound[g_iDimStartSound], 127, "%s", value );
					
					// Add one for the counter
					g_iDimStartSound++;
				}
				
				else if ( equali( key, "FIRSTAMBSOUND" ) )
				{
					// Add the first dimension sound to the array
					formatex( ambience_first_sound[g_iFirstAmbienceS], 127, "%s", value );
					
					// Add one for the counter
					g_iFirstAmbienceS++;
				}
				
				else if ( equali( key, "SECONDAMBSOUND" ) )
				{
					// Add the first dimension sound to the array
					formatex( ambience_secon_sound[g_iSeconAmbienceS], 127, "%s", value );
					
					// Add one for the counter
					g_iSeconAmbienceS++;
				}
			}
			
			case SECTION_OBJECTS: // Here we load the game objects configs
			{
				if ( equali( key, "CHRISTAMODEL" ) )
				{
					// Save the path from the christamodel
					formatex( christabella_pmodel, charsmax( christabella_pmodel ), "%s", value );
				}
				
				else if ( equali( key, "VIPSPEED" ) )
				{
					// Save the speed for the vip on as_ maps
					g_vip_speed = str_to_float( value );
				}
			}
		}
	}
}

// Register the Characters
public INI_RegisterChars()
{
	// Let us check if we anyway use characters
	if ( sh_characters <= 0 )
	{
		// Loop through the complete data and copy the array
		for ( new i = 0; i < MAX_CHAR_DATA; ++i )
		{
			// Copy the data
			character_data[g_charcounter][i] = character_defaultdata[i];
		}
		
		// Yes, we have on character
		g_charcounter++;
	}
	
	// Let us register the characters
	for ( new i = 0; i < g_charcounter; ++i )
	{
		// Loop through every ability
		for ( new x = 0; x < MAX_CHAR_DATA; ++x )
		{
			// There was something not set
			if ( character_data[i][x] <= 0.0 )
			{
				// Copy the default data in that array
				character_data[i][x] = character_defaultdata[x];
			}
		}
	}
	
	// We add the light time to the task times
	dimension_data[DIM_TIME] += floatround( float( strlen( light_chars ) ) * g_fLight );
}
					
					
				
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
