/* Silent Hill Gameobjectives */

// Create Christabella
public OBJ_CreateCristabella()
{
	// here we save the id
	new iVecID = 0;
	
	// Let us create the entity
	new ent = create_entity( "hostage_entity" );
		
	// We're on a de_ map?
	if ( g_PlayDEMap )
	{
		// Get a random num for random bombspot
		new iRandomNum = random_num( 1, g_bspotcounter );

		// Loop through all objectives
		for ( new i = 0; i < g_iTotalObjectiveEnts; ++i )
		{
			// the objective is a bombspot
			if ( g_iObjectiveEntType[i] == OBJENT_BOMBSITE )
			{
				// Add one to the counter
				iVecID++;
			
				// We're at the random bombspot?
				if ( iVecID == iRandomNum )
				{
					// Save in iSpotCounter the ID 
					iVecID = i;
				
					// go out of the loop
					break;
				}
			}
		}
		
		// Save the position from christabella
		g_ChristaPos[0] = g_fObjectiveOrigin[iVecID][0];
		g_ChristaPos[1] = g_fObjectiveOrigin[iVecID][1];
		g_ChristaPos[2] = g_fObjectiveOrigin[iVecID][2];
	}
	
	// We're on a cs_ map?
	else if ( g_PlayCSMap )
	{
		// Loop through all objectives
		for ( new i = 0; i < g_iTotalObjectiveEnts; ++i )
		{
			// the objective is a hostage
			if ( g_iObjectiveEntType[i] == OBJENT_HOSTAGE )
			{
				// Save the Id
				iVecID = i;
			}
		}
		
		// We saved already the position?
		if ( g_ChristaPos[0] == 0.0 && g_ChristaPos[1] == 0.0 && g_ChristaPos[2] == 0.0 )
		{
			// Save the position from christabella
			g_ChristaPos[0] = g_fObjectiveOrigin[iVecID][0];
			g_ChristaPos[1] = g_fObjectiveOrigin[iVecID][1];
			g_ChristaPos[2] = g_fObjectiveOrigin[iVecID][2];
		}
	}
		
	// Set christabella to the bombspot
	entity_set_origin( ent, g_ChristaPos );
		
	// Set up the flare on christabella
	set_task( 0.1, "OBJ_flare_lighting", TASK_LIGHTCHRISTA );
	
	// Set that she can take damage and the hp
	entity_set_float( ent, EV_FL_takedamage, 1.0 );
	entity_set_float( ent, EV_FL_health, g_ChristaHP );
	
	// Create the hostage model path
	static hModel[256];
	formatex( hModel, charsmax( hModel ), "models/%s.mdl", christabella_pmodel );
	
	// Set the classname, the model and as solid
	entity_set_string( ent, EV_SZ_classname, "hostage_entity" );
	entity_set_model( ent, hModel );
	entity_set_int( ent, EV_INT_solid, 2 );
	
	// Set up the controller
	entity_set_byte( ent, EV_BYTE_controller1, 125 );
	entity_set_byte( ent, EV_BYTE_controller2, 125 );
	entity_set_byte( ent, EV_BYTE_controller3, 125 );
	entity_set_byte( ent, EV_BYTE_controller4, 125 );

	// Set the size
	new Float:maxs[3] = { 16.0, 16.0, 36.0 };
	new Float:mins[3] = { -16.0, -16.0, -0.0 };
	entity_set_size( ent,mins,maxs );
	
	// Set animation etc.
	entity_set_float( ent, EV_FL_animtime, 2.0 );
	entity_set_int( ent, EV_INT_sequence, 5 );
	
	// Drop it to the floor
	drop_to_floor( ent );
	
	// We're on a CT map, the hostage should follow
	if ( g_PlayCSMap )
	{
		DispatchSpawn( ent );
	}
	
	return 1;
}

// Set objects on dimension switch
public OBJ_DimensionSwitch()
{
	// Objectives are enabled?
	if ( sh_objectives <= 0 )
	{
		return;
	}
	
	// We're on a de_ map
	if ( g_PlayDEMap || g_PlayCSMap )
	{	
		// We're in the first dimension, remove christabella
		if ( !g_dimension )
		{
			// Get the id from christabella
			new id = find_ent_by_class( -1, "hostage_entity" );
			
			// Valid?
			if ( pev_valid( id ) )
			{
				// Save the position from christabella
				pev( id, pev_origin, g_ChristaPos );
				
				// Remove Christabella
				remove_entity_name( "hostage_entity" );
			}
			
			// Remove Christabella's flare effect
			remove_task( TASK_LIGHTCHRISTA );
		}
		
		// We're in the second, create christabella
		else
		{
			OBJ_CreateCristabella();
		}
	}
	
	// We're on a AS_ map
	else if ( g_PlayASMap )
	{
		// We're in the first dimension
		if ( !g_dimension )
		{
			// We found a VIP?
			if ( g_VIPPlayerID > -1 )
			{
				// Set the decreased speed
				set_pev( g_VIPPlayerID, pev_maxspeed, g_vip_speed ); 
			}
		}
		
		// We're in the second dimension
		else 
		{
			// We have a VIP?
			if ( g_VIPPlayerID > -1 )
			{
				// Set the decreased speed
				set_pev( g_VIPPlayerID, pev_maxspeed, 0.0 );
			}
		}
	}
}

// Find map objectives
public OBJ_FindObjectives()
{
	// We need to determine the objective entities (if they exist)
	new i, bool:bFound;
	for ( i = 0; i <= get_global_int( GL_maxEntities ); i++ )
	{
		if ( !is_valid_ent( i ) )
		{
			continue;
		}
		
		// More than were necessary was found
		if ( g_iTotalObjectiveEnts >= MAX_OBJECTIVES )
		{
			break;
		}

		bFound = false;

		new szClassName[64];
		entity_get_string( i, EV_SZ_classname, szClassName, 63 );
		
		// VIP Escape zone!!
		if ( equal( szClassName, "func_vip_safetyzone") )	
		{
			g_iObjectiveEntType[g_iTotalObjectiveEnts] = OBJENT_VIP_ESCAPE;
			bFound = true;
		}

		// Bomb zone
		else if ( equal( szClassName, "func_bomb_target") )
		{
			g_iObjectiveEntType[g_iTotalObjectiveEnts] = OBJENT_BOMBSITE;
			bFound = true;
			
			// Add one to the global counter
			g_bspotcounter++;
		}

		// Hostage escape zone
		else if ( equal( szClassName, "func_escapezone") )
		{
			g_iObjectiveEntType[g_iTotalObjectiveEnts] = OBJENT_HOSTAGE_ESCAPE;
			bFound = true;
		}

		// We found an objective entity!!!
		if ( bFound )
		{
			// Save the origin
			get_brush_entity_origin( i, g_fObjectiveOrigin[g_iTotalObjectiveEnts] );

			// Increment the total number
			g_iTotalObjectiveEnts++;
		}
	}
	
	return;
}

// Detect the map type
public OBJ_DetectMapType()
{
	// Get the mapname
	static sMapName[32];
	get_mapname( sMapName, charsmax( sMapName ) );
	
	// We play on a de_ map?
	if ( containi( sMapName, "de_" ) != -1 )
	{
		// Yes, we're on a de_ map
		g_PlayDEMap = true;
	}
	
	// We play on a cs_ map?
	else if ( containi( sMapName, "cs_" ) != -1 )
	{
		// Yes, we're on a cs_ map
		g_PlayCSMap = true;
	}
	
	// We play on a as_ map?
	else if ( containi( sMapName, "as_" ) != -1 )
	{
		// Yes, we're on a as_ map
		g_PlayASMap = true;
	}
}

// Creates a flare by Christabella
public OBJ_flare_lighting()
{
	static Float:originF[3];
	originF[0] = g_ChristaPos[0];
	originF[1] = g_ChristaPos[1];
	originF[2] = g_ChristaPos[2] + 50;
	
	// Lighting
	engfunc(EngFunc_MessageBegin, MSG_PAS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_DLIGHT) // TE id
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	write_byte(25) // radius
	write_byte(255) // r
	write_byte(0) // g
	write_byte(0) // b
	write_byte(51) //life
	write_byte(1) //decay rate
	message_end()
	
	// Set the task again
	set_task( 1.0, "OBJ_flare_lighting", TASK_LIGHTCHRISTA );
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
