/* Silent Hill Weather */

// Determine and set up dimension task
public WEATHER_DimensionTask()
{
	// let us remove some several tasks
	remove_task( TASK_DIMENSIONBACK );
	remove_task( TASK_DIMENSION );
	remove_task( TASK_DIMINITIAL );
	
	// We're in the second dimension, let us start the task for the way back
	if ( g_dimension )
	{
		set_task( float( dimension_data[DIM_OCCURTIME] ), "WEATHER_NextDimension", TASK_DIMENSIONBACK );
		
		// We have all. go out
		return;
	}
	
	// Let us check how we start the second dimension
	switch ( dimension_data[DIM_MODE] )
	{
		case 0: // The dimension will procc after a specific time
		{
			static iDimensionTime;
			
			// Add the specific time from the ini config
			iDimensionTime = dimension_data[DIM_TIME];
			
			// Set up the switch dimension task
			set_task( float( iDimensionTime ), "WEATHER_NextDimension", TASK_DIMENSION );
		}
		
		case 1: // The dimension will procc after a random time
		{
			static iDimensionTime;
			
			// Get a random number
			iDimensionTime = random_num( dimension_data[DIM_TIME], dimension_data[DIM_MAXTIME] );
			
			// Set up the switch dimension task
			set_task( float( iDimensionTime ), "WEATHER_NextDimension", TASK_DIMENSION );
		}
		
		case 2: // The dimension will procc after a player joined the bomb/hostage/vip radius
		{
			// We did this in the round already, so take the default time
			if ( g_bDimensionStart )
			{
				static iDimensionTime;
			
				// Add the specific time from the ini config
				iDimensionTime = random_num( dimension_data[DIM_TIME], dimension_data[DIM_MAXTIME] );
			
				// Set up the switch dimension task
				set_task( float( iDimensionTime ), "WEATHER_NextDimension", TASK_DIMENSION );
			}
			
			// Set up the task which check every 0.1 seconds if one person near the objective
			else
			{
				// Save it global
				g_bDimensionStart = true;
				
				// Start the distance check
				WEATHER_CheckDistance();
			}
		}
		
		case 3: // The dimension will procc after the freezetime is over
		{	
			// We did this in the round already, so take the default time
			if ( g_bDimensionStart )
			{
				static iDimensionTime;
			
				// Add the specific time from the ini config
				iDimensionTime = random_num( dimension_data[DIM_TIME], dimension_data[DIM_MAXTIME] );
			
				// Set up the switch dimension task
				set_task( float( iDimensionTime ), "WEATHER_NextDimension", TASK_DIMENSION );
			}
			
			// Start the next dimension instantly
			else
			{
				// Save it global
				g_bDimensionStart = true;
				
				// Start the next dimension
				WEATHER_NextDimension();
			}
		}
	}
	
	return;
}

// Set all back to the first dimension
public WEATHER_SetDefault()
{
	// Set the light back to brightest letter
	static chars[2];
	formatex( chars, charsmax( chars ), "%c", light_chars[(strlen( light_chars )-1)] );
	engfunc( EngFunc_LightStyle, 0, chars );
	
	// Yes, we're in the first dimension
	g_dimension = false;
	
	// Set the fog
	WEATHER_SetFog();
	
	// Game objects
	OBJ_DimensionSwitch();
}

// Check every 0.1 seconds the distance between the players and the game objective
public WEATHER_CheckDistance()
{
	// Get all players
	static players[32], playersnum;
	get_players( players, playersnum );
	
	// Here we save every origin from the player
	new Float:originF[3];
	
	// Loop through all players
	for ( new i = 0; i < playersnum; ++i )
	{
		// player isn't alive
		if ( !is_user_alive( players[i] ) )
		{
			continue;
		}
		
		// get from the user the origin
		pev( players[i], pev_origin, originF );
		
		// Loop through all objectives
		for ( new x = 0; x < g_iTotalObjectiveEnts; ++x )
		{
			// the objective is a hostage, we should only check for CT's
			if ( g_iObjectiveEntType[x] == OBJENT_HOSTAGE )
			{
				if ( fm_get_user_team( players[i] ) == CS_TEAM_T )
				{
					// take the next
					continue;
				}
			}
			
			// the objective is a bombspot, we should only check for T's
			else if ( g_iObjectiveEntType[x] == OBJENT_BOMBSITE )
			{
				if ( fm_get_user_team( players[i] ) == CS_TEAM_CT )
				{
					// take the next
					continue;
				}
			}
			
			// the objective is a vip rescuezone, only CT check
			else if ( g_iObjectiveEntType[x] == OBJENT_VIP_ESCAPE )
			{
				if ( fm_get_user_team( players[i] ) == CS_TEAM_T )
				{
					// Take the next
					continue;
				}
			}
				
			// The player is a T
			// is the player in the radius?
			if ( get_distance_f( originF, g_fObjectiveOrigin[x] ) <= float( dimension_data[DIM_RADIUS] ) )
			{	
				// Okay, start the next dimension 
				WEATHER_NextDimension();
				
				// go out of the function
				return;
			}
		}
	}
	
	// if we're here, no player is in range, so start this function in 0.1 seconds again
	set_task( 0.1, "WEATHER_CheckDistance", TASK_DISTANCECHECK );
	
	return;
}

// Set the abilites
public PLAYER_PrepareDimension()
{
	// Get all players
	static players[32], playersnum;
	get_players( players, playersnum );
	
	// Loop through all players
	for ( new i = 0; i < playersnum; ++i )
	{
		// player alive?
		if ( is_user_alive( players[i] ) )
		{
			// This should only occur for humans
			if ( !p_data_b[players[i]][PLAYER_ISMONSTER] )
			{
				// We're in the first dimension
				if ( g_dimension )
				{
					// And add a flare effect to the player
					PLAYER_AttachFlare( players[i] + TASK_FLARE );
				}
				
				// We have to remove the flare effect
				else
				{
					// remove the entitys
					remove_task( players[i] + TASK_FLARE );
				}
			}
			
			// This only for monsters
			else
			{
				// Set nightvision on
				engclient_cmd( players[i], "nightvision" );
			}
			
			// We're in the first dimension
			if ( !g_dimension )
			{
				// Set the position from the hudmessage
				set_hudmessage( 178, 14, 41, -1.0, -0.4, 1, 0.5, 1.7, 0.2, 0.2, -1 );
				// Show the dimension switch message
				show_hudmessage( players[i], "%L", players[i], "HUD_BACK_HELL" );
			}
			
			// We're in the second dimension
			else
			{
				// Set the position from the hudmessage
				set_hudmessage( 178, 14, 41, -1.0, -0.4, 1, 0.5, 1.7, 0.2, 0.2, -1 );
				// Show the dimension switch message
				show_hudmessage( players[i], "%L", players[i], "HUD_INTO_HELL" );
			}
			
			// Let all players screen shake
			WEATHER_Create_ScreenShake( players[i], (255<< 14), (10 << 14), (255<< 14) );
		}
	}
}
					
// Set the fog to a player
public WEATHER_SetFog()
{
	// Set only the fog if we're on the right dimension
	if ( !g_dimension )
	{
		// Calculate with the density level the right offsets
		static iLeveltoID;
		iLeveltoID = ( 4 * g_fogdensity_level ); // 4 because we have 4 offsets to set
		MESSAGE_FOGONOFF( fog_color[0], fog_color[1], fog_color[2], fog_density[iLeveltoID], fog_density[iLeveltoID+1], fog_density[iLeveltoID+2], fog_density[iLeveltoID+3] );
	}
	
	return;
}

// We exit the old dimension and go to the next
public WEATHER_NextDimension()
{
	if ( !g_dimension )
	{
		// Play the Dimension-Start sound
		PlaySound( dimension_startsound[_random( g_iDimStartSound )] );
		
		// Set up the global var
		g_StartedDimSound = true;
		
		// Start with the light
		new parm[2];
		parm[0] = strlen( light_chars )-1; // we send the id from the array
		parm[1] = 1;			   // 1 = from bright to dark, 0 = from dark to bright
		set_task( g_fLight, "WEATHER_Light", TASK_LIGHT, parm, 2 );
	}
	
	// We go back to the old dimension
	else 
	{
		// All should able to know that
		g_dimension = false;
		
		// Start up the multiforward
		ExecuteForward( g_fwd_dimension, g_fwd_result );
		
		// We set it back
		g_StartedDimSound = false;
		
		// Set the light back
		new parm[2];
		parm[0] = 0; 			// we send the id from the array
		parm[1] = 0;			// 1 = from bright to dark, 0 = from dark to bright
		set_task( g_fLight, "WEATHER_Light", TASK_LIGHT, parm, 2 );
		
		// Set up the fog again
		set_task( g_fLight, "WEATHER_SetFog" );
		
		// Set player abilitys
		PLAYER_PrepareDimension();
		
		// game objects
		OBJ_DimensionSwitch();
		
		// Start the ambience sound
		PLAYER_StartAmbience();
		
		// Go again in the initial function
		WEATHER_DimensionTask();
	}
}

// This function change automaticle the light from bright to dark or the other way around
public WEATHER_Light( parm[2] )
{
	// First we set the light with the parm array
	static chars[2];
	formatex( chars, charsmax( chars ), "%c", light_chars[parm[0]] );
	engfunc( EngFunc_LightStyle, 0, chars );
	
	// Let us define the next char
	if ( parm[1] == 1 )
	{
		parm[0]--; // from z to a - so go back
		
		// We're over the end?
		if ( parm[0] < 0 )
		{
			// All should able to know that
			g_dimension = true;
			
			// Execute the multiforward
			ExecuteForward( g_fwd_dimension, g_fwd_result );
			
			// That was our last light change, remove now the fog
			MESSAGE_FOGONOFF( 0, 0, 0, 0, 0, 0, 0 );
			
			// And set up now the player abilitys
			PLAYER_PrepareDimension();
			
			// Game Objects
			OBJ_DimensionSwitch();
			
			// Go again in the initial function
			WEATHER_DimensionTask();
			
			// Start the ambience sound
			PLAYER_StartAmbience();
			
			// and go out
			return;
		}
	}
	
	// We go from dark to bright
	else if ( parm[1] == 0 )
	{
		parm[0]++; // from a to z - so go forwards
		
		// We're over the end?
		if ( parm[0] >= strlen( light_chars ) )
		{
			// We've done our job. Go out
			return;
		}
	}
	
	// If we're here, we have to set the task again
	set_task( g_fLight, "WEATHER_Light", TASK_LIGHT, parm, 2 );
	
	return;
}
	
// Creates the fog for every player
public MESSAGE_FOGONOFF( Red, Green, Blue, SD, ED, D1, D2 )
{
	message_begin(MSG_ALL,get_user_msgid("Fog"),{0,0,0},0)
	write_byte(Red)  // R
	write_byte(Green)  // G
	write_byte(Blue)  // B
	write_byte(SD) // SD
	write_byte(ED)  // ED
	write_byte(D1)   // D1
	write_byte(D2)  // D2
	message_end()
}

// Create a screenshake for a player
stock WEATHER_Create_ScreenShake(id, amount, duration, frequency){

	message_begin(MSG_ONE,g_msgScreenShake,{0,0,0},id) 
	write_short( amount )				// ammount 
	write_short( duration )				// lasts this long 
	write_short( frequency )			// frequency
	message_end()
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
