#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <hamsandwich>
#include <silenthill>

#define PLUGIN "Silent Hill: Revive"
#define VERSION "1.0"
#define AUTHOR "DA"
#define MOD_NAME "[SILENTHILL]"

new PCVAR_sh_enabled, PCVAR_sh_gamemode, PCVAR_sh_revtime, bool:g_bDoRevive[33], PCVAR_sh_rev_distance;
new Float:g_fStartToRevive[33], g_iWhoRevive[33], g_iBarTimeMsg, Float:g_PlayerOrigin[33][3], g_PlayerEnt[33];
new PCVAR_sh_maxrevive, g_iReviveCounter[33], bool:g_bEndRound;

#define SPRITE_FLARE "sprites/flare6.spr"
#define SPAWN_SOUND "silenthill/reincarnation.wav"

public plugin_precache()
{
	// Precache the sprite and the sound
	precache_model( SPRITE_FLARE );
	precache_sound( SPAWN_SOUND );
	
	// Set the language file
	register_dictionary( "silenthill.txt" );
}

public plugin_init() {
	register_plugin( PLUGIN, VERSION, AUTHOR );
	
	// PCVAR's
	PCVAR_sh_gamemode = register_cvar( "sh_gamemode", "1" );
	PCVAR_sh_revtime = register_cvar( "sh_revtime", "8" );
	PCVAR_sh_enabled = get_cvar_pointer( "sh_enabled" );
	PCVAR_sh_rev_distance = register_cvar( "sh_rev_distance", "100" );
	PCVAR_sh_maxrevive = register_cvar( "sh_maxrevive", "5" );
	
	// Hamsandwich
	RegisterHam( Ham_Killed, "player", "EVENTS_PlayerKilled_Post", 1 );
	
	// Messages
	register_message( get_user_msgid( "ClCorpse" ), "EVENTS_ClCorpse" );
	register_logevent( "EVENTS_RoundEnd", 2, "1=Round_End", "1=Round_Draw" );
	register_event( "HLTV", "EVENTS_NewRound", "a", "1=0", "2=0" );
	g_iBarTimeMsg = get_user_msgid( "BarTime" );
	
	// Forwards
	register_forward( FM_CmdStart, "EVENTS_CmdStart" );
}

// A player was killed - Post
public EVENTS_PlayerKilled_Post( victim, attacker )
{
	// Silent Hill enabled?
	if ( !get_pcvar_num( PCVAR_sh_enabled ) )
	{
		return HAM_IGNORED;
	}
	
	// Gamemode 1 enabled 
	if ( get_pcvar_num( PCVAR_sh_gamemode ) != 1 )
	{
		return HAM_IGNORED;
	}
	
	// Get the origin from the victim
	pev( victim, pev_origin, g_PlayerOrigin[victim] );
	
	// Start the flare effect
	PLAYER_Flare( victim );
	
	return HAM_IGNORED;
}

// Player disconnect
public client_disconnect( id )
{
	// Silent Hill enabled?
	if ( !get_pcvar_num( PCVAR_sh_enabled ) )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Gamemode one enabled?
	if ( get_pcvar_num( PCVAR_sh_gamemode ) == 1 )
	{
		// Look if the player had a sprite entity
		if ( pev_valid( g_PlayerEnt[id] ) )
		{
			// Remove it
			engfunc( EngFunc_RemoveEntity, g_PlayerEnt[id] );
					
			// Reset the array
			g_PlayerEnt[id] = 0;
		}
	}
	
	// Reset the counter
	g_iReviveCounter[id] = 0;
	
	return PLUGIN_CONTINUE;
}

// Called on a button press etc.
public EVENTS_CmdStart( id, Handle )
{
	// Silent Hill enabled?
	if ( !get_pcvar_num( PCVAR_sh_enabled ) )
	{
		return FMRES_IGNORED;
	}
	
	// Gamemode 1 enabled and player alive?
	if ( get_pcvar_num( PCVAR_sh_gamemode ) != 1 || !is_user_alive( id ) )
	{
		return FMRES_IGNORED;
	}
	
	// Get the buttons
	static iButton, iOldButton;
	iButton = get_uc( Handle, UC_Buttons );
	iOldButton = pev( id, pev_oldbuttons );
	
	// Player press the USE button
	if ( iButton & IN_USE )
	{
		// The player just holding the USE button
		if ( ( iOldButton & IN_USE ) && g_bDoRevive[id] )
		{
			// Check the time if the delay is now over
			if ( get_gametime() >= ( g_fStartToRevive[id] + get_pcvar_float( PCVAR_sh_revtime ) ) )
			{
				// Check how much he has revived
				if ( g_iReviveCounter[id] >= get_pcvar_num( PCVAR_sh_maxrevive ) )
				{
					// Tell him that he has enough
					client_print( id, print_chat, "%s %L", MOD_NAME, id, "CHAT_ENOUGH_REVIVED" );
					
					return FMRES_IGNORED;
				}
				
				// He can revive, add one to the counter
				g_iReviveCounter[id]++;
				
				// Nomore reviving
				g_bDoRevive[id] = false;
					
				// Remove the cast bar
				Cast_Bar( id, 0 );
					
				// revive the player
				ExecuteHamB( Ham_CS_RoundRespawn, g_iWhoRevive[id] );
					
				// Spawn the player on the corpse position
				set_pev( g_iWhoRevive[id], pev_origin, g_PlayerOrigin[g_iWhoRevive[id]] );
				
				// Play the reincarnation sound
				emit_sound( g_iWhoRevive[id], CHAN_STATIC, SPAWN_SOUND, 1.0, ATTN_NORM, 0, PITCH_NORM );
				
				// Set the default speed
				set_pev( id, pev_maxspeed, 0.0 );
				
				// Remove the sprite entitys
				if ( pev_valid( g_PlayerEnt[g_iWhoRevive[id]] ) )
				{
					// Remove it
					engfunc( EngFunc_RemoveEntity, g_PlayerEnt[g_iWhoRevive[id]] );
					
					// Reset the array
					g_PlayerEnt[g_iWhoRevive[id]] = 0;
				}
				
				// Print a message that he was revived by a member
				client_print( g_iWhoRevive[id], print_chat, "%s %L", MOD_NAME, g_iWhoRevive[id], "CHAT_WASREVIVED" );
				
				// Nomore reviving
				g_iWhoRevive[id] = 0;
			}
		}
			
		// Fixing some bugs
		else if ( g_bDoRevive[id] )
		{
			// Reset the cast bar
			Cast_Bar( id, 0 );
			
			// Nomore reviving
			g_bDoRevive[id] = false;
				
			// Set the default speed
			set_pev( id, pev_maxspeed, 0.0 );
			
			// Nobody reviving
			g_iWhoRevive[id] = 0;
		}
		
		// The player want to start reviving
		else
		{
			// Here we save the position from the player
			static Float:fOrigin[3], bool:bIsMonster;
			
			// Save the race
			bIsMonster = is_user_monster( id );
			
			// Get the origin from this player
			pev( id, pev_origin, fOrigin );
		
			// Get all players
			static players[32], playersnum;
			get_players( players, playersnum );
		
			// Loop through all players
			for ( new i = 0; i < playersnum; ++i )
			{	
				// The player is alive - take the next
				if ( is_user_alive( players[i] ) )
				{
					continue;
				}
				
				// The player is an enemy - take the next
				if ( is_user_monster( players[i] ) && !bIsMonster )
				{
					continue;
				}
					
				// Starts the player to revive?
				if ( ( iOldButton & IN_USE ) && !g_bDoRevive[id] )
				{			
					// Is the player near a corpse?
					if ( get_distance_f( fOrigin, g_PlayerOrigin[players[i]] ) <= get_pcvar_float( PCVAR_sh_rev_distance ) )
					{
						// Yes, he revive someone now
						g_bDoRevive[id] = true;
						
						// Save the time when we start to revive
						g_fStartToRevive[id] = get_gametime();
					
						// And save the person which we revive
						g_iWhoRevive[id] = players[i];
					
						// The player can't walk
						set_pev( id, pev_maxspeed, 1.0 );
					
						// Show him the cast bar
						Cast_Bar( id, get_pcvar_num( PCVAR_sh_revtime ) );
					}
				}
			}
			
		}
	}
	
	// Fixing some bugs
	else if ( g_bDoRevive[id] )
	{
		// Reset the cast bar
		Cast_Bar( id, 0 );
			
		// Nomore reviving
		g_bDoRevive[id] = false;
				
		// Set the default speed
		set_pev( id, pev_maxspeed, 0.0 );
		
		// Nobody reviving
		g_iWhoRevive[id] = 0;
	}
	
	return FMRES_IGNORED;
}

// Called on round start
public EVENTS_NewRound()
{
	// Silent Hill enabled?
	if ( !get_pcvar_num( PCVAR_sh_enabled ) )
	{
		return;
	}
	
	// Yes, the round is started
	g_bEndRound = false;
}

// Called on round end
public EVENTS_RoundEnd()
{
	// Silent Hill enabled?
	if ( !get_pcvar_num( PCVAR_sh_enabled ) )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Yes, the round is ended
	g_bEndRound = true;
	
	// Gamemode one enabled?
	if ( get_pcvar_num( PCVAR_sh_gamemode ) == 1 )
	{
		// Loop through all players
		for ( new i = 0; i < 33; ++i )
		{
			// Remove the sprite entitys
			if ( pev_valid( g_PlayerEnt[i] ) )
			{
				// Remove it
				engfunc( EngFunc_RemoveEntity, g_PlayerEnt[i] );
				
				// Reset the array
				g_PlayerEnt[i] = 0;
			}
			
			// Reset the revive counter
			g_iReviveCounter[i] = 0;
		}
	}
	
	return PLUGIN_CONTINUE;
}
					
// Called when entity named corpse created
public EVENTS_ClCorpse( msgid, dest, id )
{
	// Silent Hill enabled?
	if ( !get_pcvar_num( PCVAR_sh_enabled ) )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Gamemode one enabled?
	if ( get_pcvar_num( PCVAR_sh_gamemode ) == 1 )
	{
		// Remove the corpse
		return PLUGIN_HANDLED;
	}
	
	return PLUGIN_CONTINUE;
}

// Create a flare effect for gamemode 1
public PLAYER_Flare( id )
{
	// Here we save the color codes
	static Float:fRGB[3];
	
	// The player is a monster
	if ( is_user_monster( id ) )
	{
		// Red flare
		fRGB[0] = 255.0;
	}
	
	// The player is a human
	else
	{
		// Blue Flare
		fRGB[2] = 255.0;
	}
	
	// The round is ended?
	if ( g_bEndRound )
	{
		return;
	}
	
	new iEnt = engfunc( EngFunc_CreateNamedEntity, engfunc( EngFunc_AllocString, "env_sprite" ) );
	engfunc( EngFunc_SetModel, iEnt, SPRITE_FLARE );
    
	set_pev( iEnt, pev_scale, 0.7 );
	set_pev( iEnt, pev_spawnflags, SF_SPRITE_STARTON );
    
	set_pev( iEnt, pev_solid, SOLID_NOT );
	set_pev( iEnt, pev_rendercolor, fRGB );
	set_pev( iEnt, pev_renderamt, 255.0 );
	set_pev( iEnt, pev_rendermode, kRenderTransAdd );
	set_pev( iEnt, pev_renderfx, kRenderFxNone );
	engfunc( EngFunc_SetOrigin, iEnt, g_PlayerOrigin[id] );
    
	set_kvd( 0, KV_KeyName, "framerate" );
	set_kvd( 0, KV_Value, "18.0" );
	dllfunc( DLLFunc_KeyValue, iEnt, 0 );
	dllfunc( DLLFunc_Spawn, iEnt );
	
	// Save the entity id
	g_PlayerEnt[id] = iEnt;
}  

// Create a cast bar 
stock Cast_Bar( id, iOption )
{
	message_begin( MSG_ONE, g_iBarTimeMsg, _, id );
	write_short( iOption );
	message_end();
}
