/* AMX Mod X
*   Silent Hill
*
*  by DA
*  http://www.fun-arena.com
*
*  This program is free software; you can redistribute it and/or modify it
*  under the terms of the GNU General Public License as published by the
*  Free Software Foundation; either version 2 of the License, or (at
*  your option) any later version.
*
*  This program is distributed in the hope that it will be useful, but
*  WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*  General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software Foundation,
*  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*  In addition, as a special exception, the author gives permission to
*  link the code of this program with the Half-Life Game Engine ("HL
*  Engine") and Modified Game Libraries ("MODs") developed by Valve,
*  L.L.C ("Valve"). You must obey the GNU General Public License in all
*  respects for all of the code used other than the HL Engine and MODs
*  from Valve. If you modify this file, you may extend this exception
*  to your version of the file, but you are not obligated to do so. If
*  you do not wish to do so, delete this exception statement from your
*  version.
*/

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <hamsandwich>
#include <engine>
#include <cstrike>
#include <xs>

#define VERSION "1.1"

// --- Includes ---
#include "SilentHill/constants.inl"		// Load the constants and defines 
#include "SilentHill/vars.inl"			// Load the variables
#include "SilentHill/cvars.inl"			// Load the cvars
#include "SilentHill/ini.inl"			// Load the ini file
#include "SilentHill/events.inl" 		// Load the events
#include "SilentHill/menu.inl"			// Load the menus
#include "SilentHill/weather.inl"		// Load the weather
#include "SilentHill/objectives.inl"		// Load the Game objectives
#include "SilentHill/equip.inl"			// Load the equip functions
#include "SilentHill/player.inl"		// Load the player functions
#include "SilentHill/tswitch.inl"		// Load the Team-Switch functions
#include "SilentHill/native.inl"		// Load the natives
#include "SilentHill/motd.inl" 			// Load the motds

public plugin_init() 
{
	register_plugin( "Silent Hill", VERSION, "DA" );
	register_cvar( "amx_silenthill", VERSION, FCVAR_SERVER );
	
	// hmm, a sandwich!
	RegisterHam ( Ham_Spawn, "player", "EVENTS_PlayerSpawn", 1 );
	RegisterHam ( Ham_Killed, "player", "EVENTS_PlayerKilled_Post", 1 );
	RegisterHam ( Ham_Touch, "func_buyzone", "EVENTS_touch_buyzone" );
	RegisterHam ( Ham_TakeDamage, "player", "EVENTS_takedamage_player" );
	RegisterHam ( Ham_TraceAttack, "player", "EVENTS_traceattack" );
	RegisterHam ( Ham_TakeDamage, "hostage_entity", "EVENTS_ChristaDamage" );
	RegisterHam ( Ham_TraceAttack, "hostage_entity", "EVENTS_traceChrista" );
	RegisterHam ( Ham_Spawn, "weaponbox", "EVENTS_WeaponBoxSpawn", 1 );
	
	// We have to loop through all weapons (from arkshine *thanks*)
	new s_WeaponName[24];
	for ( new i_Wpid = 1; i_Wpid <= MAX_WEAPONS; i_Wpid++ )
         {
		// Don't register item/weapons which can not reload.
		if ( !( ( 1 << i_Wpid ) & CANT_RELOAD_BITSUM ) && get_weaponname ( i_Wpid, s_WeaponName, charsmax ( s_WeaponName ) ) )
		{
			RegisterHam ( Ham_Weapon_Reload, s_WeaponName, "EVENTS_OnReload", 1 );
		}
	}

	// Event's
	register_event ( "HLTV", "EVENTS_NewRound", "a", "1=0", "2=0" );
	register_event ( "CurWeapon", "EVENTS_CurWeapon", "be", "1=1" );
	register_event ( "TextMsg", "EVENTS_ChristaKilled", "b", "1=4", "2=#Killed_Hostage" );
	register_logevent ( "EVENTS_EndRound", 2, "0=World triggered", "1=Round_End" );
	register_logevent ( "EVENTS_FreezeTimeComplete", 2, "0=World triggered", "1=Round_Start" );
	register_logevent ( "EVENTS_SpawnWithBomb", 3, "2=Spawned_With_The_Bomb" );
	
	// Register the menu's
	register_menu ( "SelectChar", 1023, "_MENU_HandleSelectChar" );
	register_menu ( "EquipMain", 1023, "_MENU_HandleEquipMain" );
	register_menu ( "EquipPrimary", 1023, "_MENU_HandlePrimaryMenu" );
	register_menu ( "EquipSecondary", 1023, "_MENU_HandleSecondaryMenu" );
	register_menu ( "EquipArmor", 1023, "_MENU_HandleEquipArmor" );
	register_menu ( "EquipNade", 1023, "_MENU_HandleEquipNades" );
	register_menu ( "SHMenu", 1023, "_MENU_HandleMainHelp" );
	register_menu ( "ObjHelpMenu", 1023, "_MENU_HandleObjHelp" );
	
	// Forwards
	unregister_forward( FM_Spawn, g_fwd_spawn );
	register_forward( FM_AddToFullPack, "EVENTS_addToFullPack", 1 );
	register_forward( FM_PlayerPreThink, "EVENTS_preThink" );
	register_forward( FM_PlayerPreThink, "EVENTS_prethink_post", 1 );
	register_forward( FM_SetClientKeyValue, "EVENTS_SetClientKeyValue" );
	register_forward( FM_ClientUserInfoChanged, "EVENTS_ClientUserInfoChanged" );

	// User messages
	register_message( get_user_msgid( "SendAudio" ), "EVENTS_sendaudio" );
	register_message( get_user_msgid( "TextMsg" ), "EVENTS_textmsg" );
	register_message( get_user_msgid( "Radar" ), "EVENTS_radarmsg" );
	register_message( get_user_msgid( "ScoreAttrib" ), "EVENTS_scoreattrib" );
	g_msg_teaminfo = get_user_msgid( "TeamInfo" );
	g_msgScreenShake = get_user_msgid( "ScreenShake"	);
	
	// Create the multiforwards 
	g_fwd_dimension = CreateMultiForward( "event_dimswitch", ET_IGNORE );
	
	// Synced hud
	g_SyncHud = CreateHudSyncObj();
	
	// Set up the Hud-Task
	set_task( 0.1, "PLAYER_CreateHud", _, _, _, "b" );
	
	// Detect the map type
	OBJ_DetectMapType();

	// Register all the CVAR's
	CVARS_LoadCVARS();
	
	// Copy the content from the pcvars to the vars
	set_task( 0.2, "CVARS_CopyPCVARS" );
	
	// Register the chars
	set_task( 0.3, "INI_RegisterChars" );
	
	// Find the map objectives
	OBJ_FindObjectives();
}

public plugin_cfg()
{
	// Execute the config
	CVARS_SilentHill_CFG();
}
	

public plugin_precache()
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// Load the customizen file
	INI_LoadData();
	
	// Entity spawn
	g_fwd_spawn = register_forward( FM_Spawn, "EVENTS_ObjectSpawn" );
	
	// Set the language file
	register_dictionary( "silenthill.txt" );
	
	// Let us create the sky and the snow
	set_cvar_string( "sv_skyname", "alien1" );
	fm_create_entity( "env_snow" );
		
	// Our counter
	new i;
	
	// Precache the CT winsounds
	for ( i = 0; i < g_iCTWinS; ++i )
	{
		precache_sound( ct_winsounds[i] );
	}
	
	// Precache the T winsounds
	for ( i = 0; i < g_iTWinS; ++i )
	{
		precache_sound( t_winsounds[i] );
	}
	
	// Precache the Dimension start sound
	for ( i = 0; i < g_iDimStartSound; ++i )
	{
		precache_sound( dimension_startsound[i] );
	}
	
	// Precache First Dimension ambience sounds
	new sound[200];
	for ( i = 0; i < g_iFirstAmbienceS; ++i )
	{
		// Copy the path in the sound array
		formatex( sound, charsmax( sound), "%s", ambience_first_sound[i] )
		
		// Is the file a .mp3 file?
		if ( equal( sound[ strlen( sound ) - 4 ], ".mp3") )
		{
			// We have to add the sound folder
			formatex( sound, charsmax(sound ), "sound/%s", ambience_first_sound[i] );
			
			// Precache the mp3 file generic
			precache_generic( sound );
		}
		
		// It's a wave file
		else
		{
			precache_sound( sound );
		}
	}
	
	// Precache Second Dimension ambience sound
	for ( i = 0; i < g_iSeconAmbienceS; ++i )
	{
		// Copy the path in the sound array
		formatex( sound, charsmax( sound), "%s", ambience_secon_sound[i] )
		
		// Is the file a .mp3 file?
		if ( equal( sound[ strlen( sound ) - 4 ], ".mp3") )
		{
			// We have to add the sound folder
			formatex( sound, charsmax(sound ), "sound/%s", ambience_secon_sound[i] );
			
			// Precache the mp3 file generic
			precache_generic( sound );
		}
		
		// It's a wave file
		else
		{
			precache_sound( sound );
		}
	}
	
	// Precache Player Model and Weapon Model
	new buffer[200];
	for ( i = 0; i <= g_charcounter; ++i )
	{
		formatex( buffer, charsmax( buffer ), "models/player/%s/%s.mdl", character_pmodel[i], character_pmodel[i] );
		precache_model( buffer );
		precache_model( character_wmodel[i] );
	}
	
	// Precache the Christabella model
	formatex( buffer, charsmax( buffer ), "models/%s.mdl", christabella_pmodel );
	precache_model( buffer );
	
	// Precache the hostage sounds
	precache_sound( "hostage/hos1.wav" );
	precache_sound( "hostage/hos2.wav" );
	precache_sound( "hostage/hos3.wav" );
	precache_sound( "hostage/hos4.wav" );
	precache_sound( "hostage/hos5.wav" );
}

// Here we register the natives
public plugin_natives()
{
	register_library( "silenthillmod" );
	
	// Returns False on First Dimension and True on Second Dimension
	register_native( "get_dimension", "NATIVE_get_dimension", 1 );
	
	// Returns the characterid from a user
	register_native( "get_user_charid", "NATIVE_get_user_charid", 1 );
	
	// Returns the Character ID with the charactername (not found = -1)
	register_native( "get_charid", "NATIVE_get_charid", 1 );
	
	// Returns False if christabella isn't alive and true if she is alive
	register_native( "is_christa_alive", "NATIVE_is_christa_alive", 1 );
	
	// Returns True if the user is a monster
	register_native( "is_user_monster", "NATIVE_is_user_monster", 1 );
}

// Client is on the server
public client_putinserver( id )
{
	// Silent Hill enabled 
	if ( !SH_Check() )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Reset some data
	PLAYER_ResetData( id );
	
	// We're in the first dimension, create the fog for the new player
	set_task( 0.1, "WEATHER_SetFog", TASK_FOG );
	
	return PLUGIN_CONTINUE;
}
	
// Client is connecting
public client_connect( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return PLUGIN_CONTINUE;
	}
	
	// We need this that the player really get the complete weahter to see
	client_cmd( id, "cl_weather 1" );
	
	return PLUGIN_CONTINUE;
}

// Client disconnects
public client_disconnect( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return PLUGIN_CONTINUE;
	}
	
	// Reset some data
	PLAYER_ResetData( id );
	
	return PLUGIN_CONTINUE;
}

// Is Silent Hill enabled?
public bool:SH_Check()
{
	if ( sh_enabled == 1 )
	{
		return true;
	}
	
	return false;
}

// Plays a sound on clients
public PlaySound( const sound[] )
{
	// Is the file a .mp3 file?
	if ( equal( sound[ strlen( sound ) - 4 ], ".mp3") )
	{
		// Okay, play the mp3 file
		client_cmd( 0, "mp3 play ^"sound/%s^"", sound );
	}
	
	// It's a wave file
	else
	{
		client_cmd( 0, "spk ^"%s^"", sound );
	}
}

// Stop the sound
public StopSound()
{
	// Stop the sound on all clients 
	client_cmd( 0, "mp3 stop; stopsound" );
}
