/* Silent Hill Equip Menu */

// Equip the user with the previous setup
public EQUIP_PrevSetup( id )
{
	EQUIP_equipUser( id, EQUIP_ALL );
}

// Equip a user with weapons/items
public EQUIP_equipUser( id, to )
{
	// player isn't alive
	if ( !is_user_alive( id ) )
	{
		return;
	}
	
	if ( ( to & EQUIP_SEC ) && g_mPrimStatus )
	{
		// create the right name
		new sWeaponName[32];
		formatex( sWeaponName, charsmax( sWeaponName ), "weapon_%s", g_seconnames[g_SecWeapons[id]] );
		
		// CS hates quotes, spaces and uppcase
		trim( sWeaponName );
		strtolower( sWeaponName );
		remove_quotes( sWeaponName );
		
		//Give Secondary
		EQUIP_GiveUserFullWeapon( id, sWeaponName );
	}
	
	if ( ( to & EQUIP_PRI ) && g_mSecStatus )
	{		
		// create the right name
		new sWeaponName[32];
		formatex( sWeaponName, charsmax( sWeaponName ), "weapon_%s", g_primnames[g_PrimWeapons[id]] );
		
		// CS hates quotes, spaces and uppcase
		trim( sWeaponName );
		strtolower( sWeaponName );
		remove_quotes( sWeaponName );
		
		//Give Primary
		EQUIP_GiveUserFullWeapon( id, sWeaponName );
	}
	
	if ( to & EQUIP_ARMOR )
	{
		//Give Armor
		if ( g_mAutoArmor || g_mArmor[id] )
		{
			// menuarmor = Helm & Armor else armor or armor & helm
			new armor = g_mArmor[id] ? 2 : g_Armor
			cs_set_user_armor( id, 100, CsArmorType:armor );
		}
	}
	
	if ( to & EQUIP_GREN )
	{
		//Give Nades
		if ( g_mNades[id] || g_mAutoNades )
		{	
			// HE Grenade
			if ( g_Nade )
			{
				EQUIP_GiveUserFullWeapon( id, "weapon_hegrenade" );
			}
			
			// Smoke grenade
			if ( g_Smoke )
			{
				EQUIP_GiveUserFullWeapon( id, "weapon_smokegrenade" );
			}
		
			// Flash with the given number
			if ( g_Flash && fnadesnum )
			{
				EQUIP_GiveUserFullWeapon( id, "weapon_flashbang" );
				if ( fnadesnum == 2 )
				{
					EQUIP_GiveUserFullWeapon( id, "weapon_flashbang" );
				}
			}
		}
	}
	
	if ( to & EQUIP_ITEMS )
	{
		// Set defuse kit (only CT)
		if ( g_DefuseKit && ( fm_get_user_team( id ) == CS_TEAM_CT ) )
		{
			cs_set_user_defuse( id, 1 );
		}
		
		// Set nightvision
		if ( g_NightVision )
		{
			cs_set_user_nvg( id, 1 );
		}
	}
}

// Give the player the weapon(s)
EQUIP_GiveUserFullWeapon( id, wp[] )
{
	/* First check to make sure the user does not have a weapon in this slot */
	new wpnid = get_weaponid( wp );
	new weapons[32], num;
	new name[24];
	new slot;
	
	// Get the right index with the weaponid
	slot = g_WeaponSlots[wpnid];
	
	// Okay we have primary or secondary weapon
	if ( ( slot == SLOT_SECONDARY || slot == SLOT_PRIMARY ) && wpnid > 0 )
	{
		// Get all weapons from the player
		get_user_weapons( id, weapons, num );
		
		// Loop through all weapons
		for ( new i = 0; i < num; i++ )
		{
			// We've found our weapon by the player - go forwards
			if ( weapons[i] == wpnid )
			{
				continue;
			}
			
			//  The player has a weapon in our weaponslot
			if ( g_WeaponSlots[weapons[i]] == slot )
			{
				// get the complete name with the id
				get_weaponname( weapons[i], name, charsmax( name ) );
				
				// Drop this weapon
				EQUIP_strip_weapon( id, name );
			}
		}
	} 
	
	// Give the player the new weapon
	new bError = EQUIP_give_weapon( id, wp );
	
	// Check if the weapon was created
	if ( bError > 0 )
	{
		// set up the task for the silencer
		set_task( 0.4, "EQUIP_SetSilencer", ( TASK_SILENCER + id ) );
	}

	// Player has a weapon
	if ( wpnid > 0 && wpnid != CSW_FLASHBANG )
	{
		// Get the maximum ammp
		new bpammo = g_weapon_ammo[wpnid][MAX_AMMO];
		
		// We've found the right ammo
		if (bpammo)
		{
			// Set the ammo on the weapon
			PLAYER_set_bpammo( id, wpnid, bpammo );
		}
	}
}

// Sets the silencer for USP or/and M4A1
public EQUIP_SetSilencer( id )
{
	// get default id
	if ( id > TASK_SILENCER )
	{
		id -= TASK_SILENCER;
	}
	
	// wth, user died
	if ( !is_user_alive( id ) )
	{
		return;
	}
	
	// find the entity ID
	new iWeaponEnt = find_ent_by_owner( -1, "weapon_m4a1", id );
	
	// It's valid
	if ( is_valid_ent( iWeaponEnt ) )
	{
		// set the silencer
		cs_set_weapon_silen( iWeaponEnt, g_Silenced[id][SILENCED_M4A1], 1 );
	}

	// find the entity ID
	iWeaponEnt = find_ent_by_owner( -1, "weapon_usp", id );
	
	// It's valid
	if ( is_valid_ent( iWeaponEnt ) )
	{
		// set the silencer
		cs_set_weapon_silen( iWeaponEnt, g_Silenced[id][SILENCED_USP], 1 );
	}
}
	

// Will strip a weapon from a player (thanks & credits Cheap_Suit)
stock EQUIP_strip_weapon( index, weapon[] )
{
	// Get the weaponID
	static weaponid;
	weaponid = get_weaponid( weapon );
	
	// Find the ent
	static weaponent;
	weaponent = find_ent_by_owner( -1, weapon, index );
	
	// something is wrong here - go out
	if( !weaponent ) 
	{
		return 0;
	}

	// Check again if the player has the weapon
	if( get_user_weapon( index ) == weaponid )  
	{
		ExecuteHamB( Ham_Weapon_RetireWeapon, weaponent );
	}

	// Remove the item - if its possible
	if( !ExecuteHamB( Ham_RemovePlayerItem, index, weaponent ) ) 
	{
		return 0;
	}
	
	// Kill the weapon
	ExecuteHamB( Ham_Item_Kill, weaponent );
	set_pev( index, pev_weapons, pev(index, pev_weapons) & ~(1<<weaponid) );

	return 1;
}

// Gives a player a weapon
stock EQUIP_give_weapon( index, weapon[] ) 
{
	// Create the new weapon
	static ent;
	ent = engfunc( EngFunc_CreateNamedEntity, engfunc( EngFunc_AllocString, weapon ) );
	
	// Check if it's alright
	if( !pev_valid( ent ) )
	{
		return 0;
	}
    
	// Set the flags and spawn the weapon
	set_pev( ent, pev_spawnflags, SF_NORESPAWN );
	dllfunc( DLLFunc_Spawn, ent );
   
	// Try to add the weapon to the player
	if( !ExecuteHamB( Ham_AddPlayerItem, index, ent ) )
	{
		// Okay, remove the ent
		if ( pev_valid(ent) )
		{
			set_pev( ent, pev_flags, pev( ent, pev_flags ) | FL_KILLME );
			return 0;
		}
	}
	ExecuteHamB( Ham_Item_AttachToPlayer, ent, index );

	return 1;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
