/* Silent Hill Menus */

// Main Silent Hill Menu
public MENU_MainHelp( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	static MenuText[512], KEYS;
	
	// Add the header
	formatex( MenuText, charsmax( MenuText ), "\y%s: %L^n^n", MOD_NAME, id, "MENU_MAIN" );
	
	// Add every menupoint
	formatex( MenuText, charsmax( MenuText ), "%s\r1.\w %L^n", MenuText, id, "MENU_CHANGECHAR" );
	formatex( MenuText, charsmax( MenuText ), "%s\r2.\w %L^n", MenuText, id, "MENU_OBJ" );
	formatex( MenuText, charsmax( MenuText ), "%s\r3.\w %L^n", MenuText, id, "MENU_COM" );
	formatex( MenuText, charsmax( MenuText ), "%s\r4.\w %L^n", MenuText, id, "MENU_CRED" );
	formatex( MenuText, charsmax( MenuText ), "%s^n\r0.\w %L^n", MenuText, id, "MENU_EXIT" );
	
	// Add the keys
	KEYS = (1<<9) | (1<<0) | (1<<1)| (1<<2) | (1<<3);
	
	// Show the menu
	show_menu( id, KEYS, MenuText, 25, "SHMenu" );
	
	return;
}

// Handle the sh main menu
public _MENU_HandleMainHelp( id, key )
{
	// Player connected?
	if ( !is_user_connected( id ) )
	{
		return;
	}
	
	switch ( key )
	{
		case 9: // Exit
		{
			return;
		}
		
		case 0: // Changechar menu
		{
			MENU_SelectChar( id );
		}
		
		case 1: // Help Gameobjectives
		{
			MENU_ObjHelp( id );
		}
		
		case 2: // Commands list motd
		{
			MOTD_Commands( id );
		}
		
		case 3: // Credits motd
		{
			MOTD_ShowCredits( id );
		}
	}
	
	return;
}

// Objectives Menu
public MENU_ObjHelp( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	static MenuText[512], KEYS;
	
	// Add the header
	formatex( MenuText, charsmax( MenuText ), "\y%L^n^n", id, "MENU_OBJ" );
	
	// Add every menupoint
	formatex( MenuText, charsmax( MenuText ), "%s\r1.\w %L^n", MenuText, id, "MENU_DEMAP" );
	formatex( MenuText, charsmax( MenuText ), "%s\r2.\w %L^n", MenuText, id, "MENU_CSMAP" );
	formatex( MenuText, charsmax( MenuText ), "%s\r3.\w %L^n", MenuText, id, "MENU_ASMAP" );
	formatex( MenuText, charsmax( MenuText ), "%s^n\r0.\w %L^n", MenuText, id, "MENU_EXIT" );
	
	// Add the keys
	KEYS = (1<<9) | (1<<0) | (1<<1)| (1<<2);
	
	// Show the menu
	show_menu( id, KEYS, MenuText, 25, "ObjHelpMenu" );
	
	return;
}

// Handle the ObjHelp menu
public _MENU_HandleObjHelp( id, key )
{
	// Player connected?
	if ( !is_user_connected( id ) )
	{
		return;
	}
	
	switch ( key )
	{
		case 9: // Exit
		{
			return;
		}
		
		case 0: // DE_ help
		{
			MOTD_ObjHelp( id, 0 );
		}
		
		case 1: // CS_ help
		{
			MOTD_ObjHelp( id, 1 );
		}
		
		case 2: // AS_ help
		{
			MOTD_ObjHelp( id, 2 );
		}
	}
	
	return;
}

// Main Equip menu
public MENU_EquipMain( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// Player has already opened menu
	if ( p_data_b[id][PLAYER_USEDGUNS] )
	{
		client_print( id, print_chat, "%s %L", MOD_NAME, id, "CHAT_ALREADYGUNS" );
		
		return;
	}
	
	// Menu is disabled
	else if ( sh_equipmenu == 0 )
	{
		return;
	}
	
	// the player opened the menu maybe via /guns. 
	g_mShowuser[id] = true;
	
	// the player opened the menu, he can again on the next round
	p_data_b[id][PLAYER_USEDGUNS] = true;
	
	// The header
	new MenuText[2048] = "";
	formatex( MenuText, charsmax( MenuText ), "\y%L^n", id, "MENU_EQUIPMAIN" );
	
	// Add the menupoints
	formatex( MenuText, charsmax( MenuText ), "%s^n\r1.\w %L", MenuText, id, "MENU_NEWW" ); // New weapons
	formatex( MenuText, charsmax( MenuText ), "%s^n\r2.\w %L", MenuText, id, "MENU_PREVS" ); // Previous Setup
	formatex( MenuText, charsmax( MenuText ), "%s^n\r3.\w %L", MenuText, id, "MENU_DONTSHOW" ); // Don't show menu again
	
	// Set up the key's
	static keys;
	keys |= (1<<0) | (1<<1) | (1<<2) 
	
	// Show him the menu
	show_menu( id, keys, MenuText, 25, "EquipMain" );
	
	return;
}

// Handle the Equip Main menu
public _MENU_HandleEquipMain( id, key )
{
	// Player isn't connected
	if ( !is_user_connected( id ) )
	{
		return;
	}
	
	switch ( key )
	{
		case 0:
		{
			// Open the secondary weapons menu
			if ( g_mSecStatus )
			{
				MENU_SecondaryMenu( id );
			}
			
			// Open the primary weapons menu
			else if ( g_mPrimStatus )
			{
				MENU_PrimaryMenu( id, 0 );
			}
			
			// Open the Armor menu
			else if ( g_mArmorStatus )
			{
				MENU_EquipArmor( id );
			}
			
			// Open the Grenades menu
			else if ( g_mNadeStatus )
			{
				// Only activated the nade menu, but auto armo
				if ( g_mAutoArmor ) 
				{
					EQUIP_equipUser( id, EQUIP_ARMOR );
				}
				
				// But open the grenades menu
				MENU_EquipNades( id );
			}
			
			// No menus, but maybe autoitems 
			else
			{
				// Auto armor?
				if ( g_mAutoArmor )
				{
					// Okay give him armor
					EQUIP_equipUser( id, EQUIP_ARMOR );
				}
				
				// Auto nades?
				if ( g_mAutoNades )
				{
					// Okay give him nades
					EQUIP_equipUser( id, EQUIP_GREN );
				}
				
				// Nothing auto. So lets check if we should give the player items
				EQUIP_equipUser( id, EQUIP_ITEMS );
			}
		}
		
		case 1: 
		{
			// Give him previus weapons
			EQUIP_PrevSetup( id );
		}
		
		case 2: 
		{
			// Give him previus weapons
			EQUIP_PrevSetup( id );
			
			// Tell him how to re-enable the menu
			client_print( id, print_chat, "%s %L", MOD_NAME, id, "CHAT_EQUIPREENABLE" );
			
			// And save that he wants the same at the next round and don't show up the equip menu
			g_mShowuser[id] = false;
		}
	}
	
	return;
}

// Primary Weapons menu
public MENU_PrimaryMenu( id, side )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// The header
	new MenuText[2048] = "";
	formatex( MenuText, charsmax( MenuText ), "\y%L ", id, "MENU_EQUIPPRIM" );
	
	// The player should have an oversee about the pages
	new iNum = abs( MAX_PRIMARY / MAX_WEAPONS_SIDE ) + 1;
	formatex( MenuText, charsmax( MenuText ), "%s%d/%d^n", MenuText, ( side + 1 ), iNum );
	
	// Save the side. Need it to calculate later the right offset
	p_data[id][MENUS_SIDE] = side;
	
	// Calculate the right side
	side *= MAX_WEAPONS_SIDE;
	
	// Loop through the Weapons array and add every weapon 
	new i, KEY = (1<<9); 
	for ( i = side; i < MAX_PRIMARY; ++i )
	{
		// The page is full
		if ( ( i - side ) == MAX_WEAPONS_SIDE )
		{
			// Maybe we add the menupoint "More"
			if ( i != ( MAX_PRIMARY - 1 ) )
			{
				// Add the key
				KEY |= (1<<8);
			}
			
			break;
		}
		
		// This weapon is enabled
		if ( !g_DisabledPrim[i] )
		{
			// Add the menupoint
			formatex( MenuText, charsmax( MenuText ), "%s^n\r%d.\w %s", MenuText, ( i - side + 1 ), g_primnames[i] );
		
			// Create a key 
			KEY |= (1<<(i-side));
		}
		
		// This weapon is disabled. Add it in gray
		else
		{
			formatex( MenuText, charsmax( MenuText ), "%s^n\d%d. %s", MenuText, ( i - side + 1 ), g_primnames[i] );
		}
	}
	
	// Should we add the menupoint "Back"?
	if ( side != 0 )
	{
		// Add the key
		KEY |= (1<<7);
		
		// add the line
		formatex( MenuText, charsmax( MenuText ), "%s^n^n\r8.\w %L", MenuText, id, "MENU_BACK" );
	}
	
	else
	{
		// Add the line but gray for not enabled
		formatex( MenuText, charsmax( MenuText ), "%s^n^n^n\d8. %L", MenuText, id, "MENU_BACK" );
	}
	
	// Should we add the menupoint "More"
	if ( (1<<8) & KEY )
	{
		formatex( MenuText, charsmax( MenuText ), "%s^n\r9.\w %L", MenuText, id, "MENU_MORE" );
	}
	
	else
	{
		// Make it gray
		formatex( MenuText, charsmax( MenuText ), "%s^n\d9. %L", MenuText, id, "MENU_MORE" );
	}
	
	// Add the exit line
	formatex( MenuText, charsmax( MenuText ), "%s^n\r0.\w %L", MenuText, id, "MENU_EXIT" );
	
	// set up the menu
	show_menu( id, KEY, MenuText, 25, "EquipPrimary" );
	
	return;
}

// Handle the Equip primary menu
public _MENU_HandlePrimaryMenu( id, key )
{
	// user isn't connected
	if ( !is_user_connected( id ) )
	{
		return;
	}
	
	// The player wants to exit the menu
	if ( key == 9 )
	{
		// Reset the side
		p_data[id][MENUS_SIDE] = 0;
		
		return;
	}
	
	// Go one page back
	else if ( key == 7 )
	{
		MENU_PrimaryMenu( id, ( p_data[id][MENUS_SIDE] - 1 ) );
		
		return;
	}
	
	// Go to the next page
	else if ( key == 8 )
	{
		MENU_PrimaryMenu( id, ( p_data[id][MENUS_SIDE] + 1 ) );
		
		return;
	}
	
	// define with the side the right key back
	g_PrimWeapons[id] = ( p_data[id][MENUS_SIDE] * MAX_WEAPONS_SIDE ) + key;
	
	// Equip the user
	EQUIP_equipUser( id, EQUIP_PRI );
	
	// Open the Armor menu
	if ( g_mArmorStatus )
	{
		MENU_EquipArmor( id );
	}
			
	// Open the Grenades menu
	else if ( g_mNadeStatus )
	{
		// Only activated the nade menu, but auto armo
		if ( g_mAutoArmor ) 
		{
			EQUIP_equipUser( id, EQUIP_ARMOR );
		}
				
		// But open the grenades menu
		MENU_EquipNades( id );
	}
	
	// No menus, but maybe autoitems 
	else
	{
		// Auto armor?
		if ( g_mAutoArmor )
		{
			// Okay give him armor
			EQUIP_equipUser( id, EQUIP_ARMOR );
		}
				
		// Auto nades?
		if ( g_mAutoNades )
		{
			// Okay give him nades
			EQUIP_equipUser( id, EQUIP_GREN );
		}
		
		// Nothing auto. So lets check if we should give the player items
		EQUIP_equipUser( id, EQUIP_ITEMS );
	}
	
	return;
}

// Secondary Equip Menu
public MENU_SecondaryMenu( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// The header
	new MenuText[2048] = "";
	formatex( MenuText, charsmax( MenuText ), "\y%L^n", id, "MENU_EQUIPSECONDARY" );
	
	// Loop through the Secondary array and all weapons
	new KEY = (1<<9);
	for ( new i = 0; i < MAX_SECONDARY; ++i )
	{
		// This weapon is enabled
		if ( !g_DisabledSec[i] )
		{
			formatex( MenuText, charsmax( MenuText ), "%s^n\r%d.\w %s", MenuText, ( i + 1 ), g_seconnames[i] );
			
			// add the key
			KEY |= (1<<i);
		}
		
		// This weapon is disabled. Add it in gray
		else
		{
			formatex( MenuText, charsmax( MenuText ), "%s^n\d%d. %s", MenuText, ( i + 1 ), g_seconnames[i] );
		}
	}
	
	// Add the exit line
	formatex( MenuText, charsmax( MenuText ), "%s^n^n^n\r0.\w %L", MenuText, id, "MENU_EXIT" );
	
	// Show up the menu
	show_menu( id, KEY, MenuText, 25, "EquipSecondary" );
	
	return;
}

// Handle Secondary Equip menu
public _MENU_HandleSecondaryMenu( id, key )
{
	// player isn't connected
	if ( !is_user_connected( id ) )
	{
		return;
	}
	
	// We exit the menu
	if ( key == 9 )
	{
		return;
	}
	
	// Save the key
	g_SecWeapons[id] = key;
	
	// Give the player the secondary weapon
	EQUIP_equipUser( id, EQUIP_SEC );
	
	// Open the primary weapons menu
	if ( g_mPrimStatus )
	{
		MENU_PrimaryMenu( id, 0 );
	}
			
	// Open the Armor menu
	else if ( g_mArmorStatus )
	{
		MENU_EquipArmor( id );
	}
		
	// Open the Grenades menu
	else if ( g_mNadeStatus )
	{
		// Only activated the nade menu, but auto armo
		if ( g_mAutoArmor ) 
		{
			EQUIP_equipUser( id, EQUIP_ARMOR );
		}
				
		// But open the grenades menu
		MENU_EquipNades( id );
	}
			
	// No menus, but maybe autoitems 
	else
	{
		// Auto armor?
		if ( g_mAutoArmor )
		{
			// Okay give him armor
			EQUIP_equipUser( id, EQUIP_ARMOR );
		}
				
		// Auto nades?
		if ( g_mAutoNades )
		{
			// Okay give him nades
			EQUIP_equipUser( id, EQUIP_GREN );
		}
				
		// Nothing auto. So lets check if we should give the player items
		EQUIP_equipUser( id, EQUIP_ITEMS );
	}
	
	return;
}

// Equip Armor Menu
public MENU_EquipArmor( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// The header
	new MenuText[2048] = "";
	formatex( MenuText, charsmax( MenuText ), "\y%L^n", id, "MENU_EQUIPARMOR" );
	
	// Add the menupoints
	formatex( MenuText, charsmax( MenuText ), "%s^n\r1.\w %L", MenuText, id, "MENU_ARMORYES" ); // Yes, gimme armor
	formatex( MenuText, charsmax( MenuText ), "%s^n\r2.\w %L", MenuText, id, "MENU_ARMORNO" ); // No Armor
	formatex( MenuText, charsmax( MenuText ), "%s^n^n^n\r0.\w %L", MenuText, id, "MENU_EXIT" ); // Exit
	
	// Set up the key's
	static keys;
	keys |= (1<<0) | (1<<1) | (1<<9);
	
	// Show him the menu
	show_menu( id, keys, MenuText, 25, "EquipArmor" );
	
	return;
}

// Handle Equip Armor menu
public _MENU_HandleEquipArmor( id, key )
{
	// player isn't connected
	if ( !is_user_connected( id ) )
	{
		return;
	}
	
	// Save the configuration
	if ( key == 0 )
	{
		g_mArmor[id] = true;
	}
	
	// Okay give him armor
	EQUIP_equipUser( id, EQUIP_ARMOR );
	
	// Open the Grenades menu
	if ( g_mNadeStatus )
	{
		// Only activated the nade menu, but auto armo
		if ( g_mAutoArmor ) 
		{
			EQUIP_equipUser( id, EQUIP_ARMOR );
		}
				
		// But open the grenades menu
		MENU_EquipNades( id );
	}
			
	// No menus, but maybe autoitems 
	else
	{
		// Auto armor?
		if ( g_mAutoArmor )
		{
			// Okay give him armor
			EQUIP_equipUser( id, EQUIP_ARMOR );
		}
				
		// Auto nades?
		if ( g_mAutoNades )
		{
			// Okay give him nades
			EQUIP_equipUser( id, EQUIP_GREN );
		}
				
		// Nothing auto. So lets check if we should give the player items
		EQUIP_equipUser( id, EQUIP_ITEMS );
	}
	
	return;
}

// Equip Grenades Menu
public MENU_EquipNades( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// The header
	new MenuText[2048] = "";
	formatex( MenuText, charsmax( MenuText ), "\y%L^n", id, "MENU_EQUIPNADE" );
	
	// Add the menupoints
	formatex( MenuText, charsmax( MenuText ), "%s^n\r1.\w %L", MenuText, id, "MENU_ALLNADES" ); // All grenades
	formatex( MenuText, charsmax( MenuText ), "%s^n\r2.\w %L", MenuText, id, "MENU_NONADES" ); // No Nades
	formatex( MenuText, charsmax( MenuText ), "%s^n^n^n\r0.\w %L", MenuText, id, "MENU_EXIT" ); // Exit
	
	// Set up the key's
	static keys;
	keys |= (1<<0) | (1<<1) | (1<<9);
	
	// Show him the menu
	show_menu( id, keys, MenuText, 25, "EquipNade" );
	
	return;
}

// Handle Equip Nades menu
public _MENU_HandleEquipNades( id, key )
{
	// player isn't connected
	if ( !is_user_connected( id ) )
	{
		return;
	}
	
	// Save the configuration
	if ( key == 0 )
	{
		g_mNades[id] = true;
	}
	
	// Give him the nades and the autoitems
	EQUIP_equipUser( id, EQUIP_GREN );
	EQUIP_equipUser( id, EQUIP_ITEMS );
	
	return;
}
	
	
// Show the player the character select menu
public MENU_SelectChar( id )
{
	// Silent Hill enabled?
	if ( !SH_Check() )
	{
		return;
	}
	
	// Player used changechar
	if ( p_data_b[id][PLAYER_USEDCHAR] )
	{
		client_print( id, print_chat, "%s %L", MOD_NAME, id, "CHAT_USEDCHAR" );
		
		return;
	}
	
	// Player used the menu
	p_data_b[id][PLAYER_USEDCHAR] = true;
	
	// The header
	new MenuText[2048] = "";
	formatex( MenuText, charsmax( MenuText ), "\y%L^n", id, "MENU_SELECT_CHAR" );
	
	// Create every Character
	new KEYS;
	for ( new i = 0; i <= g_charcounter; ++i )
	{
		// Add it
		formatex( MenuText, charsmax( MenuText ), "%s^n\r%d.\w %s - %s", MenuText, ( i + 1 ), character_name[i], character_desc[i] );
		
		// Addd the keys
		KEYS |= (1<<i);
	}
	
	// Add the exit text
	formatex( MenuText, charsmax( MenuText ), "%s^n^n\r0.\w %L", MenuText, id, "MENU_EXIT" );
	
	// Add the Exit-Key
	KEYS |= (1<<9);
	
	// Show up the menu
	show_menu ( id, KEYS, MenuText, 25, "SelectChar" );
	
	return;
}

// Handle the pressed key from SelectChar
public _MENU_HandleSelectChar( id, key )
{
	// Player isn't on the server wtf?
	if ( !is_user_connected( id ) )
	{
		return;
	}
	
	// He pressed the exit button - okay
	if ( key == 9 ) 
	{
		return;
	}
	
	// Player selected a char, don't show again the menu
	p_data_b[id][PLAYER_SELECTEDCHAR] = true;
	
	// Save the pressed key
	p_data[id][PLAYER_CHARACTER] = key;
	
	// Player is alive and a monster? 
	if ( is_user_alive( id ) && p_data_b[id][PLAYER_ISMONSTER] )
	{
		// Give him instant the advantages
		PLAYER_MonsterAdv( id );
		
		// And set up the right model
		set_task( 0.2, "PLAYER_model_update", id + TASK_MODELSET );
		
		// Show him the monster hands
		set_pev( id, pev_weaponmodel2, "" );
		set_pev( id, pev_viewmodel2, character_wmodel[key] ); 
	}
	
	return;
}	
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
