/*
 * Decompiled with CFR 0.152.
 */
package de.stuuupiiid.dungeonpack;

import de.stuuupiiid.dungeonpack.DungeonGenerator;
import de.stuuupiiid.dungeonpack.DungeonPack;
import de.stuuupiiid.dungeonpack.TreasureCake;
import de.stuuupiiid.dungeonpack.TreasureChest;
import de.stuuupiiid.dungeonpack.TreasureCrops;
import de.stuuupiiid.dungeonpack.TreasureEmpty;
import de.stuuupiiid.dungeonpack.TreasureLadder;
import de.stuuupiiid.dungeonpack.TreasureMagic;
import de.stuuupiiid.dungeonpack.TreasureMobSpawner;
import de.stuuupiiid.dungeonpack.TreasureNether;
import de.stuuupiiid.dungeonpack.TreasureOres;
import de.stuuupiiid.dungeonpack.TreasureRecord;
import java.util.Random;

public class TreasureBase
extends DungeonGenerator {
    @Override
    public boolean generate(Random random, int par1, int par2, int par3) {
        TreasureBase generator = this.getRoom(random, par1, par2, par3);
        generator.generate(random, par1, par2, par3);
        this.generateAktionRoom(random, par1, par2, par3);
        return true;
    }

    public TreasureBase getRoom(Random random, int par1, int par2, int par3) {
        TreasureBase generator = new TreasureMobSpawner();
        TreasureMobSpawner mobspawner = new TreasureMobSpawner();
        TreasureChest chest = new TreasureChest();
        TreasureOres ores = new TreasureOres();
        TreasureMagic magic = new TreasureMagic();
        TreasureCrops crops = new TreasureCrops();
        TreasureCake cake = new TreasureCake();
        TreasureNether nether = new TreasureNether();
        TreasureRecord record = new TreasureRecord();
        int random2 = random.nextInt(7);
        if (random2 == 0) {
            generator = mobspawner;
        } else if (random2 == 1) {
            generator = random.nextInt(6) == 2 ? record : chest;
        } else if (random2 == 2) {
            generator = ores;
        } else if (random2 == 3) {
            generator = random.nextInt(4) == 3 ? magic : mobspawner;
        } else if (random2 == 4) {
            generator = crops;
        } else if (random2 == 5) {
            generator = cake;
        } else if (random2 == 6) {
            generator = mobspawner;
        }
        if (generator == mobspawner && random.nextInt(4) == 2) {
            generator = nether;
        }
        return generator;
    }

    public boolean generateWalls(Random random, int par1, int par2, int par3) {
        int var5;
        int var4;
        for (var4 = -4; var4 < 5; ++var4) {
            for (var5 = -4; var5 < 5; ++var5) {
                for (int v = 0; v < 4; ++v) {
                    this.addAir(par1 + var4, par2 + v, par3 + var5);
                }
            }
        }
        this.addBlock(par1, par2 + 3, par3, 89);
        for (var4 = -5; var4 < 6; ++var4) {
            for (var5 = -5; var5 < 6; ++var5) {
                this.addBlockAndMetadata(par1 + var4, par2 - 1, par3 + var5, 98, this.data(random));
                this.addBlockAndMetadata(par1 + var4, par2 + 4, par3 + var5, 98, this.data(random));
            }
            for (var5 = -1; var5 < 5; ++var5) {
                this.addBlockAndMetadata(par1 + 5, par2 + var5, par3 + var4, 98, this.data(random));
                this.addBlockAndMetadata(par1 - 5, par2 + var5, par3 + var4, 98, this.data(random));
                this.addBlockAndMetadata(par1 + var4, par2 + var5, par3 + 5, 98, this.data(random));
                this.addBlockAndMetadata(par1 + var4, par2 + var5, par3 - 5, 98, this.data(random));
            }
        }
        for (var4 = -1; var4 < 2; ++var4) {
            for (var5 = 0; var5 < 3; ++var5) {
                this.addAir(par1 + 5, par2 + var5, par3 + var4);
                this.addAir(par1 - 5, par2 + var5, par3 + var4);
                this.addAir(par1 + var4, par2 + var5, par3 + 5);
                this.addAir(par1 + var4, par2 + var5, par3 - 5);
            }
        }
        return true;
    }

    public boolean generateAktionRoom(Random random, int par1, int par2, int par3) {
        int height = DungeonPack.instance.treasureHeight;
        int size = DungeonPack.instance.treasureWidth;
        int ladderc = 0;
        for (int var1 = 0; var1 < size; ++var1) {
            int par4 = par1;
            int par5 = par2;
            int par6 = par3;
            for (int var2 = 0; var2 < size; ++var2) {
                par4 = random.nextBoolean() ? (par4 += 10) : (par4 -= 10);
                par6 = random.nextBoolean() ? (par6 += 10) : (par6 -= 10);
                if (this.getBlock(par4, par5 + 3, par6) != 89) {
                    this.getRoom(random, par4, par5, par6).generate(random, par4, par5, par6);
                }
                int v1 = random.nextInt(4);
                TreasureEmpty rooom = new TreasureEmpty();
                TreasureLadder ladder = new TreasureLadder();
                if (this.getBlock(par4, par2 + 3, par6 + 10) != 89) {
                    if (ladderc == 0 && par2 + 5 <= height && v1 == 0) {
                        ladder.generate(random, par4, par2, par6 + 10);
                        ++ladderc;
                    } else {
                        rooom.generate(random, par4, par2, par6 + 10);
                    }
                }
                if (this.getBlock(par4, par2 + 3, par6 - 10) != 89) {
                    if (ladderc == 0 && par2 + 5 <= height && v1 == 1) {
                        ladder.generate(random, par4, par2, par6 - 10);
                        ++ladderc;
                    } else {
                        rooom.generate(random, par4, par2, par6 - 10);
                    }
                }
                if (this.getBlock(par4 + 10, par2 + 3, par6) != 89) {
                    if (ladderc == 0 && par2 + 5 <= height && v1 == 2) {
                        ladder.generate(random, par4 + 10, par2, par6);
                        ++ladderc;
                    } else {
                        rooom.generate(random, par4 + 10, par2, par6);
                    }
                }
                if (this.getBlock(par4 - 10, par2 + 3, par6) == 89) continue;
                if (ladderc == 0 && par2 + 5 <= height && v1 == 3) {
                    ladder.generate(random, par4 - 10, par2, par6);
                    ++ladderc;
                    continue;
                }
                rooom.generate(random, par4 - 10, par2, par6);
            }
        }
        return true;
    }

    protected int data(Random random) {
        int v1 = random.nextInt(6);
        return v1 != 0 && v1 != 1 ? (v1 == 2 ? 2 : (v1 == 3 ? 3 : 0)) : 1;
    }
}

