/*
 * Decompiled with CFR 0.152.
 */
package vazkii.heraldry.content;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.heraldry.content.ItemHeraldry;
import vazkii.heraldry.content.TileEntityBanner;
import vazkii.heraldry.core.data.CrestData;
import vazkii.heraldry.core.proxy.CommonProxy;

public class BlockHeraldry
extends BlockContainer {
    public BlockHeraldry() {
        super(Material.field_151575_d);
        this.func_149711_c(0.2f);
        this.func_149752_b(0.2f);
        this.func_149663_c("blockHeraldry");
    }

    public void func_149651_a(IIconRegister p_149651_1_) {
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileEntity tile = par1World.func_147438_o(par2, par3, par4);
        ItemStack stack = par5EntityPlayer.func_71045_bC();
        if (tile != null && tile instanceof TileEntityBanner && !par1World.field_72995_K) {
            boolean holding = stack != null;
            TileEntityBanner banner = (TileEntityBanner)tile;
            if (!holding && par5EntityPlayer.func_70093_af()) {
                banner.locked = !banner.locked;
                par5EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Banner " + (banner.locked ? "Locked" : "Unlocked") + "."));
            }
            if (holding && stack.func_77973_b() == CommonProxy.itemHeraldry && stack.func_77960_j() == 0) {
                if (banner.locked) {
                    par5EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText("This banner is locked. Shift-Right click with an empty hand to unlock it."));
                } else {
                    CrestData data = ItemHeraldry.readCrestData(stack);
                    NBTTagCompound cmp = new NBTTagCompound();
                    data.writeToCmp(cmp);
                    banner.data = data;
                    par1World.func_147471_g(par2, par3, par4);
                }
            }
        }
        return true;
    }

    public int func_149645_b() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return Blocks.field_150344_f.func_149691_a(0, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        if (BlockHeraldry.isHanging(meta)) {
            float thickness = 0.1f;
            switch (BlockHeraldry.getOrientation(meta)) {
                case 0: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, thickness, 1.0f, 1.0f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, thickness);
                    break;
                }
                case 4: {
                    this.func_149676_a(1.0f - thickness, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 6: {
                    this.func_149676_a(0.0f, 0.0f, 1.0f - thickness, 1.0f, 1.0f, 1.0f);
                }
            }
            return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C - 0.5), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F), (double)((double)par4 + this.field_149757_G));
        }
        float o = 0.0625f;
        this.func_149676_a(o, 0.0f, o, 1.0f - o, 1.0f, 1.0f - o);
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F + 0.8), (double)((double)par4 + this.field_149757_G));
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return CommonProxy.itemHeraldry;
    }

    public int func_149692_a(int par1) {
        return BlockHeraldry.isHanging(par1) ? 2 : 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_149655_b(IBlockAccess par1iBlockAccess, int par2, int par3, int par4) {
        return true;
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        if (!this.func_149718_j(par1World, par2, par3, par4)) {
            this.func_149697_b(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
            par1World.func_147468_f(par2, par3, par4);
        }
    }

    public boolean func_149718_j(World par1World, int par2, int par3, int par4) {
        boolean canStay = true;
        int meta = par1World.func_72805_g(par2, par3, par4);
        boolean hanging = BlockHeraldry.isHanging(meta);
        if (hanging) {
            canStay = par1World.func_147437_c(par2, par3 - 1, par4);
            if (canStay) {
                switch (BlockHeraldry.getOrientation(meta)) {
                    case 0: {
                        canStay = par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST, false);
                        break;
                    }
                    case 2: {
                        canStay = par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH, false);
                        break;
                    }
                    case 4: {
                        canStay = par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST, false);
                        break;
                    }
                    default: {
                        canStay = par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH, false);
                        break;
                    }
                }
            }
        } else {
            canStay = par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP, false) && par1World.func_147437_c(par2, par3 + 1, par4);
        }
        return canStay;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(CommonProxy.itemHeraldry, 1, BlockHeraldry.isHanging(world.func_72805_g(x, y, z)) ? 2 : 1);
    }

    public static boolean isHanging(int meta) {
        return meta >= 8;
    }

    public static int getOrientation(int meta) {
        return BlockHeraldry.isHanging(meta) ? meta - 8 : meta;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBanner();
    }
}

