/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.content.BOPCBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockBOPSlab
extends BlockSlab {
    private static final String[] woodTypes = new String[]{"sacredoak", "cherry", "dark", "fir", "holy", "magic", "mangrove", "palm", "redwood", "willow", "pine", "hell_bark", "jacaranda", "mahogany"};
    private static final String[] rockTypes = new String[]{"mudbrick"};
    private IIcon[] textures;
    private final SlabCategory category;

    public BlockBOPSlab(boolean isDoubleSlab, Material material, SlabCategory cat) {
        super(isDoubleSlab, material);
        this.category = cat;
        if (material == Material.field_151575_d) {
            this.func_149711_c(2.0f);
            this.func_149752_b(5.0f);
            this.func_149672_a(Block.field_149766_f);
        } else if (material == Material.field_151576_e) {
            this.func_149672_a(Block.field_149780_i);
        }
        if (!isDoubleSlab) {
            this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
        }
        this.field_149783_u = true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (this.category == SlabCategory.STONE) {
            this.textures = new IIcon[rockTypes.length];
            for (int i = 0; i < rockTypes.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:" + rockTypes[i]);
            }
        } else {
            this.textures = new IIcon[woodTypes.length];
            for (int i = 0; i < woodTypes.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:plank_" + woodTypes[i]);
            }
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.category == SlabCategory.STONE) {
            return this.textures[this.getRockType(meta)];
        }
        return this.textures[this.getWoodType(meta)];
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        int max = 0;
        if (this.category == SlabCategory.WOOD1) {
            max = 8;
        } else if (this.category == SlabCategory.WOOD2) {
            max = 5;
        } else if (this.category == SlabCategory.STONE) {
            max = 1;
        }
        for (int i = 0; i < max; ++i) {
            list.add(new ItemStack(block, 1, i));
        }
    }

    public String func_150002_b(int meta) {
        if (this.category == SlabCategory.STONE) {
            return rockTypes[this.getRockType(meta)] + "Slab";
        }
        return woodTypes[this.getWoodType(meta)] + "Slab";
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (this.field_150004_a) {
            if (this == BOPCBlocks.woodenDoubleSlab1) {
                return Item.func_150898_a((Block)BOPCBlocks.woodenSingleSlab1);
            }
            if (this == BOPCBlocks.woodenDoubleSlab2) {
                return Item.func_150898_a((Block)BOPCBlocks.woodenSingleSlab2);
            }
            return Item.func_150898_a((Block)BOPCBlocks.stoneSingleSlab);
        }
        return Item.func_150898_a((Block)this);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float hardness = this.field_149782_v;
        if (this.category == SlabCategory.STONE) {
            switch (BlockBOPSlab.getTypeFromMeta(meta)) {
                case 0: 
                case 3: {
                    hardness = 1.6f;
                    break;
                }
                case 1: 
                case 4: {
                    hardness = 1.1f;
                    break;
                }
                case 2: {
                    hardness = 1.0f;
                }
            }
        }
        return hardness;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        float resistance = this.field_149781_w;
        if (this.category == SlabCategory.STONE) {
            switch (BlockBOPSlab.getTypeFromMeta(meta)) {
                case 0: 
                case 3: {
                    resistance = 7.0f;
                    break;
                }
                case 1: 
                case 4: {
                    resistance = 7.5f;
                    break;
                }
                case 2: {
                    resistance = 2.0f;
                }
            }
        }
        return resistance / 5.0f;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        BlockBOPSlab block = !this.field_150004_a ? this : (this == BOPCBlocks.woodenDoubleSlab1 ? BOPCBlocks.woodenSingleSlab1 : (this == BOPCBlocks.woodenDoubleSlab2 ? BOPCBlocks.woodenSingleSlab2 : BOPCBlocks.stoneSingleSlab));
        return new ItemStack((Block)block, 1, world.func_72805_g(x, y, z));
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this, 2, meta);
    }

    private int getWoodType(int meta) {
        if ((meta = BlockBOPSlab.getTypeFromMeta(meta) + this.category.ordinal() * 8) < woodTypes.length) {
            return meta;
        }
        return 0;
    }

    private int getRockType(int meta) {
        if ((meta = BlockBOPSlab.getTypeFromMeta(meta)) < rockTypes.length) {
            return meta;
        }
        return 0;
    }

    private static int getTypeFromMeta(int meta) {
        return meta & 7;
    }

    public static enum SlabCategory {
        WOOD1,
        WOOD2,
        STONE;

    }
}

