/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.eventhandler.misc;

import biomesoplenty.common.utils.BOPLogger;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.util.UUIDTypeAdapter;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.resources.SkinManager;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.apache.logging.log4j.Level;

public class CapeEventHandler {
    private final String serverLocation = "https://raw.github.com/Glitchfiend/BiomesOPlenty/master/capes.txt";
    private final int timeout = 1000;
    private HashMap<String, String> cloaks = new HashMap();
    private ArrayList<AbstractClientPlayer> checkedPlayers = new ArrayList();
    public static CapeEventHandler instance;

    public CapeEventHandler() {
        this.buildCloakURLDatabase();
        instance = this;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPreRenderSpecials(RenderPlayerEvent.Specials.Pre event) {
        AbstractClientPlayer abstractClientPlayer;
        if (Loader.isModLoaded((String)"shadersmod")) {
            return;
        }
        if (event.entityPlayer instanceof AbstractClientPlayer && !this.checkedPlayers.contains(abstractClientPlayer = (AbstractClientPlayer)event.entityPlayer)) {
            this.checkedPlayers.add(abstractClientPlayer);
            SkinManager skinManager = Minecraft.func_71410_x().func_152342_ad();
            String uuid = UUIDTypeAdapter.fromUUID((UUID)abstractClientPlayer.func_110124_au());
            if (this.cloaks.containsKey(uuid)) {
                MinecraftProfileTexture profileTexture = new MinecraftProfileTexture(this.cloaks.get(uuid));
                skinManager.func_152789_a(profileTexture, MinecraftProfileTexture.Type.CAPE, (SkinManager.SkinAvailableCallback)abstractClientPlayer);
                event.renderCape = true;
            }
        }
    }

    public void buildCloakURLDatabase() {
        try {
            String str;
            URL url = new URL("https://raw.github.com/Glitchfiend/BiomesOPlenty/master/capes.txt");
            URLConnection con = url.openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            InputStream io = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(io));
            int linetracker = 1;
            while ((str = br.readLine()) != null) {
                if (!str.startsWith("--") && !str.isEmpty() && str.startsWith("*%")) {
                    if ((str = str.replace("*%", "")).contains(":")) {
                        String uuid = str.substring(0, str.indexOf(":"));
                        String link = str.substring(str.indexOf(":") + 1);
                        this.cloaks.put(uuid, link);
                    } else {
                        BOPLogger.log(Level.WARN, "[capes.txt] Syntax error on line " + linetracker + ": " + str, new Object[0]);
                    }
                }
                ++linetracker;
            }
            br.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

