/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.biome;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.BiomeFeatures;
import biomesoplenty.common.world.generation.IBOPWorldGenerator;
import biomesoplenty.common.world.generation.WorldGenFieldAssociation;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BOPBiomeDecorator<T extends BiomeFeatures>
extends BiomeDecorator {
    public T bopFeatures;

    public BOPBiomeDecorator(Class<T> biomeFeaturesClass) {
        try {
            this.bopFeatures = (BiomeFeatures)biomeFeaturesClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public void func_150512_a(World world, Random random, BiomeGenBase biome, int chunkX, int chunkZ) {
        if (this.field_76815_a != null) {
            return;
        }
        this.field_76815_a = world;
        this.field_76813_b = random;
        this.field_76814_c = chunkX;
        this.field_76811_d = chunkZ;
        this.func_150513_a(biome);
        this.field_76815_a = null;
        this.field_76813_b = null;
    }

    protected void func_150513_a(BiomeGenBase biome) {
        super.func_150513_a(biome);
        BOPBiome bopBiome = (BOPBiome)biome;
        for (String featureName : ((BiomeFeatures)this.bopFeatures).getFeatureNames()) {
            IBOPWorldGenerator worldGenerator;
            if (!featureName.equals("bopFlowersPerChunk") ? featureName.equals("bopGrassPerChunk") && !TerrainGen.decorate((World)this.field_76815_a, (Random)this.field_76813_b, (int)this.field_76814_c, (int)this.field_76811_d, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS) : !TerrainGen.decorate((World)this.field_76815_a, (Random)this.field_76813_b, (int)this.field_76814_c, (int)this.field_76811_d, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) continue;
            WorldGenFieldAssociation.WorldFeature worldFeature = WorldGenFieldAssociation.getAssociatedFeature(featureName);
            if (worldFeature == null || (worldGenerator = worldFeature.getBOPWorldGenerator()) == null) continue;
            worldGenerator.setupGeneration(this.field_76815_a, this.field_76813_b, bopBiome, featureName, this.field_76814_c, this.field_76811_d);
        }
    }

    public static <T extends WorldGenerator> T getRandomWeightedWorldGenerator(HashMap<T, ? extends Number> worldGeneratorMap) {
        double completeWeight = 0.0;
        for (Number number : worldGeneratorMap.values()) {
            completeWeight += Double.parseDouble(number.toString());
        }
        double random = Math.random() * completeWeight;
        double countWeight = 0.0;
        for (Map.Entry<T, Number> entry : worldGeneratorMap.entrySet()) {
            if (!((countWeight += Double.parseDouble(entry.getValue().toString())) >= random)) continue;
            return (T)((WorldGenerator)entry.getKey());
        }
        return null;
    }

    protected int nextInt(int i) {
        if (i <= 1) {
            return 0;
        }
        return this.field_76813_b.nextInt(i);
    }
}

