/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.api.content.BOPCItems;
import biomesoplenty.api.utils.BiomeUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockBOPGeneric
extends Block {
    private IIcon texture;
    private BlockType type;

    public BlockBOPGeneric(Material material, BlockType type) {
        super(material);
        this.setHarvestLevel("pickaxe", 3, 7);
        this.type = type;
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
        switch (type) {
            case ASH_STONE: {
                this.func_149711_c(1.0f);
                this.func_149672_a(Block.field_149780_i);
                break;
            }
            case CRAG_ROCK: {
                this.func_149711_c(1.0f);
                this.func_149672_a(Block.field_149769_e);
                break;
            }
            case DRIED_DIRT: {
                this.func_149711_c(0.1f);
                this.setHarvestLevel("pickaxe", 0);
                this.func_149672_a(Block.field_149780_i);
                break;
            }
            case HARD_DIRT: {
                this.func_149711_c(0.9f);
                this.func_149672_a(Block.field_149780_i);
                break;
            }
            case HARD_ICE: {
                this.func_149711_c(0.75f);
                this.func_149672_a(Block.field_149780_i);
                break;
            }
            case HARD_SAND: {
                this.func_149711_c(0.7f);
                this.setHarvestLevel("shovel", 0);
                this.func_149672_a(Block.field_149776_m);
                break;
            }
            case MUD_BRICK: {
                this.func_149711_c(1.0f);
                this.func_149752_b(2.0f);
                this.func_149672_a(Block.field_149780_i);
                break;
            }
            case BIOME_BLOCK: {
                this.func_149711_c(0.6f);
                this.func_149672_a(field_149778_k);
                break;
            }
            case CRYSTAL: {
                this.func_149711_c(0.15f);
                this.func_149752_b(5.0f);
                this.func_149715_a(1.0f);
                this.func_149672_a(Block.field_149778_k);
                break;
            }
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        switch (this.type) {
            case ASH_STONE: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:ashstone");
                break;
            }
            case CRAG_ROCK: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:cragrock");
                break;
            }
            case DRIED_DIRT: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:drieddirt");
                break;
            }
            case HARD_DIRT: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:harddirt");
                break;
            }
            case HARD_ICE: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:hardice");
                break;
            }
            case HARD_SAND: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:hardsand");
                break;
            }
            case MUD_BRICK: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:mudbrick");
                break;
            }
            case BIOME_BLOCK: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:biomeblock");
                break;
            }
            case CRYSTAL: {
                this.texture = iconRegister.func_94245_a("biomesoplenty:crystal");
                break;
            }
        }
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        switch (this.type) {
            case CRYSTAL: {
                return BOPCItems.misc;
            }
        }
        return super.func_149650_a(metadata, random, fortune);
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int fortune) {
        switch (this.type) {
            case BIOME_BLOCK: {
                for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                    if (biome == null || BiomeUtils.areBiomesEqual(biome, BOPCBiomes.boneyard) || BiomeUtils.areBiomesEqual(biome, BOPCBiomes.visceralHeap) || BiomeUtils.areBiomesEqual(biome, BOPCBiomes.undergarden) || BiomeUtils.areBiomesEqual(biome, BOPCBiomes.corruptedSands) || BiomeUtils.areBiomesEqual(biome, BOPCBiomes.phantasmagoricInferno) || BiomeUtils.areBiomesEqual(biome, BOPCBiomes.lushRiver) || BiomeUtils.areBiomesEqual(biome, BOPCBiomes.dryRiver) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_76787_r) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_150577_O) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_150576_N) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_76776_l) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_76777_m) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_76778_j) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_76781_i) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_76779_k) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_76771_b) || BiomeUtils.areBiomesEqual(biome, BiomeGenBase.field_150575_M)) continue;
                    ItemStack biomeEssence = new ItemStack(BOPCItems.biomeEssence);
                    biomeEssence.func_77982_d(new NBTTagCompound());
                    biomeEssence.func_77978_p().func_74768_a("biomeID", biome.field_76756_M);
                    if (world.field_73012_v.nextInt(75) != 0) continue;
                    this.func_149642_a(world, x, y, z, biomeEssence);
                }
                break;
            }
            default: {
                super.func_149690_a(world, x, y, z, metadata, chance, fortune);
            }
        }
    }

    public int func_149692_a(int meta) {
        switch (this.type) {
            case CRYSTAL: {
                return 4;
            }
        }
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        switch (this.type) {
            case CRYSTAL: {
                return 4;
            }
        }
        return 1;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.texture;
    }

    public static enum BlockType {
        ASH_STONE,
        HARD_SAND,
        HARD_DIRT,
        HARD_ICE,
        DRIED_DIRT,
        CRAG_ROCK,
        MUD_BRICK,
        BIOME_BLOCK,
        CRYSTAL;

    }
}

