/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.client.gui;

import com.google.common.base.Strings;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.UUID;
import kihira.foxlib.client.gui.GuiBaseScreen;
import kihira.foxlib.client.gui.GuiList;
import kihira.foxlib.client.gui.GuiSlider;
import kihira.foxlib.client.gui.IListCallback;
import kihira.foxlib.client.gui.ISliderCallback;
import kihira.tails.client.ClientEventHandler;
import kihira.tails.client.FakeEntity;
import kihira.tails.client.gui.GuiExport;
import kihira.tails.client.texture.TextureHelper;
import kihira.tails.common.TailInfo;
import kihira.tails.common.Tails;
import kihira.tails.common.network.TailInfoMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiEditTail
extends GuiBaseScreen
implements ISliderCallback,
IListCallback {
    private float yaw = 0.0f;
    private float pitch = 0.0f;
    private int currTintEdit = 0;
    private int currTintColour = 0xFFFFFF;
    private GuiTextField hexText;
    private GuiSlider rSlider;
    private GuiSlider gSlider;
    private GuiSlider bSlider;
    private GuiButton tintReset;
    private GuiButton tintSave;
    private GuiSlider rotYawSlider;
    private ScaledResolution scaledRes;
    private int previewWindowLeft;
    private int previewWindowRight;
    private int previewWindowBottom;
    private int editPaneTop;
    private TailInfo tailInfo;
    private final TailInfo originalTailInfo;
    private GuiList tailList;
    private FakeEntity fakeEntity;
    GuiBaseScreen.GuiButtonToggle livePreviewButton;

    public GuiEditTail() {
        TailInfo tailInfo = Tails.localPlayerTailInfo == null ? new TailInfo(Minecraft.func_71410_x().field_71439_g.getPersistentID(), false, 0, 0, -65536, -16711936, -16776961, null) : Tails.localPlayerTailInfo;
        this.originalTailInfo = tailInfo.deepCopy();
        this.tailInfo = this.originalTailInfo.deepCopy();
        this.fakeEntity = new FakeEntity((World)Minecraft.func_71410_x().field_71441_e);
    }

    public void func_73866_w_() {
        int previewWindowEdgeOffset;
        this.scaledRes = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        this.previewWindowLeft = previewWindowEdgeOffset = 110;
        this.previewWindowRight = this.field_146294_l - previewWindowEdgeOffset;
        this.previewWindowBottom = this.field_146295_m - 55;
        this.editPaneTop = this.field_146295_m - 125;
        int topOffset = 20;
        for (int i = 2; i <= 4; ++i) {
            this.field_146292_n.add(new GuiButton(i, this.previewWindowRight + 30, topOffset, 40, 20, "Edit"));
            topOffset += 35;
        }
        this.hexText = new GuiTextField(this.field_146289_q, this.previewWindowRight + 30, this.editPaneTop + 20, 73, 10);
        this.hexText.func_146203_f(6);
        this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
        this.rSlider = new GuiSlider((ISliderCallback)this, 5, this.previewWindowRight + 5, this.editPaneTop + 35, 100, 0.0f, 255.0f, 0.0f);
        this.field_146292_n.add(this.rSlider);
        this.gSlider = new GuiSlider((ISliderCallback)this, 6, this.previewWindowRight + 5, this.editPaneTop + 55, 100, 0.0f, 255.0f, 0.0f);
        this.field_146292_n.add(this.gSlider);
        this.bSlider = new GuiSlider((ISliderCallback)this, 7, this.previewWindowRight + 5, this.editPaneTop + 75, 100, 0.0f, 255.0f, 0.0f);
        this.field_146292_n.add(this.bSlider);
        this.tintReset = new GuiButton(8, this.previewWindowRight + 5, this.field_146295_m - 25, 50, 20, "Reset");
        this.field_146292_n.add(this.tintReset);
        this.tintSave = new GuiButton(9, this.previewWindowRight + 55, this.field_146295_m - 25, 50, 20, "Save");
        this.field_146292_n.add(this.tintSave);
        ArrayList<TailEntry> tailList = new ArrayList<TailEntry>();
        tailList.add(new TailEntry(new TailInfo(UUID.fromString("18040390-23b0-11e4-8c21-0800200c9a66"), false, 0, 0, -65536, -16711936, -16776961, null)));
        for (int type = 0; type < ClientEventHandler.tailTypes.length; ++type) {
            for (int subType = 0; subType <= ClientEventHandler.tailTypes[type].getAvailableSubTypes(); ++subType) {
                TailInfo tailInfo = new TailInfo(UUID.fromString("18040390-23b0-11e4-8c21-0800200c9a66"), true, type, subType, -65536, -16711936, -16776961, null);
                tailList.add(new TailEntry(tailInfo));
            }
        }
        this.tailList = new GuiList((IListCallback)this, this.previewWindowLeft, this.field_146295_m, 0, this.field_146295_m, 55, tailList);
        this.selectDefaultListEntry();
        this.rotYawSlider = new GuiSlider((ISliderCallback)this, 1, this.previewWindowLeft + this.scaledRes.func_78326_a() / 60, this.previewWindowBottom + 5, this.field_146294_l - previewWindowEdgeOffset * 2 - this.scaledRes.func_78326_a() / 30, -180.0f, 180.0f, (float)((int)this.yaw));
        this.field_146292_n.add(this.rotYawSlider);
        String s = StatCollector.func_74838_a((String)"gui.button.livepreview");
        this.livePreviewButton = new GuiBaseScreen.GuiButtonToggle((GuiBaseScreen)this, 11, this.previewWindowLeft + 5, this.field_146295_m - 25, this.field_146289_q.func_78256_a(s) + 7, 20, s, this.scaledRes.func_78326_a() / 2, new String[]{StatCollector.func_74838_a((String)"gui.button.livepreview.0.tooltip")});
        this.field_146292_n.add(this.livePreviewButton);
        this.livePreviewButton.field_146124_l = false;
        this.field_146292_n.add(new GuiButton(12, this.previewWindowRight - 83, this.field_146295_m - 25, 40, 20, "Reset"));
        this.field_146292_n.add(new GuiButton(13, this.previewWindowRight - 43, this.field_146295_m - 25, 40, 20, "Done"));
        this.field_146292_n.add(new GuiBaseScreen.GuiButtonTooltip((GuiBaseScreen)this, 14, this.field_146294_l / 2 - 20, this.field_146295_m - 25, 40, 20, StatCollector.func_74838_a((String)"gui.button.export"), this.scaledRes.func_78326_a() / 3, new String[]{StatCollector.func_74838_a((String)"gui.button.export.0.tooltip")}));
        this.refreshTintPane();
    }

    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.field_73735_i = -1000.0f;
        this.func_73733_a(0, 0, this.previewWindowLeft, this.field_146295_m, -872415232, -872415232);
        this.func_73733_a(this.previewWindowLeft, 0, this.previewWindowRight, this.previewWindowBottom, -301989888, -301989888);
        this.func_73733_a(this.previewWindowRight, 0, this.field_146294_l, this.field_146295_m, -872415232, -872415232);
        this.func_73733_a(this.previewWindowLeft, this.previewWindowBottom, this.previewWindowRight, this.field_146295_m, -587202560, -587202560);
        int topOffset = 10;
        for (int tint = 1; tint <= 3; ++tint) {
            String s = "Tint " + tint;
            this.field_146289_q.func_78276_b(s, this.previewWindowRight + 5, topOffset, 0xFFFFFF);
            this.func_73733_a(this.previewWindowRight + 5, topOffset + 10, this.previewWindowRight + 25, topOffset + 30, this.tailInfo.tints[tint - 1], this.tailInfo.tints[tint - 1]);
            topOffset += 35;
        }
        if (this.currTintEdit > 0) {
            this.func_73730_a(this.previewWindowRight, this.field_146294_l, this.editPaneTop, -16777216);
            this.field_146289_q.func_78276_b("Editing Tint " + this.currTintEdit, this.previewWindowRight + 5, this.editPaneTop + 5, 0xFFFFFF);
            this.field_146289_q.func_78276_b("Hex:", this.previewWindowRight + 5, this.editPaneTop + 21, 0xFFFFFF);
            this.hexText.func_146194_f();
        }
        this.drawEntity(this.field_146294_l / 2, this.previewWindowBottom / 2 + this.scaledRes.func_78328_b() / 4, this.scaledRes.func_78328_b() / 4, this.yaw, this.pitch, (EntityLivingBase)this.field_146297_k.field_71439_g);
        this.field_73735_i = 0.0f;
        this.tailList.func_148128_a(mouseX, mouseY, p_73863_3_);
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
        for (Object obj : this.field_146292_n) {
            if (!(obj instanceof GuiBaseScreen.GuiButtonTooltip) || !((GuiBaseScreen.GuiButtonTooltip)obj).func_146115_a()) continue;
            ((GuiBaseScreen.GuiButtonTooltip)obj).func_146111_b(mouseX, mouseY);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            this.yaw = this.rotYawSlider.currentValue;
            MathHelper.func_76131_a((float)this.yaw, (float)-180.0f, (float)180.0f);
        } else if (button.field_146127_k >= 2 && button.field_146127_k <= 4) {
            this.currTintEdit = button.field_146127_k - 1;
            this.currTintColour = this.tailInfo.tints[this.currTintEdit - 1] & 0xFFFFFF;
            this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
            this.refreshTintPane();
        } else if (button.field_146127_k == 8) {
            this.currTintColour = this.originalTailInfo.tints[this.currTintEdit - 1] & 0xFFFFFF;
            this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
            this.refreshTintPane();
        } else if (button.field_146127_k == 9) {
            this.tailInfo.tints[this.currTintEdit - 1] = this.currTintColour | 0xFF000000;
            this.updateTailInfo();
        } else if (button.field_146127_k == 12) {
            this.tailInfo = this.originalTailInfo.deepCopy();
            this.selectDefaultListEntry();
            this.currTintEdit = 0;
            this.refreshTintPane();
            this.updateTailInfo();
        } else if (button.field_146127_k == 13) {
            this.updateTailInfo();
            Tails.setLocalPlayerTailInfo(this.tailInfo);
            Tails.proxy.addTailInfo(this.tailInfo.uuid, this.tailInfo);
            Tails.networkWrapper.sendToServer((IMessage)new TailInfoMessage(this.tailInfo, false));
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 14) {
            this.updateTailInfo();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiExport(this, this.tailInfo));
        }
    }

    protected void func_73869_a(char letter, int keyCode) {
        this.hexText.func_146201_a(letter, keyCode);
        try {
            if (!Strings.isNullOrEmpty((String)this.hexText.func_146179_b())) {
                this.currTintColour = Integer.parseInt(this.hexText.func_146179_b(), 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.refreshTintPane();
        super.func_73869_a(letter, keyCode);
    }

    protected void func_73864_a(int p_73864_1_, int p_73864_2_, int p_73864_3_) {
        super.func_73864_a(p_73864_1_, p_73864_2_, p_73864_3_);
        this.hexText.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
    }

    public void func_146281_b() {
        for (GuiListExtended.IGuiListEntry entry : this.tailList.getEntries()) {
            TailEntry tailEntry = (TailEntry)entry;
            tailEntry.tailInfo.setTexture(null);
        }
        Tails.proxy.addTailInfo(this.field_146297_k.field_71439_g.getPersistentID(), Tails.localPlayerTailInfo);
    }

    private void refreshTintPane() {
        this.hexText.func_146193_g(this.currTintColour);
        this.rSlider.setCurrentValue((float)(this.currTintColour >> 16 & 0xFF));
        this.rSlider.packedFGColour = (0xFF | (int)this.rSlider.currentValue) << 16;
        this.gSlider.setCurrentValue((float)(this.currTintColour >> 8 & 0xFF));
        this.gSlider.packedFGColour = (0xFF | (int)this.gSlider.currentValue) << 8;
        this.bSlider.setCurrentValue((float)(this.currTintColour & 0xFF));
        this.bSlider.packedFGColour = 0xFF | (int)this.bSlider.currentValue;
        if (this.currTintEdit > 0) {
            this.tintSave.field_146125_m = true;
            this.tintReset.field_146125_m = true;
            this.bSlider.field_146125_m = true;
            this.gSlider.field_146125_m = true;
            this.rSlider.field_146125_m = true;
        } else {
            this.tintSave.field_146125_m = false;
            this.tintReset.field_146125_m = false;
            this.bSlider.field_146125_m = false;
            this.gSlider.field_146125_m = false;
            this.rSlider.field_146125_m = false;
        }
        if (!this.livePreviewButton.field_146124_l) {
            this.updateTailInfo();
        }
    }

    private void drawEntity(int x, int y, int scale, float yaw, float pitch, EntityLivingBase entity) {
        float prevHeadYaw = entity.field_70759_as;
        float prevRotYaw = entity.field_70177_z;
        float prevRotPitch = entity.field_70125_A;
        ItemStack prevItemStack = entity.func_70694_bm();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)-10.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)entity.field_70129_M, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        entity.field_70759_as = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70125_A = 0.0f;
        entity.field_70761_aq = 0.0f;
        entity.func_70095_a(false);
        entity.func_70062_b(0, null);
        RenderHelper.func_74519_b();
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        entity.field_70759_as = prevHeadYaw;
        entity.field_70177_z = prevRotYaw;
        entity.field_70125_A = prevRotPitch;
        entity.func_70062_b(0, prevItemStack);
        GL11.glPopMatrix();
    }

    private void renderTail(int x, int y, int scale, TailInfo tailInfo) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)10.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        ClientEventHandler.tailTypes[tailInfo.typeid].render((EntityLivingBase)this.fakeEntity, tailInfo, 0.0f);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopMatrix();
    }

    public boolean onValueChange(GuiSlider slider, float oldValue, float newValue) {
        if (slider == this.rotYawSlider) {
            this.yaw = newValue;
        }
        if (slider == this.rSlider || slider == this.gSlider || slider == this.bSlider) {
            int colour = 0;
            colour |= (int)this.rSlider.currentValue << 16;
            colour |= (int)this.gSlider.currentValue << 8;
            this.currTintColour = colour |= (int)this.bSlider.currentValue;
            this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
            this.refreshTintPane();
        }
        return true;
    }

    void updateTailInfo() {
        UUID uuid = this.field_146297_k.field_71439_g.getPersistentID();
        TailEntry tailEntry = (TailEntry)this.tailList.func_148180_b(this.tailList.getCurrrentIndex());
        if (this.currTintEdit > 0) {
            this.tailInfo.tints[this.currTintEdit - 1] = this.currTintColour | 0xFF000000;
        }
        this.tailInfo = new TailInfo(uuid, tailEntry.tailInfo.hastail, tailEntry.tailInfo.typeid, tailEntry.tailInfo.subid, this.tailInfo.tints, null);
        this.tailInfo.setTexture(TextureHelper.generateTexture(this.tailInfo));
        this.tailInfo.needsTextureCompile = false;
        Tails.proxy.addTailInfo(uuid, this.tailInfo);
    }

    private void selectDefaultListEntry() {
        for (GuiListExtended.IGuiListEntry entry : this.tailList.getEntries()) {
            TailEntry tailEntry = (TailEntry)entry;
            if (tailEntry.tailInfo.typeid != this.originalTailInfo.typeid || tailEntry.tailInfo.subid != this.originalTailInfo.subid) continue;
            this.tailList.setCurrrentIndex(this.tailList.getEntries().indexOf(tailEntry));
        }
    }

    public boolean onEntrySelected(GuiList guiList, int index, GuiListExtended.IGuiListEntry entry) {
        this.updateTailInfo();
        return true;
    }

    public class TailEntry
    implements GuiListExtended.IGuiListEntry {
        public final TailInfo tailInfo;

        public TailEntry(TailInfo tailInfo) {
            this.tailInfo = tailInfo;
        }

        public void func_148279_a(int p_148279_1_, int x, int y, int listWidth, int p_148279_5_, Tessellator tessellator, int p_148279_7_, int p_148279_8_, boolean p_148279_9_) {
            if (this.tailInfo.hastail) {
                GuiEditTail.this.renderTail(GuiEditTail.this.previewWindowLeft - 25, y - 25, 50, this.tailInfo);
                GuiEditTail.this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)ClientEventHandler.tailTypes[this.tailInfo.typeid].getUnlocalisedName(this.tailInfo.subid)), 5, y + ((GuiEditTail)GuiEditTail.this).tailList.field_148149_f / 2 - 5, 0xFFFFFF);
            } else {
                GuiEditTail.this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"tail.none.name"), 5, y + ((GuiEditTail)GuiEditTail.this).tailList.field_148149_f / 2 - 5, 0xFFFFFF);
            }
        }

        public boolean func_148278_a(int p_148278_1_, int p_148278_2_, int p_148278_3_, int p_148278_4_, int p_148278_5_, int p_148278_6_) {
            return true;
        }

        public void func_148277_b(int p_148277_1_, int p_148277_2_, int p_148277_3_, int p_148277_4_, int p_148277_5_, int p_148277_6_) {
        }
    }
}

