/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.client.texture;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.UUID;
import kihira.tails.client.ClientEventHandler;
import kihira.tails.client.render.RenderTail;
import kihira.tails.client.texture.TripleTintTexture;
import kihira.tails.common.TailInfo;
import kihira.tails.common.Tails;
import kihira.tails.common.network.TailInfoMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.Point;

@SideOnly(value=Side.CLIENT)
public class TextureHelper {
    private static RenderTail[] tailTypes = ClientEventHandler.tailTypes;
    private static final Point switch1Pixel = new Point(56, 16);
    private static final Point switch2Pixel = new Point(57, 16);
    private static final Point dataPixel = new Point(58, 16);
    private static final Point tint1Pixel = new Point(59, 16);
    private static final Point tint2Pixel = new Point(60, 16);
    private static final Point tint3Pixel = new Point(61, 16);
    private static final int switch1Colour = -61200;
    private static final int switch2Colour = -4661120;

    public static void buildPlayerInfo(EntityPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        GameProfile profile = player.func_146103_bH();
        UUID uuid = profile.getId();
        Map map = mc.func_152342_ad().func_152788_a(profile);
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            ResourceLocation skinloc = mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            ITextureObject skintex = mc.func_110434_K().func_110581_b(skinloc);
            if (skintex instanceof ThreadDownloadImageData) {
                ThreadDownloadImageData imagedata = (ThreadDownloadImageData)skintex;
                BufferedImage image = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imagedata, (String[])new String[]{"bufferedImage", "field_110560_d", "bpj.g"});
                if (image == null) {
                    return;
                }
                int scol1 = image.getRGB(switch1Pixel.getX(), switch1Pixel.getY());
                int scol2 = image.getRGB(switch2Pixel.getX(), switch2Pixel.getY());
                TailInfo tailInfo = scol1 == -61200 && scol2 == -4661120 ? TextureHelper.buildTailInfoFromSkin(uuid, image) : new TailInfo(uuid, false, 0, 0, 0, 0, 0, null);
                Tails.proxy.addTailInfo(uuid, tailInfo);
                if (player == Minecraft.func_71410_x().field_71439_g) {
                    Tails.setLocalPlayerTailInfo(tailInfo);
                    Tails.networkWrapper.sendToServer((IMessage)new TailInfoMessage(tailInfo, false));
                }
            }
        }
    }

    public static BufferedImage writeTailInfoToSkin(TailInfo tailInfo, AbstractClientPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        GameProfile profile = player.func_146103_bH();
        Map map = mc.func_152342_ad().func_152788_a(profile);
        BufferedImage image = null;
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            ResourceLocation skinloc = mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            ITextureObject skintex = mc.func_110434_K().func_110581_b(skinloc);
            if (skintex instanceof ThreadDownloadImageData) {
                ThreadDownloadImageData imagedata = (ThreadDownloadImageData)skintex;
                image = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imagedata, (String[])new String[]{"bufferedImage", "field_110560_d", "bpj.g"});
                if (image == null) {
                    return null;
                }
                image.setRGB(switch1Pixel.getX(), switch1Pixel.getY(), -61200);
                image.setRGB(switch2Pixel.getX(), switch2Pixel.getY(), -4661120);
                int dataColour = 255;
                dataColour |= tailInfo.typeid << 16;
                dataColour |= tailInfo.subid << 8;
                image.setRGB(dataPixel.getX(), dataPixel.getY(), dataColour |= tailInfo.textureID);
                image.setRGB(tint1Pixel.getX(), tint1Pixel.getY(), tailInfo.tints[0]);
                image.setRGB(tint2Pixel.getX(), tint2Pixel.getY(), tailInfo.tints[1]);
                image.setRGB(tint3Pixel.getX(), tint3Pixel.getY(), tailInfo.tints[2]);
            }
        }
        return image;
    }

    private static TailInfo buildTailInfoFromSkin(UUID id, BufferedImage skin) {
        int data = skin.getRGB(dataPixel.getX(), dataPixel.getY());
        int typeid = data >> 16 & 0xFF;
        typeid = typeid >= tailTypes.length ? 0 : typeid;
        RenderTail type = tailTypes[typeid];
        String[] textures = type.getTextureNames();
        int subtype = data >> 8 & 0xFF;
        int textureid = data & 0xFF;
        textureid = textureid >= textures.length ? 0 : textureid;
        int tint1 = skin.getRGB(tint1Pixel.getX(), tint1Pixel.getY());
        int tint2 = skin.getRGB(tint2Pixel.getX(), tint2Pixel.getY());
        int tint3 = skin.getRGB(tint3Pixel.getX(), tint3Pixel.getY());
        ResourceLocation tailtexture = TextureHelper.generateTexture(id, typeid, subtype, textureid, new int[]{tint1, tint2, tint3});
        return new TailInfo(id, true, typeid, subtype, tint1, tint2, tint3, tailtexture);
    }

    public static ResourceLocation generateTexture(UUID id, int typeid, int subid, int textureID, int[] tints) {
        ResourceLocation tailtexture = new ResourceLocation("tails_" + id.toString() + "_" + typeid + "_" + subid + "_" + textureID + "_" + tints[0] + "_" + tints[1] + "_" + tints[2]);
        RenderTail tail = tailTypes[typeid];
        String texturePath = "texture/" + tail.getTextureNames()[textureID] + ".png";
        Minecraft.func_71410_x().func_110434_K().func_110579_a(tailtexture, (ITextureObject)new TripleTintTexture("tails", texturePath, tints[0], tints[1], tints[2]));
        return tailtexture;
    }

    public static ResourceLocation generateTexture(TailInfo tailInfo) {
        return TextureHelper.generateTexture(tailInfo.uuid, tailInfo.typeid, tailInfo.subid, tailInfo.textureID, tailInfo.tints);
    }

    public static boolean needsBuild(EntityPlayer player) {
        return !Tails.proxy.hasTailInfo(player.getPersistentID()) && player.func_146103_bH().getProperties().containsKey((Object)"textures");
    }
}

