/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common.network;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import kihira.tails.common.TailInfo;
import kihira.tails.common.Tails;

public class TailInfoMessage
implements IMessage {
    private TailInfo tailInfo;
    private boolean shouldRemove;

    public TailInfoMessage() {
    }

    public TailInfoMessage(TailInfo tailInfo, boolean shouldRemove) {
        this.tailInfo = tailInfo;
        this.shouldRemove = shouldRemove;
    }

    public void fromBytes(ByteBuf buf) {
        String tailInfoJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            this.tailInfo = (TailInfo)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson(tailInfoJson, TailInfo.class);
        }
        catch (JsonSyntaxException e) {
            Tails.logger.warn((Object)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        String tailInfoJson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().toJson((Object)this.tailInfo);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tailInfoJson);
    }

    public static class TailInfoMessageHandler
    implements IMessageHandler<TailInfoMessage, IMessage> {
        public IMessage onMessage(TailInfoMessage message, MessageContext ctx) {
            if (message.tailInfo != null) {
                if (message.shouldRemove) {
                    Tails.proxy.removeTailInfo(((TailInfoMessage)message).tailInfo.uuid);
                } else {
                    Tails.proxy.addTailInfo(((TailInfoMessage)message).tailInfo.uuid, message.tailInfo);
                    if (ctx.side.isServer()) {
                        Tails.networkWrapper.sendToAll((IMessage)new TailInfoMessage(message.tailInfo, false));
                    }
                }
            }
            return null;
        }
    }
}

