/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import kihira.tails.common.TailInfo;
import kihira.tails.proxy.CommonProxy;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="Tails", name="Tails", version="$version", dependencies="required-after:foxlib@[0.4.0,)")
public class Tails {
    public static final String MOD_ID = "Tails";
    public static final Logger logger = LogManager.getLogger((String)"Tails");
    public static final SimpleNetworkWrapper networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("Tails");
    public static Configuration configuration;
    public static boolean hasRemote;
    @SidedProxy(clientSide="kihira.tails.proxy.ClientProxy", serverSide="kihira.tails.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static Tails instance;
    public static TailInfo localPlayerTailInfo;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        proxy.registerHandlers();
        proxy.registerMessages();
        if (e.getSide().isClient()) {
            configuration = new Configuration(e.getSuggestedConfigurationFile());
            this.loadConfig();
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MOD_ID)) {
            this.loadConfig();
        }
    }

    @NetworkCheckHandler
    public boolean checkRemoteVersions(Map<String, String> versions, Side side) {
        if (side.isClient() && versions.containsKey(MOD_ID)) {
            hasRemote = true;
        }
        return true;
    }

    public void loadConfig() {
        try {
            localPlayerTailInfo = (TailInfo)new Gson().fromJson(configuration.getString("Local Tail Info", "general", "Local Players tail info. Delete to remove tail. Do not try to edit manually", ""), TailInfo.class);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void setLocalPlayerTailInfo(TailInfo tailInfo) {
        localPlayerTailInfo = tailInfo;
        Property prop = configuration.get("general", "Local Tail Info", "");
        prop.comment = "Local Players tail info. Delete to remove tail. Do not try to edit manually";
        prop.set(new Gson().toJson((Object)localPlayerTailInfo));
        configuration.save();
    }
}

