/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common.network;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import kihira.tails.common.TailInfo;
import kihira.tails.common.Tails;
import net.minecraft.client.Minecraft;

public class TailMapMessage
implements IMessage {
    private Map<UUID, TailInfo> tailInfoMap;

    public TailMapMessage() {
    }

    public TailMapMessage(Map tailInfoMap) {
        this.tailInfoMap = tailInfoMap;
    }

    public void fromBytes(ByteBuf buf) {
        String tailInfoJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            this.tailInfoMap = (Map)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson(tailInfoJson, new TypeToken<Map<UUID, TailInfo>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            Tails.logger.warn((Object)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        String tailInfoJson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().toJson(this.tailInfoMap);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tailInfoJson);
    }

    public static class TailMapMessageHandler
    implements IMessageHandler<TailMapMessage, IMessage> {
        public IMessage onMessage(TailMapMessage message, MessageContext ctx) {
            for (Map.Entry entry : message.tailInfoMap.entrySet()) {
                if (Minecraft.func_71410_x().field_71439_g.getPersistentID() == entry.getKey()) continue;
                Tails.proxy.addTailInfo((UUID)entry.getKey(), (TailInfo)entry.getValue());
            }
            return null;
        }
    }
}

