/*
 * Decompiled with CFR 0.152.
 */
package epsilon.clickgui;

import epsilon.clickgui.Window;
import epsilon.init.RenderUtils;
import epsilon.init.font.Fonts;
import epsilon.utils.Value;
import java.text.DecimalFormat;

public class Slider {
    private Window window;
    private Value sliderValue;
    private int xPos;
    private int yPos;
    private float maxValue;
    private float minValue;
    private boolean shouldRound;
    public boolean dragging;
    public float dragX;
    public float lastDragX;
    private int drawSliderWidth;
    private int sliderWidth;

    public void dragSlider(int x) {
        this.dragX = (float)x - this.lastDragX;
    }

    public Slider(Window window, Value value, int x, int y) {
        this.window = window;
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = 10.0f;
        this.minValue = 0.0f;
        this.drawSliderWidth = 85;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public Slider(Window window, Value value, int x, int y, float maxValue) {
        this.window = window;
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = maxValue;
        this.minValue = 0.0f;
        this.drawSliderWidth = 85;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public Slider(Window window, Value value, int x, int y, float minValue, float maxValue, boolean shouldRound) {
        this.window = window;
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.drawSliderWidth = 85;
        this.shouldRound = shouldRound;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public void draw(int x) {
        if (this.dragging) {
            this.dragSlider(x);
        }
        if (this.dragX < 0.0f) {
            this.dragX = 0.0f;
        }
        if (this.dragX > (float)this.sliderWidth) {
            this.dragX = this.sliderWidth;
        }
        DecimalFormat format = new DecimalFormat(this.shouldRound ? "0" : "0.0");
        Fonts.tahoma18.drawString(String.valueOf(this.sliderValue.getName()) + ": " + format.format(this.sliderValue.getValue()), this.xPos + this.window.dragX, this.yPos - 3 + this.window.dragY, 0xFFFFFF);
        RenderUtils.drawHLine(this.xPos + this.window.dragX, this.xPos + this.drawSliderWidth + this.window.dragX, this.yPos + 12 + this.window.dragY, -12434878);
        RenderUtils.drawHLine(this.xPos + this.window.dragX, (float)this.xPos + this.dragX + (float)this.window.dragX, this.yPos + 12 + this.window.dragY, -13871707);
        if (this.dragging) {
            RenderUtils.drawBorderedRect(this.xPos + this.window.dragX + (int)this.dragX, this.yPos + 9 + this.window.dragY, this.xPos + 6 + this.window.dragX + (int)this.dragX, (float)this.yPos + 15.5f + (float)this.window.dragY, -15790321, -15790321);
        } else {
            RenderUtils.drawBorderedRect(this.xPos + this.window.dragX + (int)this.dragX, this.yPos + 9 + this.window.dragY, this.xPos + 6 + this.window.dragX + (int)this.dragX, (float)this.yPos + 15.5f + (float)this.window.dragY, -15790321, -5592406);
        }
        float fraction = (float)this.sliderWidth / (this.maxValue - this.minValue);
        this.sliderValue.setValue(this.sliderValue.getName().equals("Step") ? this.dragX / fraction + this.minValue + 0.1f : (this.shouldRound ? (float)((int)(this.dragX / fraction)) + this.minValue : this.dragX / fraction + this.minValue));
    }

    public float getValue() {
        return Float.parseFloat(new DecimalFormat("0.0").format(this.sliderValue.getValue()));
    }

    public void setValue(float value) {
        float fraction = 80.0f / (this.maxValue - this.minValue);
        this.sliderValue.setValue(value -= this.minValue);
        this.dragX = fraction * value;
    }

    public void mouseClicked(int x, int y, int button) {
        if (button == 0 && (float)x >= (float)(this.xPos + this.window.dragX) + this.dragX && y >= this.yPos + 9 + this.window.dragY && (float)x <= (float)(this.xPos + 6 + this.window.dragX) + this.dragX && (float)y <= (float)this.yPos + 15.5f + (float)this.window.dragY) {
            this.lastDragX = (float)x - this.dragX;
            this.dragging = true;
        }
    }

    public void mouseMovedOrUp(int x, int y, int b) {
        if (b == 0) {
            this.dragging = false;
        }
    }
}

