/*
 * Decompiled with CFR 0.152.
 */
package epsilon.clickgui;

import epsilon.clickgui.Button;
import epsilon.clickgui.GuiClick;
import epsilon.clickgui.GuiUtils;
import epsilon.clickgui.Slider;
import epsilon.init.font.Fonts;
import epsilon.modulemanager.Module;
import epsilon.utils.Value;
import java.util.ArrayList;

public class Window {
    private String title;
    private int xPos;
    private int yPos;
    private boolean isOpen;
    private boolean isExtended;
    private boolean isPinned;
    public int dragX;
    public int dragY;
    public int lastDragX;
    public int lastDragY;
    protected boolean dragging;
    public ArrayList<Button> buttons = new ArrayList();
    public ArrayList<Slider> sliders = new ArrayList();
    private int buttonCount = 0;
    private int sliderCount = 0;

    public Window(String title, int x, int y) {
        this.title = title;
        this.xPos = x;
        this.yPos = y;
        GuiClick.windows.add(this);
        GuiClick.unFocusedWindows.add(this);
    }

    public void windowDragged(int x, int y) {
        this.dragX = x - this.lastDragX;
        this.dragY = y - this.lastDragY;
    }

    public void addButton(Module mod) {
        this.buttons.add(new Button(this, mod, this.xPos + 2, this.yPos + 13 * this.buttons.size() + 16));
    }

    public Slider addSlider(Value value) {
        return this.addSlider(value, 10.0f);
    }

    public Slider addSlider(Value value, float maxValue) {
        return this.addSlider(value, 0.0f, maxValue, false);
    }

    public Slider addSlider(Value value, float minValue, float maxValue, boolean shouldRound) {
        Slider slider = new Slider(this, value, this.xPos + 2, this.yPos + 18 * this.sliderCount + 16, minValue, maxValue, shouldRound);
        this.sliders.add(slider);
        ++this.sliderCount;
        return slider;
    }

    public void draw(int x, int y) {
        if (this.isOpen) {
            if (this.dragging) {
                this.windowDragged(x, y);
            }
            if (!this.isExtended) {
                GuiUtils.drawBorderedRect(this.xPos + this.dragX, this.yPos + this.dragY, this.xPos + 90 + this.dragX, this.yPos + 12 + this.dragY, -16777216, -12434878);
            } else {
                GuiUtils.drawBorderedRect(this.xPos + this.dragX, this.yPos + this.dragY, this.xPos + 90 + this.dragX, this.yPos + 12 + this.dragY, -16777216, -12434878);
                GuiUtils.drawBorderedRect(this.xPos + this.dragX, this.yPos + this.dragY + 12, this.xPos + 90 + this.dragX, this.yPos + (13 * this.buttons.size() + 17) + this.dragY, -15790321, -1350862213);
            }
            Fonts.tahoma18.drawString(this.title, this.xPos + 2 + this.dragX, this.yPos + this.dragY, -1);
            GuiUtils.drawBorderedRect(this.xPos + 62 + this.dragX, this.yPos + this.dragY + 2, this.xPos + 74 + this.dragX, this.yPos + 10 + this.dragY, this.isPinned ? -15790321 : -16777216, this.isPinned ? -13871707 : 0x70070707);
            GuiUtils.drawBorderedRect(this.xPos + 76 + this.dragX, this.yPos + this.dragY + 2, this.xPos + 88 + this.dragX, this.yPos + 10 + this.dragY, this.isExtended ? -15790321 : -16777216, this.isExtended ? -13871707 : 0x70070707);
            if (this.isExtended) {
                for (Slider slider : this.sliders) {
                    slider.draw(4);
                }
                for (Button button : this.buttons) {
                    button.draw();
                    button.isOverButton = x >= button.getX() + this.dragX && y >= button.getY() + 1 + this.dragY && x <= button.getX() + 23 + this.dragX + 63 && y <= button.getY() + 10 + this.dragY;
                }
            }
        }
    }

    public void mouseClicked(int x, int y, int button) {
        for (Button xButton : this.buttons) {
            xButton.mouseClicked(x, y, button);
        }
        for (Slider xSlider : this.sliders) {
            xSlider.mouseClicked(x, y, button);
        }
        if (x >= this.xPos + 76 + this.dragX && y >= this.yPos + this.dragY + 2 && x <= this.xPos + 88 + this.dragX && y <= this.yPos + 10 + this.dragY) {
            boolean bl = this.isExtended = !this.isExtended;
        }
        if (x >= this.xPos + 62 + this.dragX && y >= this.yPos + this.dragY + 2 && x <= this.xPos + 74 + this.dragX && y <= this.yPos + 10 + this.dragY) {
            boolean bl = this.isPinned = !this.isPinned;
        }
        if (x >= this.xPos + this.dragX && y >= this.yPos + this.dragY && x <= this.xPos + 69 + this.dragX && y <= this.yPos + 12 + this.dragY) {
            GuiClick.sendPanelToFront(this);
            this.dragging = true;
            this.lastDragX = x - this.dragX;
            this.lastDragY = y - this.dragY;
        }
    }

    public void mouseMovedOrUp(int x, int y, int b) {
        for (Slider slider : this.sliders) {
            slider.mouseMovedOrUp(x, y, b);
        }
        if (b == 0) {
            this.dragging = false;
        }
    }

    public final String getTitle() {
        return this.title;
    }

    public final int getX() {
        return this.xPos;
    }

    public final int getY() {
        return this.yPos;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isPinned() {
        return this.isPinned;
    }

    public void setOpen(boolean flag) {
        this.isOpen = flag;
    }

    public void setExtended(boolean flag) {
        this.isExtended = flag;
    }

    public void setPinned(boolean flag) {
        this.isPinned = flag;
    }
}

