/*
 * Decompiled with CFR 0.152.
 */
package epsilon.cmdmanager;

import epsilon.cmdmanager.Command;
import epsilon.cmdmanager.cmds.CommandBind;
import epsilon.cmdmanager.cmds.CommandFriend;
import epsilon.cmdmanager.cmds.CommandHelp;
import epsilon.cmdmanager.cmds.CommandIRC;
import epsilon.cmdmanager.cmds.CommandInsult;
import epsilon.cmdmanager.cmds.CommandWaypoints;
import epsilon.main.Epsilon;
import java.util.ArrayList;

public class CommandManager {
    public static ArrayList<Command> commands = new ArrayList();
    public static char cmdPrefix = (char)46;

    public CommandManager() {
        this.addCommands();
    }

    public void addCommands() {
        commands.clear();
        commands.add(new CommandBind());
        commands.add(new CommandHelp());
        commands.add(new CommandInsult());
        commands.add(new CommandFriend());
        commands.add(new CommandWaypoints());
        commands.add(new CommandIRC());
    }

    public void runCommands(String s) {
        if (!s.contains(Character.toString(cmdPrefix)) || !s.startsWith(Character.toString(cmdPrefix))) {
            return;
        }
        boolean commandResolved = false;
        String readString = s.trim().substring(Character.toString(cmdPrefix).length()).trim();
        boolean hasArgs = readString.trim().contains(" ");
        String commandName = hasArgs ? readString.split(" ")[0] : readString.trim();
        String[] args = hasArgs ? readString.substring(commandName.length()).trim().split(" ") : new String[]{};
        for (Command command : commands) {
            if (!command.getCommand().trim().equalsIgnoreCase(commandName.trim())) continue;
            command.runCommand(readString, args);
            commandResolved = true;
            break;
        }
        if (s.equalsIgnoreCase(".reload")) {
            Epsilon.addChatMessage("Initializing...");
            Epsilon.theEpsilon.startUp();
            Epsilon.addChatMessage("Initialized.");
            return;
        }
        if (!commandResolved) {
            Epsilon.addChatMessage("Invalid command. Type " + cmdPrefix + "help or help in Console for a list of commands.");
        }
    }
}

