/*
 * Decompiled with CFR 0.152.
 */
package epsilon.init;

import org.lwjgl.opengl.GL11;

public final class TextureUtils {
    public static void renderTexture(int texID, double x, double y, double width, double height) {
        GL11.glBindTexture((int)3553, (int)texID);
        TextureUtils.renderTexture(x, y, width, height);
    }

    public static void renderTexture(int textureWidth, int textureHeight, float x, float y, float width, float height, float srcX, float srcY, float srcWidth, float srcHeight) {
        float renderSRCX = srcX / (float)textureWidth;
        float renderSRCY = srcY / (float)textureHeight;
        float renderSRCWidth = srcWidth / (float)textureWidth;
        float renderSRCHeight = srcHeight / (float)textureHeight;
        boolean tex2D = GL11.glGetBoolean((int)3553);
        boolean blend = GL11.glGetBoolean((int)3042);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        GL11.glBegin((int)4);
        GL11.glTexCoord2f((float)(renderSRCX + renderSRCWidth), (float)renderSRCY);
        GL11.glVertex2d((double)(x + width), (double)y);
        GL11.glTexCoord2f((float)renderSRCX, (float)renderSRCY);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glTexCoord2f((float)renderSRCX, (float)(renderSRCY + renderSRCHeight));
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glTexCoord2f((float)renderSRCX, (float)(renderSRCY + renderSRCHeight));
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glTexCoord2f((float)(renderSRCX + renderSRCWidth), (float)(renderSRCY + renderSRCHeight));
        GL11.glVertex2d((double)(x + width), (double)(y + height));
        GL11.glTexCoord2f((float)(renderSRCX + renderSRCWidth), (float)renderSRCY);
        GL11.glVertex2d((double)(x + width), (double)y);
        GL11.glEnd();
        if (!tex2D) {
            GL11.glDisable((int)3553);
        }
        if (!blend) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    public static void renderTexture(double x, double y, double width, double height) {
        boolean tex2D = GL11.glGetBoolean((int)3553);
        boolean blend = GL11.glGetBoolean((int)3042);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        height *= 2.0;
        GL11.glBegin((int)4);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2d((double)((x *= 2.0) + (width *= 2.0)), (double)(y *= 2.0));
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2d((double)(x + width), (double)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2d((double)(x + width), (double)y);
        GL11.glEnd();
        if (!tex2D) {
            GL11.glDisable((int)3553);
        }
        if (!blend) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }
}

