/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.IRegistry;
import net.minecraft.util.RegistryDefaulted;
import net.minecraft.world.World;

public class BlockDispenser
extends BlockContainer {
    public static final IRegistry dispenseBehaviorRegistry = new RegistryDefaulted(new BehaviorDefaultDispenseItem());
    protected Random field_149942_b = new Random();
    protected IIcon field_149944_M;
    protected IIcon field_149945_N;
    protected IIcon field_149946_O;
    private static final String __OBFID = "CL_00000229";

    protected BlockDispenser() {
        super(Material.rock);
        this.setCreativeTab(CreativeTabs.tabRedstone);
    }

    @Override
    public int func_149738_a(World p_149738_1_) {
        return 4;
    }

    @Override
    public void onBlockAdded(World p_149726_1_, int p_149726_2_, int p_149726_3_, int p_149726_4_) {
        super.onBlockAdded(p_149726_1_, p_149726_2_, p_149726_3_, p_149726_4_);
        this.func_149938_m(p_149726_1_, p_149726_2_, p_149726_3_, p_149726_4_);
    }

    private void func_149938_m(World p_149938_1_, int p_149938_2_, int p_149938_3_, int p_149938_4_) {
        if (!p_149938_1_.isClient) {
            Block var5 = p_149938_1_.getBlock(p_149938_2_, p_149938_3_, p_149938_4_ - 1);
            Block var6 = p_149938_1_.getBlock(p_149938_2_, p_149938_3_, p_149938_4_ + 1);
            Block var7 = p_149938_1_.getBlock(p_149938_2_ - 1, p_149938_3_, p_149938_4_);
            Block var8 = p_149938_1_.getBlock(p_149938_2_ + 1, p_149938_3_, p_149938_4_);
            int var9 = 3;
            if (var5.func_149730_j() && !var6.func_149730_j()) {
                var9 = 3;
            }
            if (var6.func_149730_j() && !var5.func_149730_j()) {
                var9 = 2;
            }
            if (var7.func_149730_j() && !var8.func_149730_j()) {
                var9 = 5;
            }
            if (var8.func_149730_j() && !var7.func_149730_j()) {
                var9 = 4;
            }
            p_149938_1_.setBlockMetadataWithNotify(p_149938_2_, p_149938_3_, p_149938_4_, var9, 2);
        }
    }

    @Override
    public IIcon getIcon(int p_149691_1_, int p_149691_2_) {
        int var3 = p_149691_2_ & 7;
        return p_149691_1_ == var3 ? (var3 != 1 && var3 != 0 ? this.field_149945_N : this.field_149946_O) : (var3 != 1 && var3 != 0 ? (p_149691_1_ != 1 && p_149691_1_ != 0 ? this.blockIcon : this.field_149944_M) : this.field_149944_M);
    }

    @Override
    public void registerBlockIcons(IIconRegister p_149651_1_) {
        this.blockIcon = p_149651_1_.registerIcon("furnace_side");
        this.field_149944_M = p_149651_1_.registerIcon("furnace_top");
        this.field_149945_N = p_149651_1_.registerIcon(String.valueOf(this.getTextureName()) + "_front_horizontal");
        this.field_149946_O = p_149651_1_.registerIcon(String.valueOf(this.getTextureName()) + "_front_vertical");
    }

    @Override
    public boolean onBlockActivated(World p_149727_1_, int p_149727_2_, int p_149727_3_, int p_149727_4_, EntityPlayer p_149727_5_, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (p_149727_1_.isClient) {
            return true;
        }
        TileEntityDispenser var10 = (TileEntityDispenser)p_149727_1_.getTileEntity(p_149727_2_, p_149727_3_, p_149727_4_);
        if (var10 != null) {
            p_149727_5_.func_146102_a(var10);
        }
        return true;
    }

    protected void func_149941_e(World p_149941_1_, int p_149941_2_, int p_149941_3_, int p_149941_4_) {
        BlockSourceImpl var5 = new BlockSourceImpl(p_149941_1_, p_149941_2_, p_149941_3_, p_149941_4_);
        TileEntityDispenser var6 = (TileEntityDispenser)var5.getBlockTileEntity();
        if (var6 != null) {
            int var7 = var6.func_146017_i();
            if (var7 < 0) {
                p_149941_1_.playAuxSFX(1001, p_149941_2_, p_149941_3_, p_149941_4_, 0);
            } else {
                ItemStack var8 = var6.getStackInSlot(var7);
                IBehaviorDispenseItem var9 = this.func_149940_a(var8);
                if (var9 != IBehaviorDispenseItem.itemDispenseBehaviorProvider) {
                    ItemStack var10 = var9.dispense(var5, var8);
                    var6.setInventorySlotContents(var7, var10.stackSize == 0 ? null : var10);
                }
            }
        }
    }

    protected IBehaviorDispenseItem func_149940_a(ItemStack p_149940_1_) {
        return (IBehaviorDispenseItem)dispenseBehaviorRegistry.getObject(p_149940_1_.getItem());
    }

    @Override
    public void onNeighborBlockChange(World p_149695_1_, int p_149695_2_, int p_149695_3_, int p_149695_4_, Block p_149695_5_) {
        boolean var8;
        boolean var6 = p_149695_1_.isBlockIndirectlyGettingPowered(p_149695_2_, p_149695_3_, p_149695_4_) || p_149695_1_.isBlockIndirectlyGettingPowered(p_149695_2_, p_149695_3_ + 1, p_149695_4_);
        int var7 = p_149695_1_.getBlockMetadata(p_149695_2_, p_149695_3_, p_149695_4_);
        boolean bl = var8 = (var7 & 8) != 0;
        if (var6 && !var8) {
            p_149695_1_.scheduleBlockUpdate(p_149695_2_, p_149695_3_, p_149695_4_, this, this.func_149738_a(p_149695_1_));
            p_149695_1_.setBlockMetadataWithNotify(p_149695_2_, p_149695_3_, p_149695_4_, var7 | 8, 4);
        } else if (!var6 && var8) {
            p_149695_1_.setBlockMetadataWithNotify(p_149695_2_, p_149695_3_, p_149695_4_, var7 & 0xFFFFFFF7, 4);
        }
    }

    @Override
    public void updateTick(World p_149674_1_, int p_149674_2_, int p_149674_3_, int p_149674_4_, Random p_149674_5_) {
        if (!p_149674_1_.isClient) {
            this.func_149941_e(p_149674_1_, p_149674_2_, p_149674_3_, p_149674_4_);
        }
    }

    @Override
    public TileEntity createNewTileEntity(World p_149915_1_, int p_149915_2_) {
        return new TileEntityDispenser();
    }

    @Override
    public void onBlockPlacedBy(World p_149689_1_, int p_149689_2_, int p_149689_3_, int p_149689_4_, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        int var7 = BlockPistonBase.func_150071_a(p_149689_1_, p_149689_2_, p_149689_3_, p_149689_4_, p_149689_5_);
        p_149689_1_.setBlockMetadataWithNotify(p_149689_2_, p_149689_3_, p_149689_4_, var7, 2);
        if (p_149689_6_.hasDisplayName()) {
            ((TileEntityDispenser)p_149689_1_.getTileEntity(p_149689_2_, p_149689_3_, p_149689_4_)).func_146018_a(p_149689_6_.getDisplayName());
        }
    }

    @Override
    public void breakBlock(World p_149749_1_, int p_149749_2_, int p_149749_3_, int p_149749_4_, Block p_149749_5_, int p_149749_6_) {
        TileEntityDispenser var7 = (TileEntityDispenser)p_149749_1_.getTileEntity(p_149749_2_, p_149749_3_, p_149749_4_);
        if (var7 != null) {
            int var8 = 0;
            while (var8 < var7.getSizeInventory()) {
                ItemStack var9 = var7.getStackInSlot(var8);
                if (var9 != null) {
                    float var10 = this.field_149942_b.nextFloat() * 0.8f + 0.1f;
                    float var11 = this.field_149942_b.nextFloat() * 0.8f + 0.1f;
                    float var12 = this.field_149942_b.nextFloat() * 0.8f + 0.1f;
                    while (var9.stackSize > 0) {
                        int var13 = this.field_149942_b.nextInt(21) + 10;
                        if (var13 > var9.stackSize) {
                            var13 = var9.stackSize;
                        }
                        var9.stackSize -= var13;
                        EntityItem var14 = new EntityItem(p_149749_1_, (float)p_149749_2_ + var10, (float)p_149749_3_ + var11, (float)p_149749_4_ + var12, new ItemStack(var9.getItem(), var13, var9.getItemDamage()));
                        if (var9.hasTagCompound()) {
                            var14.getEntityItem().setTagCompound((NBTTagCompound)var9.getTagCompound().copy());
                        }
                        float var15 = 0.05f;
                        var14.motionX = (float)this.field_149942_b.nextGaussian() * var15;
                        var14.motionY = (float)this.field_149942_b.nextGaussian() * var15 + 0.2f;
                        var14.motionZ = (float)this.field_149942_b.nextGaussian() * var15;
                        p_149749_1_.spawnEntityInWorld(var14);
                    }
                }
                ++var8;
            }
            p_149749_1_.func_147453_f(p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_);
        }
        super.breakBlock(p_149749_1_, p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_, p_149749_6_);
    }

    public static IPosition func_149939_a(IBlockSource p_149939_0_) {
        EnumFacing var1 = BlockDispenser.func_149937_b(p_149939_0_.getBlockMetadata());
        double var2 = p_149939_0_.getX() + 0.7 * (double)var1.getFrontOffsetX();
        double var4 = p_149939_0_.getY() + 0.7 * (double)var1.getFrontOffsetY();
        double var6 = p_149939_0_.getZ() + 0.7 * (double)var1.getFrontOffsetZ();
        return new PositionImpl(var2, var4, var6);
    }

    public static EnumFacing func_149937_b(int p_149937_0_) {
        return EnumFacing.getFront(p_149937_0_ & 7);
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride(World p_149736_1_, int p_149736_2_, int p_149736_3_, int p_149736_4_, int p_149736_5_) {
        return Container.calcRedstoneFromInventory((IInventory)((Object)p_149736_1_.getTileEntity(p_149736_2_, p_149736_3_, p_149736_4_)));
    }
}

