/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;

public class GuiOtherSettingsOF
extends GuiScreen {
    private GuiScreen prevScreen;
    protected String title = "Other Settings";
    private GameSettings settings;
    private static GameSettings.Options[] enumOptions = new GameSettings.Options[]{GameSettings.Options.LAGOMETER, GameSettings.Options.PROFILER, GameSettings.Options.WEATHER, GameSettings.Options.TIME, GameSettings.Options.USE_FULLSCREEN, GameSettings.Options.FULLSCREEN_MODE, GameSettings.Options.ANAGLYPH, GameSettings.Options.AUTOSAVE_TICKS};
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public GuiOtherSettingsOF(GuiScreen guiscreen, GameSettings gamesettings) {
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    @Override
    public void initGui() {
        int i = 0;
        GameSettings.Options[] aenumoptions = enumOptions;
        int j = aenumoptions.length;
        int k = 0;
        while (k < j) {
            GameSettings.Options enumoptions = aenumoptions[k];
            int x = this.width / 2 - 155 + i % 2 * 160;
            int y = this.height / 6 + 21 * (i / 2) - 10;
            if (!enumoptions.getEnumFloat()) {
                this.buttonList.add(new GuiOptionButton(enumoptions.returnEnumOrdinal(), x, y, enumoptions, this.settings.getKeyBinding(enumoptions)));
            } else {
                this.buttonList.add(new GuiOptionSlider(enumoptions.returnEnumOrdinal(), x, y, enumoptions));
            }
            ++i;
            ++k;
        }
        this.buttonList.add(new GuiButton(210, this.width / 2 - 100, this.height / 6 + 168 + 11 - 44, "Reset Video Settings..."));
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168 + 11, I18n.format("gui.done", new Object[0])));
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton.enabled) {
            if (guibutton.id < 100 && guibutton instanceof GuiOptionButton) {
                this.settings.setOptionValue(((GuiOptionButton)guibutton).func_146136_c(), 1);
                guibutton.displayString = this.settings.getKeyBinding(GameSettings.Options.getEnumOptions(guibutton.id));
            }
            if (guibutton.id == 200) {
                this.mc.gameSettings.saveOptions();
                this.mc.displayGuiScreen(this.prevScreen);
            }
            if (guibutton.id == 210) {
                this.mc.gameSettings.saveOptions();
                GuiYesNo scaledresolution = new GuiYesNo(this, "Reset all video settings to their default values?", "", 9999);
                this.mc.displayGuiScreen(scaledresolution);
            }
            if (guibutton.id != GameSettings.Options.CLOUD_HEIGHT.ordinal()) {
                ScaledResolution scaledresolution1 = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
                int i = scaledresolution1.getScaledWidth();
                int j = scaledresolution1.getScaledHeight();
                this.setWorldAndResolution(this.mc, i, j);
            }
        }
    }

    @Override
    public void confirmClicked(boolean flag, int i) {
        if (flag) {
            this.mc.gameSettings.resetSettings();
        }
        this.mc.displayGuiScreen(this);
    }

    @Override
    public void drawScreen(int x, int y, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(x, y, f);
        if (Math.abs(x - this.lastMouseX) <= 5 && Math.abs(y - this.lastMouseY) <= 5) {
            int activateDelay = 700;
            if (System.currentTimeMillis() >= this.mouseStillTime + (long)activateDelay) {
                int x1 = this.width / 2 - 150;
                int y1 = this.height / 6 - 5;
                if (y <= y1 + 98) {
                    y1 += 105;
                }
                int x2 = x1 + 150 + 150;
                int y2 = y1 + 84 + 10;
                GuiButton btn = this.getSelectedButton(x, y);
                if (btn != null) {
                    String s = this.getButtonName(btn.displayString);
                    String[] lines = this.getTooltipLines(s);
                    if (lines == null) {
                        return;
                    }
                    this.drawGradientRect(x1, y1, x2, y2, -536870912, -536870912);
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        this.fontRendererObj.drawStringWithShadow(line, x1 + 5, y1 + 5 + i * 11, 0xDDDDDD);
                        ++i;
                    }
                }
            }
        } else {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
        }
    }

    private String[] getTooltipLines(String btnName) {
        String[] stringArray;
        if (btnName.equals("Autosave")) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "Autosave interval";
            stringArray2[1] = "Default autosave interval (2s) is NOT RECOMMENDED.";
            stringArray = stringArray2;
            stringArray2[2] = "Autosave causes the famous Lag Spike of Death.";
        } else if (btnName.equals("Lagometer")) {
            String[] stringArray3 = new String[8];
            stringArray3[0] = "Lagometer";
            stringArray3[1] = " OFF - no lagometer, faster";
            stringArray3[2] = " ON - debug screen with lagometer, slower";
            stringArray3[3] = "Shows the lagometer on the debug screen (F3).";
            stringArray3[4] = "* White - tick";
            stringArray3[5] = "* Red - chunk loading";
            stringArray3[6] = "* Green - frame rendering + internal server";
            stringArray = stringArray3;
            stringArray3[7] = "* Blue - internal server (when Smooth World is ON)";
        } else if (btnName.equals("Debug Profiler")) {
            String[] stringArray4 = new String[5];
            stringArray4[0] = "Debug Profiler";
            stringArray4[1] = "  ON - debug profiler is active, slower";
            stringArray4[2] = "  OFF - debug profiler is not active, faster";
            stringArray4[3] = "The debug profiler collects and shows debug information";
            stringArray = stringArray4;
            stringArray4[4] = "when the debug screen is open (F3)";
        } else if (btnName.equals("Time")) {
            String[] stringArray5 = new String[6];
            stringArray5[0] = "Time";
            stringArray5[1] = " Default - normal day/night cycles";
            stringArray5[2] = " Day Only - day only";
            stringArray5[3] = " Night Only - night only";
            stringArray5[4] = "The time setting is only effective in CREATIVE mode";
            stringArray = stringArray5;
            stringArray5[5] = "and for local worlds.";
        } else if (btnName.equals("Weather")) {
            String[] stringArray6 = new String[5];
            stringArray6[0] = "Weather";
            stringArray6[1] = "  ON - weather is active, slower";
            stringArray6[2] = "  OFF - weather is not active, faster";
            stringArray6[3] = "The weather controls rain, snow and thunderstorms.";
            stringArray = stringArray6;
            stringArray6[4] = "Weather control is only possible for local worlds.";
        } else if (btnName.equals("Fullscreen")) {
            String[] stringArray7 = new String[5];
            stringArray7[0] = "Fullscreen";
            stringArray7[1] = "  ON - use fullscreen mode";
            stringArray7[2] = "  OFF - use window mode";
            stringArray7[3] = "Fullscreen mode may be faster or slower than";
            stringArray = stringArray7;
            stringArray7[4] = "window mode, depending on the graphics card.";
        } else if (btnName.equals("Fullscreen Mode")) {
            String[] stringArray8 = new String[5];
            stringArray8[0] = "Fullscreen mode";
            stringArray8[1] = "  Default - use desktop screen resolution, slower";
            stringArray8[2] = "  WxH - use custom screen resolution, may be faster";
            stringArray8[3] = "The selected resolution is used in fullscreen mode (F11).";
            stringArray = stringArray8;
            stringArray8[4] = "Lower resolutions should generally be faster.";
        } else if (btnName.equals("3D Anaglyph")) {
            String[] stringArray9 = new String[1];
            stringArray = stringArray9;
            stringArray9[0] = "3D mode used with red-cyan 3D glasses.";
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private String getButtonName(String displayString) {
        int pos = displayString.indexOf(58);
        return pos < 0 ? displayString : displayString.substring(0, pos);
    }

    private GuiButton getSelectedButton(int i, int j) {
        int k = 0;
        while (k < this.buttonList.size()) {
            boolean flag;
            GuiButton btn = (GuiButton)this.buttonList.get(k);
            int btnWidth = GuiVideoSettings.getButtonWidth(btn);
            int btnHeight = GuiVideoSettings.getButtonHeight(btn);
            boolean bl = flag = i >= btn.field_146128_h && j >= btn.field_146129_i && i < btn.field_146128_h + btnWidth && j < btn.field_146129_i + btnHeight;
            if (flag) {
                return btn;
            }
            ++k;
        }
        return null;
    }
}

