/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

public class WorldType {
    public static final WorldType[] worldTypes = new WorldType[16];
    public static final WorldType DEFAULT = new WorldType(0, "default", 1).setVersioned();
    public static final WorldType FLAT = new WorldType(1, "flat");
    public static final WorldType LARGE_BIOMES = new WorldType(2, "largeBiomes");
    public static final WorldType field_151360_e = new WorldType(3, "amplified").func_151358_j();
    public static final WorldType DEFAULT_1_1 = new WorldType(8, "default_1_1", 0).setCanBeCreated(false);
    private final int worldTypeId;
    private final String worldType;
    private final int generatorVersion;
    private boolean canBeCreated;
    private boolean isWorldTypeVersioned;
    private boolean field_151361_l;
    private static final String __OBFID = "CL_00000150";

    private WorldType(int par1, String par2Str) {
        this(par1, par2Str, 0);
    }

    private WorldType(int par1, String par2Str, int par3) {
        this.worldType = par2Str;
        this.generatorVersion = par3;
        this.canBeCreated = true;
        this.worldTypeId = par1;
        WorldType.worldTypes[par1] = this;
    }

    public String getWorldTypeName() {
        return this.worldType;
    }

    public String getTranslateName() {
        return "generator." + this.worldType;
    }

    public String func_151359_c() {
        return String.valueOf(this.getTranslateName()) + ".info";
    }

    public int getGeneratorVersion() {
        return this.generatorVersion;
    }

    public WorldType getWorldTypeForGeneratorVersion(int par1) {
        return this == DEFAULT && par1 == 0 ? DEFAULT_1_1 : this;
    }

    private WorldType setCanBeCreated(boolean par1) {
        this.canBeCreated = par1;
        return this;
    }

    public boolean getCanBeCreated() {
        return this.canBeCreated;
    }

    private WorldType setVersioned() {
        this.isWorldTypeVersioned = true;
        return this;
    }

    public boolean isVersioned() {
        return this.isWorldTypeVersioned;
    }

    public static WorldType parseWorldType(String par0Str) {
        int var1 = 0;
        while (var1 < worldTypes.length) {
            if (worldTypes[var1] != null && WorldType.worldTypes[var1].worldType.equalsIgnoreCase(par0Str)) {
                return worldTypes[var1];
            }
            ++var1;
        }
        return null;
    }

    public int getWorldTypeID() {
        return this.worldTypeId;
    }

    public boolean func_151357_h() {
        return this.field_151361_l;
    }

    private WorldType func_151358_j() {
        this.field_151361_l = true;
        return this;
    }
}

