/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.camera.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dmillerw.camera.core.CameraHandler;
import dmillerw.camera.entity.EntityCamera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class RenderHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static ModelSkeletonHead head = new ModelSkeletonHead(0, 0, 64, 32);

    public static void translateToWorldCoords(Entity entity, float frame) {
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        GL11.glPushMatrix();
        EntityLivingBase renderViewEntity = Minecraft.func_71410_x().field_71451_h;
        RenderHandler.translateToWorldCoords((Entity)renderViewEntity, event.partialTicks);
        mc.func_110434_K().func_110577_a(AbstractClientPlayer.field_110314_b);
        for (CameraHandler.CameraData cameraData : CameraHandler.cameras) {
            if (cameraData == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslated((double)cameraData.position.field_72450_a, (double)cameraData.position.field_72448_b, (double)cameraData.position.field_72449_c);
            GL11.glTranslated((double)0.0, (double)-0.25, (double)0.0);
            GL11.glRotated((double)(-cameraData.yaw), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(cameraData.pitch + 180.0f), (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.25, (double)0.0);
            head.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void renderHandEvent(RenderHandEvent event) {
        if (EntityCamera.isActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderHudEvent(RenderGameOverlayEvent event) {
        if (EntityCamera.isActive() && event.type == RenderGameOverlayEvent.ElementType.HOTBAR || event.type == RenderGameOverlayEvent.ElementType.AIR || event.type == RenderGameOverlayEvent.ElementType.ARMOR || event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void fovUpdateEvent(FOVUpdateEvent event) {
        if (EntityCamera.isActive()) {
            event.newfov = 1.0f;
        }
    }
}

