/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.camera.command;

import dmillerw.camera.core.CameraHandler;
import dmillerw.camera.entity.EntityCamera;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandCamera
extends CommandBase {
    public String func_71517_b() {
        return "camera";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/camera [create/list/switch/remove/back]";
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length > 0) {
            String arg = args[0];
            if (arg.equalsIgnoreCase("create")) {
                if (args.length == 1) {
                    int camera = CameraHandler.createCamera((EntityPlayer)sender);
                    if (camera >= 0) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText("Created camera #" + camera));
                        return;
                    }
                } else if (args.length == 6) {
                    try {
                        double x = Double.parseDouble(args[1]);
                        double y = Double.parseDouble(args[2]);
                        double z = Double.parseDouble(args[3]);
                        float pitch = Float.parseFloat(args[4]);
                        float yaw = Float.parseFloat(args[5]);
                        int camera = CameraHandler.createCamera(x, y, z, pitch, yaw);
                        if (camera >= 0) {
                            sender.func_145747_a((IChatComponent)new ChatComponentText("Created camera #" + camera));
                            return;
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new WrongUsageException("/camera create <x, y, z, pitch, yaw>", new Object[0]);
                    }
                }
            } else if (arg.equalsIgnoreCase("list")) {
                for (int i = 0; i < 256; ++i) {
                    CameraHandler.CameraData cameraData = CameraHandler.getCamera(i);
                    if (cameraData == null) continue;
                    sender.func_145747_a((IChatComponent)new ChatComponentText(String.format("Camera #%s [%s, %s, %s] <%s, %s>", i, cameraData.position.field_72450_a, cameraData.position.field_72448_b, cameraData.position.field_72449_c, Float.valueOf(cameraData.pitch), Float.valueOf(cameraData.yaw))));
                    return;
                }
            } else if (arg.equalsIgnoreCase("remove")) {
                if (args.length == 2) {
                    if (args[1].equalsIgnoreCase("all")) {
                        CameraHandler.cameras = new CameraHandler.CameraData[256];
                        EntityCamera.destroyCamera();
                        return;
                    }
                    try {
                        int id = Integer.parseInt(args[1]);
                        CameraHandler.removeCamera(id);
                        if (id == EntityCamera.activeCameraId) {
                            EntityCamera.destroyCamera();
                        }
                        return;
                    }
                    catch (NumberFormatException ex) {
                        throw new WrongUsageException("/camera remove <id>", new Object[0]);
                    }
                }
            } else if (arg.equalsIgnoreCase("switch")) {
                if (args.length == 2) {
                    try {
                        CameraHandler.CameraData cameraData = CameraHandler.getCamera(Integer.parseInt(args[1]));
                        if (cameraData != null) {
                            if (cameraData.dimension != Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText("Cannot access cameras in different dimensions!"));
                                return;
                            }
                            EntityCamera.createCamera();
                            EntityCamera.activeCameraId = Integer.parseInt(args[1]);
                            EntityCamera.moveCamera(cameraData.position.field_72450_a, cameraData.position.field_72448_b, cameraData.position.field_72449_c, cameraData.pitch, cameraData.yaw);
                            return;
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new WrongUsageException("/camera switch <id>", new Object[0]);
                    }
                }
            } else if (arg.equals("back")) {
                EntityCamera.destroyCamera();
                return;
            }
        }
        throw new WrongUsageException("/camera [create/list/switch/remove/back]", new Object[0]);
    }
}

