/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.veganoption.asm.Hooks;

public class ClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.block.BlockDynamicLiquid")) {
            boolean isObfuscated = name != transformedName;
            ClassNode classNode = this.readClassFromBytes(bytes);
            MethodNode method = this.findMethodNodeOfClass(classNode, isObfuscated ? "h" : "func_149813_h", isObfuscated ? "(Lahb;IIII)V" : "(Lnet/minecraft/world/World;IIII)V");
            InsnList toInject = new InsnList();
            LabelNode ifNotCanceled = new LabelNode();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 5));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "onFlowIntoBlock", "(Lnet/minecraft/world/World;IIII)Z", false));
            toInject.add((AbstractInsnNode)new JumpInsnNode(153, ifNotCanceled));
            toInject.add((AbstractInsnNode)new InsnNode(177));
            toInject.add((AbstractInsnNode)ifNotCanceled);
            method.instructions.insertBefore(this.findFirstInstruction(method), toInject);
            return this.writeClassToBytes(classNode);
        }
        if (transformedName.equals("net.minecraft.entity.item.EntityItem")) {
            boolean isObfuscated = name != transformedName;
            ClassNode classNode = this.readClassFromBytes(bytes);
            MethodNode method = this.findMethodNodeOfClass(classNode, isObfuscated ? "h" : "onUpdate", "()V");
            InsnList toInject = new InsnList();
            LabelNode ifNotCanceled = new LabelNode();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "onEntityItemUpdate", "(Lnet/minecraft/entity/item/EntityItem;)Z", false));
            toInject.add((AbstractInsnNode)new JumpInsnNode(153, ifNotCanceled));
            toInject.add((AbstractInsnNode)new InsnNode(177));
            toInject.add((AbstractInsnNode)ifNotCanceled);
            method.instructions.insertBefore(this.findFirstInstruction(method), toInject);
            return this.writeClassToBytes(classNode);
        }
        if (transformedName.equals("tconstruct.tools.TinkerToolEvents")) {
            ClassNode classNode = this.readClassFromBytes(bytes);
            MethodNode method = this.findMethodNodeOfClass(classNode, "buildTool", "(Ltconstruct/library/event/ToolBuildEvent;)V");
            if (method != null) {
                InsnList toInject = new InsnList();
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInject.add((AbstractInsnNode)new FieldInsnNode(180, "tconstruct/library/event/ToolBuildEvent", "handleStack", "Lnet/minecraft/item/ItemStack;"));
                toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "getRealHandle", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", false));
                toInject.add((AbstractInsnNode)new FieldInsnNode(181, "tconstruct/library/event/ToolBuildEvent", "handleStack", "Lnet/minecraft/item/ItemStack;"));
                method.instructions.insertBefore(this.findFirstInstruction(method), toInject);
            }
            return this.writeClassToBytes(classNode);
        }
        return bytes;
    }

    private ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private byte[] writeClassToBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck) {
        return this.getOrFindInstruction(firstInsnToCheck, false);
    }

    public AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getType() != 8 && instruction.getType() != 15) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public AbstractInsnNode findFirstInstruction(MethodNode method) {
        return this.getOrFindInstruction(method.instructions.getFirst());
    }
}

