/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.blocks.tiles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import squeek.veganoption.content.modules.Composting;
import squeek.veganoption.content.registry.CompostRegistry;
import squeek.veganoption.helpers.GuiHelper;
import squeek.veganoption.helpers.InventoryHelper;
import squeek.veganoption.helpers.RandomHelper;
import squeek.veganoption.helpers.TemperatureHelper;

public class TileEntityComposter
extends TileEntity
implements IInventory {
    public static final float IDEAL_GREEN_TO_BROWN_RATIO = 0.6666667f;
    public static final int TICKS_BETWEEN_COMPOST_ATTEMPTS = 12000;
    public static final int TICKS_TO_FULLY_COOL = 24000;
    public static final float MAX_COMPOST_TEMPERATURE = 70.0f;
    public static final float THERMOPHILIC_RANGE_START = 45.0f;
    public static final float MESOPHILIC_RANGE_START = 20.0f;
    public static final int NUM_TICKS_FOR_FULL_AERATION = 100;
    public static final float MAX_TEMPERATURE_DELTA_PER_TICK = 0.005f;
    public static final float AERATION_PERCENT_TEMPERATURE_RETAINED_PER_TICK = 0.997f;
    public static final int CLIENT_EVENT_NUM_USING_PLAYERS = 1;
    public static final long NOT_COMPOSTING = -1L;
    protected ItemStack[] inventoryItems = new ItemStack[this.func_70302_i_()];
    protected float compostPercent;
    public long lastAeration;
    public long compostStart = -1L;
    public float compostTemperature;
    public int numPlayersUsing = 0;
    public float lidAngle;
    public float prevLidAngle;
    public int ticksSinceSync = 0;

    public boolean onActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return GuiHelper.openGuiOfTile(player, this);
        }
        if (!this.field_145850_b.field_72995_K && !this.isAerating()) {
            this.aerate();
        }
        return true;
    }

    public void onBlockBroken() {
        InventoryHelper.dropAllInventoryItemsInWorld(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
    }

    public int getComparatorSignalStrength(int side) {
        if (this.isComposting()) {
            return Math.max(0, MathHelper.func_76141_d((float)(this.getCompostTemperature() / 70.0f * 15.0f)));
        }
        return 0;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isComposting() && !this.isAerating()) {
                long ticksSinceCycleStart = this.field_145850_b.func_72820_D() - Math.max(this.compostStart, this.lastAeration);
                float percentCooled = (float)ticksSinceCycleStart / 24000.0f;
                float deltaTemperature = TileEntityComposter.getTemperatureDeltaAtTime(percentCooled);
                if ((deltaTemperature *= 0.005f) > 0.0f) {
                    deltaTemperature *= this.getBatchTemperatureMultiplier();
                }
                this.compostTemperature += deltaTemperature;
                this.clampTemperature();
                this.func_70296_d();
            } else if (this.isAerating()) {
                this.compostTemperature *= 0.997f;
                this.clampTemperature();
                this.func_70296_d();
            }
            float compostingSpeedMultiplier = this.getCompostingSpeedMultiplier();
            if (compostingSpeedMultiplier > 0.0f) {
                this.compostPercent += compostingSpeedMultiplier / 12000.0f;
                if (this.compostPercent >= 1.0f) {
                    this.attemptCompost();
                    this.compostPercent = 0.0f;
                }
                this.func_70296_d();
            }
        }
        this.updateLidAngle();
        super.func_145845_h();
    }

    public float getCompostingPercent() {
        return this.compostPercent;
    }

    public boolean attemptCompost() {
        if (this.isRotting()) {
            List<Integer> greenSlots = this.getGreenSlots();
            ArrayList<Integer> rottenPlantSlots = new ArrayList<Integer>();
            for (Integer slotNum : greenSlots) {
                if (this.func_70301_a(slotNum).func_77973_b() != Composting.rottenPlants) continue;
                rottenPlantSlots.add(slotNum);
            }
            greenSlots.removeAll(rottenPlantSlots);
            if (greenSlots.size() > 0) {
                int randomGreen = greenSlots.get(RandomHelper.random.nextInt(greenSlots.size()));
                this.func_70299_a(randomGreen, new ItemStack(Composting.rottenPlants));
                return true;
            }
        } else {
            List<Integer> greenSlots = this.getGreenSlots();
            List<Integer> brownSlots = this.getBrownSlots();
            if (greenSlots.size() >= 2 && brownSlots.size() >= 1) {
                int firstRandomGreenIndex = RandomHelper.random.nextInt(greenSlots.size());
                int firstRandomGreen = greenSlots.get(firstRandomGreenIndex);
                greenSlots.remove(firstRandomGreenIndex);
                int secondRandomGreen = greenSlots.get(RandomHelper.random.nextInt(greenSlots.size()));
                int randomBrown = brownSlots.get(RandomHelper.random.nextInt(brownSlots.size()));
                this.func_70299_a(firstRandomGreen, new ItemStack(Composting.compost));
                this.func_70299_a(secondRandomGreen, null);
                this.func_70299_a(randomBrown, null);
                return true;
            }
        }
        return false;
    }

    public void aerate() {
        List<ItemStack> itemList = Arrays.asList(this.inventoryItems);
        Collections.shuffle(itemList);
        for (int slotNum = 0; slotNum < this.func_70302_i_(); ++slotNum) {
            this.func_70299_a(slotNum, itemList.get(slotNum));
        }
        this.lastAeration = this.field_145850_b.func_72820_D();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isAerating() {
        long ticksSinceLastAeration = this.field_145850_b.func_72820_D() - this.lastAeration;
        return ticksSinceLastAeration <= 100L;
    }

    public void clampTemperature() {
        float airTemperature = TemperatureHelper.getBiomeTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.compostTemperature = Math.min(70.0f, Math.max(this.compostTemperature, airTemperature));
    }

    public float getCompostTemperature() {
        return this.compostTemperature;
    }

    public static float getTemperatureDeltaAtTime(float percentCooled) {
        return (float)(-2.0 / (1.0 + Math.exp(-percentCooled * 15.0f + 5.0f)) + 1.0);
    }

    public boolean isRotting() {
        if (this.getGreenAmount() <= 0) {
            return false;
        }
        return this.getBrownAmount() <= 0;
    }

    public List<Integer> getBrownSlots() {
        ArrayList<Integer> brownSlots = new ArrayList<Integer>();
        for (int slotNum = 0; slotNum < this.func_70302_i_(); ++slotNum) {
            ItemStack itemStack = this.func_70301_a(slotNum);
            if (itemStack == null || !CompostRegistry.isBrown(itemStack)) continue;
            brownSlots.add(slotNum);
        }
        return brownSlots;
    }

    public List<Integer> getGreenSlots() {
        ArrayList<Integer> greenSlots = new ArrayList<Integer>();
        for (int slotNum = 0; slotNum < this.func_70302_i_(); ++slotNum) {
            ItemStack itemStack = this.func_70301_a(slotNum);
            if (itemStack == null || !CompostRegistry.isGreen(itemStack)) continue;
            greenSlots.add(slotNum);
        }
        return greenSlots;
    }

    public int getBrownAmount() {
        return this.getBrownSlots().size();
    }

    public int getGreenAmount() {
        return this.getGreenSlots().size();
    }

    public float getCompostingSpeedMultiplier() {
        return this.getGreenToBrownRatioSpeedMultiplier() * this.getTemperatureSpeedMultiplier();
    }

    public float getGreenToBrownRatioSpeedMultiplier() {
        float normalizedDeltaFromIdealRatio = (this.getGreenToBrownRatio() - 0.6666667f) / 0.6666667f;
        if (normalizedDeltaFromIdealRatio < 0.0f) {
            return 1.0f + normalizedDeltaFromIdealRatio;
        }
        return 1.0f;
    }

    public float getTemperatureSpeedMultiplier() {
        float temperature = this.getCompostTemperature();
        if (temperature >= 45.0f) {
            float percentThermophilic = (temperature - 45.0f) / 25.0f;
            return 1.0f + percentThermophilic * 0.5f;
        }
        if (this.getCompostTemperature() >= 20.0f) {
            float percentMesophilic = (temperature - 20.0f) / 25.0f;
            return 0.5f + percentMesophilic * 0.5f;
        }
        float percentToMesophilic = Math.max(0.0f, temperature / 20.0f);
        return percentToMesophilic * 0.5f;
    }

    public float getBatchTemperatureMultiplier() {
        return 0.5f + InventoryHelper.getPercentInventoryFilled(this) * 0.5f;
    }

    public float getGreenToBrownRatio() {
        int greenAmount;
        int brownAmount = this.getBrownAmount();
        if (brownAmount + (greenAmount = this.getGreenAmount()) <= 0) {
            return 0.0f;
        }
        if (brownAmount <= 0) {
            return 1.0f;
        }
        return (float)greenAmount / (float)(brownAmount + greenAmount);
    }

    public boolean isComposting() {
        return this.compostStart != -1L;
    }

    public void startComposting() {
        this.compostStart = this.field_145850_b.func_72820_D();
        this.compostPercent = 0.0f;
    }

    public void stopComposting() {
        this.compostStart = -1L;
        this.compostPercent = 0.0f;
    }

    public void resetTemperature() {
        this.compostTemperature = TemperatureHelper.getBiomeTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.clampTemperature();
        this.func_70296_d();
    }

    protected void onSlotFilled(int slotNum) {
        if (!this.isComposting()) {
            this.startComposting();
        }
    }

    protected void onSlotEmptied(int slotNum) {
        if (this.isInventoryEmpty()) {
            this.stopComposting();
            this.resetTemperature();
        }
    }

    public void onInventoryChanged() {
        this.func_70296_d();
    }

    public boolean isInventoryEmpty() {
        for (ItemStack itemStack : this.inventoryItems) {
            if (itemStack == null) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryFull() {
        for (ItemStack itemStack : this.inventoryItems) {
            if (itemStack != null && itemStack.field_77994_a >= Math.min(this.func_70297_j_(), itemStack.func_77976_d())) continue;
            return false;
        }
        return true;
    }

    public boolean isValidSlotNum(int slotNum) {
        return slotNum < this.func_70302_i_() && slotNum >= 0;
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int slotNum) {
        if (this.isValidSlotNum(slotNum)) {
            return this.inventoryItems[slotNum];
        }
        return null;
    }

    public ItemStack func_70298_a(int slotNum, int count) {
        ItemStack itemStack = this.func_70301_a(slotNum);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= count) {
                this.func_70299_a(slotNum, null);
            } else {
                itemStack = itemStack.func_77979_a(count);
                this.onInventoryChanged();
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotNum) {
        ItemStack item = this.func_70301_a(slotNum);
        this.func_70299_a(slotNum, null);
        return item;
    }

    public void func_70299_a(int slotNum, ItemStack itemStack) {
        if (!this.isValidSlotNum(slotNum)) {
            return;
        }
        boolean wasEmpty = this.func_70301_a(slotNum) == null;
        this.inventoryItems[slotNum] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        if (wasEmpty && itemStack != null) {
            this.onSlotFilled(slotNum);
        } else if (!wasEmpty && itemStack == null) {
            this.onSlotEmptied(slotNum);
        }
        this.onInventoryChanged();
    }

    public String func_145825_b() {
        return new ItemStack(Composting.composter).func_82833_r();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotNum, ItemStack itemStack) {
        return CompostRegistry.isCompostable(itemStack) || Block.func_149634_a((Item)itemStack.func_77973_b()) == Composting.compost;
    }

    public boolean func_145842_c(int eventId, int data) {
        if (eventId == 1) {
            this.numPlayersUsing = data;
            return true;
        }
        return super.func_145842_c(eventId, data);
    }

    public void func_70295_k_() {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        ++this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        --this.numPlayersUsing;
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public void updateLidAngle() {
        float f;
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numPlayersUsing = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).func_90010_a((IInventory)this))) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_145851_c + 0.5;
            double d2 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d2, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing <= 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)this.field_145851_c + 0.5;
                double d0 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d0, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound compound = pkt.func_148857_g();
        this.lastAeration = compound.func_74763_f("LastAeration");
        super.onDataPacket(net, pkt);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("LastAeration", this.lastAeration);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74776_a("Compost", this.compostPercent);
        data.func_74772_a("LastAeration", this.lastAeration);
        data.func_74772_a("Start", this.compostStart);
        data.func_74776_a("Temperature", this.compostTemperature);
        NBTTagList items = new NBTTagList();
        for (int slotNum = 0; slotNum < this.func_70302_i_(); ++slotNum) {
            ItemStack stack = this.func_70301_a(slotNum);
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)slotNum);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        data.func_74782_a("Items", (NBTBase)items);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.compostPercent = data.func_74760_g("Compost");
        this.lastAeration = data.func_74763_f("LastAeration");
        this.compostStart = data.func_74763_f("Start");
        this.compostTemperature = data.func_74763_f("Temperature");
        NBTTagList items = data.func_150295_c("Items", 10);
        for (int slotNum = 0; slotNum < items.func_74745_c(); ++slotNum) {
            NBTTagCompound item = items.func_150305_b(slotNum);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }
}

