/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content.modifiers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import squeek.veganoption.helpers.RandomHelper;

public class CraftingModifier {
    public HashMap<ItemStack, ItemStack[]> inputsToRemoveForOutput = new HashMap();
    public HashMap<ItemStack, ItemStack[]> inputsToKeepForOutput = new HashMap();

    public CraftingModifier() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void addInputsToRemoveForOutput(ItemStack output, ItemStack ... inputs) {
        this.inputsToRemoveForOutput.put(output, inputs);
    }

    public void addInputsToRemoveForOutput(ItemStack output, String ... inputOreDicts) {
        for (String inputOreDict : inputOreDicts) {
            ArrayList oreStacks = OreDictionary.getOres((String)inputOreDict);
            if (oreStacks.size() <= 0) continue;
            this.addInputsToRemoveForOutput(output.func_77946_l(), oreStacks.toArray(new ItemStack[oreStacks.size()]));
        }
    }

    public void addInputsToKeepForOutput(ItemStack output, ItemStack ... inputs) {
        this.inputsToKeepForOutput.put(output, inputs);
    }

    public void addInputsToKeepForOutput(ItemStack output, String ... inputOreDicts) {
        for (String inputOreDict : inputOreDicts) {
            ArrayList oreStacks = OreDictionary.getOres((String)inputOreDict);
            if (oreStacks.size() <= 0) continue;
            this.addInputsToKeepForOutput(output.func_77946_l(), oreStacks.toArray(new ItemStack[oreStacks.size()]));
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        List<ItemStack> inputsToRemove = this.getInputsToRemoveForOutput(event.crafting);
        List<ItemStack> inputsToKeep = this.getInputsToKeepForOutput(event.crafting);
        if (inputsToRemove.isEmpty() && inputsToKeep.isEmpty()) {
            return;
        }
        block0: for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stackInSlot = event.craftMatrix.func_70301_a(i);
            if (stackInSlot == null) continue;
            for (ItemStack inputToRemove : inputsToRemove) {
                if (!OreDictionary.itemMatches((ItemStack)inputToRemove, (ItemStack)stackInSlot, (boolean)false)) continue;
                stackInSlot.field_77994_a -= inputToRemove.field_77994_a;
                if (stackInSlot.field_77994_a > 0) break;
                event.craftMatrix.func_70299_a(i, null);
                break;
            }
            for (ItemStack inputToKeep : inputsToKeep) {
                if (!OreDictionary.itemMatches((ItemStack)inputToKeep, (ItemStack)stackInSlot, (boolean)false)) continue;
                stackInSlot.field_77994_a += inputToKeep.field_77994_a;
                if (!stackInSlot.func_77984_f() || !stackInSlot.func_96631_a(inputToKeep.field_77994_a, RandomHelper.random)) continue block0;
                --stackInSlot.field_77994_a;
                continue block0;
            }
        }
    }

    public List<ItemStack> getInputsToRemoveForOutput(ItemStack output) {
        ArrayList<ItemStack> inputsToRemove = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, ItemStack[]> entry : this.inputsToRemoveForOutput.entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)entry.getKey(), (ItemStack)output, (boolean)false)) continue;
            inputsToRemove.addAll(Arrays.asList((Object[])entry.getValue()));
        }
        return inputsToRemove;
    }

    public List<ItemStack> getInputsToKeepForOutput(ItemStack output) {
        ArrayList<ItemStack> inputsToKeep = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, ItemStack[]> entry : this.inputsToKeepForOutput.entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)entry.getKey(), (ItemStack)output, (boolean)false)) continue;
            inputsToKeep.addAll(Arrays.asList((Object[])entry.getValue()));
        }
        return inputsToKeep;
    }
}

