/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content.modifiers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import squeek.veganoption.VeganOption;
import squeek.veganoption.helpers.MiscHelper;

public class RecipeModifier {
    public HashMap<ItemStack, String> itemToOreDictConversions = new HashMap();
    public HashMap<ItemStack, String> itemToOreDictConversionsForFoodOutputs = new HashMap();
    public HashMap<ItemStack, String> itemToOreDictConversionsForNonFoodOutputs = new HashMap();
    public HashMap<String, String> oreDictToOreDictConversions = new HashMap();
    public List<ItemStack> excludedRecipeOutputs = new ArrayList<ItemStack>();
    public static Constructor<ShapedOreRecipe> shapedOreRecipeReplaceConstructor = null;
    public static Constructor<ShapelessOreRecipe> shapelessOreRecipeReplaceConstructor = null;

    public void convertInput(ItemStack inputToConvert, String oreDictEntry) {
        this.itemToOreDictConversions.put(inputToConvert, oreDictEntry);
    }

    public void convertInputForFoodOutput(ItemStack inputToConvert, String oreDictEntry) {
        this.itemToOreDictConversionsForFoodOutputs.put(inputToConvert, oreDictEntry);
    }

    public void convertInputForNonFoodOutput(ItemStack inputToConvert, String oreDictEntry) {
        this.itemToOreDictConversionsForNonFoodOutputs.put(inputToConvert, oreDictEntry);
    }

    public void convertOreDict(String oreDictFrom, String oreDictTo) {
        this.oreDictToOreDictConversions.put(oreDictFrom, oreDictTo);
    }

    public void excludeOutput(ItemStack outputToExclude) {
        this.excludedRecipeOutputs.add(outputToExclude);
    }

    public void replaceRecipes() {
        long millisecondsStart = System.currentTimeMillis();
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<IRecipe> recipesToRemove = new ArrayList<IRecipe>();
        ArrayList<IRecipe> recipesToAdd = new ArrayList<IRecipe>();
        int recipesConverted = 0;
        for (IRecipe recipe : recipes) {
            IRecipe convertedRecipe = this.convertRecipe(recipe);
            if (convertedRecipe == null) continue;
            if (convertedRecipe != recipe) {
                recipesToRemove.add(recipe);
                recipesToAdd.add(convertedRecipe);
            }
            ++recipesConverted;
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        long timeSpentInMilliseconds = System.currentTimeMillis() - millisecondsStart;
        String timeTakenString = "took " + (float)timeSpentInMilliseconds / 1000.0f + " seconds";
        VeganOption.Log.info("Replaced " + recipesConverted + " recipes with OreDictionary'd equivalents (" + timeTakenString + ")");
    }

    public IRecipe convertRecipe(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (output == null || this.containsMatch(this.excludedRecipeOutputs, output)) {
            return null;
        }
        IRecipe convertedRecipe = this.convertRecipe(recipe, this.itemToOreDictConversions);
        if (this.isFood(output)) {
            IRecipe recipeToConvert = convertedRecipe != null ? convertedRecipe : recipe;
            IRecipe convertedFoodRecipe = this.convertRecipe(recipeToConvert, this.itemToOreDictConversionsForFoodOutputs);
            convertedRecipe = convertedFoodRecipe != null ? convertedFoodRecipe : convertedRecipe;
        } else {
            IRecipe recipeToConvert = convertedRecipe != null ? convertedRecipe : recipe;
            IRecipe convertedNonFoodRecipe = this.convertRecipe(recipeToConvert, this.itemToOreDictConversionsForNonFoodOutputs);
            convertedRecipe = convertedNonFoodRecipe != null ? convertedNonFoodRecipe : convertedRecipe;
        }
        return convertedRecipe;
    }

    public IRecipe convertRecipe(IRecipe recipe, Map<ItemStack, String> itemToOredictMap) {
        if (recipe instanceof ShapedRecipes) {
            return this.convertShapedRecipe((ShapedRecipes)recipe, itemToOredictMap);
        }
        if (recipe instanceof ShapelessRecipes) {
            return this.convertShapelessRecipe((ShapelessRecipes)recipe, itemToOredictMap);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.convertShapedOreRecipe((ShapedOreRecipe)recipe, itemToOredictMap);
        }
        if (recipe instanceof ShapelessOreRecipe) {
            return this.convertShapelessOreRecipe((ShapelessOreRecipe)recipe, itemToOredictMap);
        }
        return null;
    }

    public IRecipe convertShapedRecipe(ShapedRecipes recipe, Map<ItemStack, String> itemToOredictMap) {
        if (this.containsMatch(itemToOredictMap.keySet(), recipe.field_77574_d)) {
            try {
                ShapedOreRecipe oreRecipe = shapedOreRecipeReplaceConstructor.newInstance(recipe, itemToOredictMap);
                this.convertRecipe((IRecipe)oreRecipe);
                return oreRecipe;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public IRecipe convertShapelessRecipe(ShapelessRecipes recipe, Map<ItemStack, String> itemToOredictMap) {
        ItemStack[] recipeItems = recipe.field_77579_b.toArray(new ItemStack[recipe.field_77579_b.size()]);
        if (this.containsMatch(itemToOredictMap.keySet(), recipeItems)) {
            try {
                ShapelessOreRecipe oreRecipe = shapelessOreRecipeReplaceConstructor.newInstance(recipe, itemToOredictMap);
                this.convertRecipe((IRecipe)oreRecipe);
                return oreRecipe;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public IRecipe convertShapedOreRecipe(ShapedOreRecipe recipe, Map<ItemStack, String> itemToOredictMap) {
        Object[] inputs = recipe.getInput();
        boolean inputReplaced = false;
        for (int i = 0; i < inputs.length; ++i) {
            ArrayList inputOres;
            String currentOreDict;
            Object inputObj = inputs[i];
            if (inputObj instanceof ItemStack && this.containsMatch(itemToOredictMap.keySet(), (ItemStack)inputObj)) {
                inputs[i] = OreDictionary.getOres((String)this.getConversionFor((ItemStack)inputObj, itemToOredictMap));
                inputReplaced = true;
                continue;
            }
            if (!(inputObj instanceof ArrayList) || (currentOreDict = this.findMatchingOreDict(inputOres = (ArrayList)inputObj, this.oreDictToOreDictConversions.keySet())) == null) continue;
            String newOreDict = this.oreDictToOreDictConversions.get(currentOreDict);
            inputs[i] = OreDictionary.getOres((String)newOreDict);
            inputReplaced = true;
        }
        return inputReplaced ? recipe : null;
    }

    public IRecipe convertShapelessOreRecipe(ShapelessOreRecipe recipe, Map<ItemStack, String> itemToOredictMap) {
        ArrayList<Object> inputsToRemove = new ArrayList<Object>();
        ArrayList<ArrayList> inputsToAdd = new ArrayList<ArrayList>();
        ArrayList inputs = recipe.getInput();
        for (Object inputObj : inputs) {
            ArrayList inputOres;
            String currentOreDict;
            if (inputObj instanceof ItemStack && this.containsMatch(itemToOredictMap.keySet(), (ItemStack)inputObj)) {
                inputsToRemove.add((ItemStack)inputObj);
                inputsToAdd.add(OreDictionary.getOres((String)this.getConversionFor((ItemStack)inputObj, itemToOredictMap)));
                continue;
            }
            if (!(inputObj instanceof ArrayList) || (currentOreDict = this.findMatchingOreDict(inputOres = (ArrayList)inputObj, this.oreDictToOreDictConversions.keySet())) == null) continue;
            String newOreDict = this.oreDictToOreDictConversions.get(currentOreDict);
            inputsToRemove.add(inputObj);
            inputsToAdd.add(OreDictionary.getOres((String)newOreDict));
        }
        if (inputsToRemove.size() > 0) {
            inputs.removeAll(inputsToRemove);
            inputs.addAll(inputsToAdd);
            return recipe;
        }
        return null;
    }

    private String findMatchingOreDict(Collection<ItemStack> inputOres, Collection<String> oreDicts) {
        for (String oreDict : oreDicts) {
            if (inputOres != OreDictionary.getOres((String)oreDict)) continue;
            return oreDict;
        }
        return null;
    }

    private String getConversionFor(ItemStack itemStack, Map<ItemStack, String> itemToOreDictConversions) {
        String bestMatch = null;
        for (Map.Entry<ItemStack, String> conversion : itemToOreDictConversions.entrySet()) {
            if (conversion.getKey().func_77969_a(itemStack)) {
                return conversion.getValue();
            }
            if (!MiscHelper.wildcardItemStacksMatch(conversion.getKey(), itemStack)) continue;
            bestMatch = conversion.getValue();
        }
        return bestMatch;
    }

    private boolean containsMatch(Collection<ItemStack> inputs, ItemStack ... targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!MiscHelper.wildcardItemStacksMatch(target, input)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFood(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return false;
        }
        return itemStack.func_77973_b() instanceof ItemFood || itemStack.func_77973_b() == Items.field_151105_aU;
    }

    static {
        try {
            shapedOreRecipeReplaceConstructor = ShapedOreRecipe.class.getDeclaredConstructor(ShapedRecipes.class, Map.class);
            shapedOreRecipeReplaceConstructor.setAccessible(true);
            shapelessOreRecipeReplaceConstructor = ShapelessOreRecipe.class.getDeclaredConstructor(ShapelessRecipes.class, Map.class);
            shapelessOreRecipeReplaceConstructor.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

