/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import squeek.veganoption.VeganOption;
import squeek.veganoption.helpers.MiscHelper;

public class CompostRegistry {
    public static List<ItemStack> browns = new ArrayList<ItemStack>();
    public static List<ItemStack> greens = new ArrayList<ItemStack>();
    public static List<FoodSpecifier> uncompostableFoods = new ArrayList<FoodSpecifier>();

    public static void registerAllFoods() {
        long millisecondsStart = System.currentTimeMillis();
        int numRegistered = 0;
        for (Object obj : Item.field_150901_e) {
            Item item = (Item)obj;
            if (item == null || !CompostRegistry.isCompostableFood(new ItemStack(item))) continue;
            CompostRegistry.addGreen(item);
            ++numRegistered;
        }
        long timeSpentInMilliseconds = System.currentTimeMillis() - millisecondsStart;
        String timeTakenString = "took " + (float)timeSpentInMilliseconds / 1000.0f + " seconds";
        VeganOption.Log.info("Found and registered " + numRegistered + " compostable foods (" + timeTakenString + ")");
    }

    public static boolean isCompostable(ItemStack itemStack) {
        return CompostRegistry.isGreen(itemStack) || CompostRegistry.isBrown(itemStack);
    }

    public static boolean isBrown(ItemStack itemStack) {
        return MiscHelper.isItemStackInList(browns, itemStack);
    }

    public static boolean isGreen(ItemStack itemStack) {
        return MiscHelper.isItemStackInList(greens, itemStack);
    }

    public static boolean isCompostableFood(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemFood && itemStack.func_77973_b().func_77668_q() == null) {
            for (FoodSpecifier uncompostableFood : uncompostableFoods) {
                if (!uncompostableFood.matches(itemStack)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void addBrown(Item item) {
        CompostRegistry.addBrown(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static void addBrown(Block block) {
        CompostRegistry.addBrown(new ItemStack(block, 1, Short.MAX_VALUE));
    }

    public static void addBrown(ItemStack itemStack) {
        browns.add(itemStack);
    }

    public static void addBrown(String oredictName) {
        browns.addAll(OreDictionary.getOres((String)oredictName));
    }

    public static void addGreen(Item item) {
        CompostRegistry.addGreen(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static void addGreen(Block block) {
        CompostRegistry.addGreen(new ItemStack(block, 1, Short.MAX_VALUE));
    }

    public static void addGreen(ItemStack itemStack) {
        greens.add(itemStack);
    }

    public static void addGreen(String oredictName) {
        greens.addAll(OreDictionary.getOres((String)oredictName));
    }

    public static void blacklist(FoodSpecifier foodSpecifier) {
        uncompostableFoods.add(foodSpecifier);
    }

    public static abstract class FoodSpecifier {
        public abstract boolean matches(ItemStack var1);
    }
}

