/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.entities;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import squeek.veganoption.content.modules.FrozenBubble;
import squeek.veganoption.helpers.BlockHelper;
import squeek.veganoption.helpers.RandomHelper;
import squeek.veganoption.helpers.TemperatureHelper;
import squeek.veganoption.network.MessageFX;
import squeek.veganoption.network.NetworkHandler;

public class EntityBubble
extends EntityThrowable {
    public static final int LIFETIME_BASE = 40;
    public static final int LIFETIME_MAX = 80;
    public static final float FREEZING_TEMPERATURE = -15.0f;
    public static final int TEMPERATURE_CHECK_RADIUS = 3;
    public int lifetime = RandomHelper.getRandomIntFromRange(40, 80);
    public float temperature;

    public EntityBubble(World world) {
        super(world);
    }

    public EntityBubble(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityBubble(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.temperature = TemperatureHelper.getBiomeTemperature(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        this.pop();
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa >= this.lifetime || this.func_70090_H())) {
            this.pop();
            return;
        }
        float surroundingTemp = EntityBubble.getSurroundingAirTemperature(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.temperature += (surroundingTemp - this.temperature) * 0.05f;
        if (!this.field_70170_p.field_72995_K && this.temperature <= -15.0f) {
            this.freeze();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
            this.field_70159_w += (double)(0.1f * (RandomHelper.random.nextFloat() - 0.5f));
            this.field_70181_x += (double)(0.1f * (RandomHelper.random.nextFloat() - 0.5f));
            this.field_70179_y += (double)(0.1f * (RandomHelper.random.nextFloat() - 0.5f));
        }
        super.func_70071_h_();
        if (this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y > (double)0.025f) {
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
        }
    }

    protected float func_70182_d() {
        return 0.3f;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void pop() {
        if (!this.field_70170_p.field_72995_K) {
            NetworkRegistry.TargetPoint target = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 80.0);
            NetworkHandler.channel.sendToAllAround((IMessage)new MessageFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, MessageFX.FX.BUBBLE_POP), target);
            this.func_70106_y();
        }
    }

    public void freeze() {
        if (!this.field_70170_p.field_72995_K) {
            EntityItem frozenBubble = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(FrozenBubble.frozenBubble));
            this.field_70170_p.func_72838_d((Entity)frozenBubble);
            this.func_70106_y();
        }
    }

    protected void func_70184_a(MovingObjectPosition movingObjectPosition) {
        this.pop();
    }

    public static float getSurroundingAirTemperature(World world, double x, double y, double z) {
        BlockHelper.BlockPos[] surroundingBlocks;
        float airTemperature = TemperatureHelper.getBiomeTemperature(world, (int)x, (int)y, (int)z);
        for (BlockHelper.BlockPos blockPos : surroundingBlocks = BlockHelper.getBlocksInRadiusAround(new BlockHelper.BlockPos(world, (int)x, (int)y, (int)z), 3)) {
            Block block = blockPos.getBlock();
            if (block == Blocks.field_150350_a) {
                airTemperature -= 0.01f;
                continue;
            }
            if (block == Blocks.field_150433_aE) {
                airTemperature -= 0.1f;
                continue;
            }
            if (block == Blocks.field_150432_aD) {
                airTemperature -= 0.5f;
                continue;
            }
            if (block == Blocks.field_150403_cj) {
                airTemperature -= 1.0f;
                continue;
            }
            if (block == Blocks.field_150353_l) {
                airTemperature += 3.0f;
                continue;
            }
            if (block != Blocks.field_150478_aa) continue;
            airTemperature += 0.5f;
        }
        return airTemperature;
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.temperature = tag.func_74760_g("temperature");
        this.lifetime = tag.func_74762_e("lifetime");
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("temperature", this.temperature);
        tag.func_74768_a("lifetime", this.lifetime);
    }
}

