/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.helpers;

import cpw.mods.fml.common.registry.GameData;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MiscHelper {
    public static final int MAX_REDSTONE_SIGNAL_STRENGTH = 15;
    public static final int TICKS_PER_SEC = 20;
    public static final int TICKS_PER_DAY = 24000;

    public static boolean wildcardItemStacksMatch(ItemStack a, ItemStack b) {
        return OreDictionary.itemMatches((ItemStack)a, (ItemStack)b, (boolean)false) || OreDictionary.itemMatches((ItemStack)b, (ItemStack)a, (boolean)false);
    }

    public static boolean isItemStackInList(Collection<ItemStack> haystack, ItemStack needle) {
        return MiscHelper.isItemStackInList(haystack, needle, false);
    }

    public static boolean isItemStackInList(Collection<ItemStack> haystack, ItemStack needle, boolean strict) {
        return MiscHelper.getMatchingItemStackFromList(haystack, needle, strict) != null;
    }

    public static ItemStack getMatchingItemStackFromList(Collection<ItemStack> haystack, ItemStack needle) {
        return MiscHelper.getMatchingItemStackFromList(haystack, needle, false);
    }

    public static ItemStack getMatchingItemStackFromList(Collection<ItemStack> haystack, ItemStack needle, boolean strict) {
        if (haystack != null) {
            for (ItemStack itemStack : haystack) {
                if (strict && OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)needle, (boolean)strict)) {
                    return itemStack;
                }
                if (strict || !MiscHelper.wildcardItemStacksMatch(itemStack, needle)) continue;
                return itemStack;
            }
        }
        return null;
    }

    public static Item getItemByName(String name) {
        return (Item)GameData.getItemRegistry().func_82594_a(name);
    }

    public static Block getBlockByName(String name) {
        return (Block)GameData.getBlockRegistry().func_82594_a(name);
    }

    public static ItemStack getItemStackByObjectName(String name) {
        Item item = MiscHelper.getItemByName(name);
        if (item != null) {
            return new ItemStack(item);
        }
        Block block = MiscHelper.getBlockByName(name);
        if (block != null) {
            return new ItemStack(block);
        }
        return null;
    }
}

