/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import squeek.veganoption.content.Modifiers;
import squeek.veganoption.content.modifiers.DropsModifier;
import squeek.veganoption.helpers.LangHelper;

public class DropsHandler
extends TemplateRecipeHandler {
    public static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static final int WIDTH = 166;
    public static final int PADDING = 4;
    ItemStack itemStack = null;
    List<DropsModifier.DropInfo> blockDropSpecifiers = null;
    boolean isUsage;
    public static Method transferRectTooltip;
    public static Method transferRect;

    public DropsHandler() {
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 16, 22, 15), this.getOverlayIdentifier(), new Object[0]));
        super.loadTransferRects();
    }

    public String getOverlayIdentifier() {
        return "VeganOption.drops";
    }

    public DropsHandler(ItemStack itemStack, boolean isUsage) {
        this.itemStack = itemStack.func_77946_l();
        this.itemStack.field_77994_a = 1;
        this.isUsage = isUsage;
        this.blockDropSpecifiers = isUsage ? Modifiers.drops.getSubsetByBlock(this.itemStack) : Modifiers.drops.getSubsetByDroppedItem(this.itemStack);
    }

    public boolean isApplicable(ItemStack itemStack) {
        return Modifiers.drops.dropExists(itemStack) || Modifiers.drops.hasDrops(itemStack);
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.blockDropSpecifiers = Modifiers.drops.getAllDrops();
            return this;
        }
        if (outputId.equals("item")) {
            for (Object result : results) {
                if (!(result instanceof ItemStack) || !this.isApplicable((ItemStack)result)) continue;
                return new DropsHandler((ItemStack)result, false);
            }
        }
        return super.getRecipeHandler(outputId, results);
    }

    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        if (inputId.equals(this.getOverlayIdentifier())) {
            this.blockDropSpecifiers = Modifiers.drops.getAllDrops();
            return this;
        }
        if (inputId.equals("item")) {
            for (Object ingredient : ingredients) {
                if (!(ingredient instanceof ItemStack) || !this.isApplicable((ItemStack)ingredient)) continue;
                return new DropsHandler((ItemStack)ingredient, true);
            }
        }
        return super.getUsageHandler(inputId, ingredients);
    }

    public String getRecipeName() {
        return LangHelper.translate("nei.drops");
    }

    public int numRecipes() {
        return this.blockDropSpecifiers != null ? this.blockDropSpecifiers.size() : 0;
    }

    public Point getRecipePosition(int recipe) {
        return new Point(83, 16 + -(recipe % this.recipiesPerPage() > 0 ? recipe % this.recipiesPerPage() * 24 : 0));
    }

    public void drawBackground(int recipe) {
    }

    public void drawForeground(int recipe) {
        Point recipePos = this.getRecipePosition(recipe);
        int x = recipePos.x;
        int y = recipePos.y + 4;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)"textures/gui/container/crafting_table.png");
        GuiDraw.drawTexturedModalRect((int)(x - 11), (int)y, (int)90, (int)35, (int)22, (int)15);
        String dropChance = String.format("%.0f%%", Float.valueOf(this.blockDropSpecifiers.get((int)recipe).drop.dropChance * 100.0f));
        GuiDraw.drawString((String)dropChance, (int)(x - GuiDraw.getStringWidth((String)dropChance) / 2), (int)(y - DropsHandler.fontRenderer.field_78288_b), (int)0x8B8B8B, (boolean)false);
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        ArrayList<PositionedStack> positionedStacks = new ArrayList<PositionedStack>();
        if (this.blockDropSpecifiers != null) {
            Point recipePos = this.getRecipePosition(recipe);
            int x = recipePos.x - 36;
            int y = recipePos.y;
            DropsModifier.BlockSpecifier blockSpecifier = this.blockDropSpecifiers.get((int)recipe).dropper;
            ItemStack blockStack = blockSpecifier.neiItemStack != null ? blockSpecifier.neiItemStack : new ItemStack(blockSpecifier.block, 1, blockSpecifier.meta);
            positionedStacks.add(new PositionedStack((Object)blockStack, x, y, false));
        }
        return positionedStacks;
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        ArrayList<PositionedStack> positionedStacks = new ArrayList<PositionedStack>();
        return positionedStacks;
    }

    public PositionedStack getResultStack(int recipe) {
        if (this.blockDropSpecifiers != null) {
            Point recipePos = this.getRecipePosition(recipe);
            int x = recipePos.x + 18;
            int y = recipePos.y;
            DropsModifier.DropSpecifier dropSpecifier = this.blockDropSpecifiers.get((int)recipe).drop;
            ItemStack drop = dropSpecifier.itemStack.func_77946_l();
            int ticksPerStackSize = 20;
            drop.field_77994_a = dropSpecifier.dropsMin + this.cycleticks / ticksPerStackSize % (dropSpecifier.dropsMax + 1 - dropSpecifier.dropsMin);
            if (drop.field_77994_a > 0) {
                return new PositionedStack((Object)drop, x, y, false);
            }
        }
        return null;
    }

    public int recipiesPerPage() {
        return 3;
    }

    public String getGuiTexture() {
        return null;
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)gui) && currenttip.size() == 0) {
            Point offset = gui.getRecipePosition(recipe);
            Point offsetOffset = this.getRecipePosition(recipe);
            Point realOffset = new Point(offset.x + offsetOffset.x - 83, offset.y + offsetOffset.y - 12);
            try {
                currenttip = (List)transferRectTooltip.invoke(null, gui, this.transferRects, realOffset.x, realOffset.y, currenttip);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return currenttip;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0) {
            return this.transferRect(gui, recipe, false);
        }
        if (button == 1) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    private boolean transferRect(GuiRecipe gui, int recipe, boolean usage) {
        Point offset = gui.getRecipePosition(recipe);
        Point offsetOffset = this.getRecipePosition(recipe);
        Point realOffset = new Point(offset.x + offsetOffset.x - 83, offset.y + offsetOffset.y - 12);
        try {
            return (Boolean)transferRect.invoke(null, gui, this.transferRects, realOffset.x, realOffset.y, usage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        try {
            transferRectTooltip = TemplateRecipeHandler.class.getDeclaredMethod("transferRectTooltip", GuiContainer.class, Collection.class, Integer.TYPE, Integer.TYPE, List.class);
            transferRectTooltip.setAccessible(true);
            transferRect = TemplateRecipeHandler.class.getDeclaredMethod("transferRect", GuiContainer.class, Collection.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            transferRect.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

